/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantitiesToolkit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;

public class XYChart {
    private static final String ELLIPSIS = "...";
    private static final Color SELECTION_COLOR = new Color(255, 255, 255, 220);
    private static final Color RANGE_INDICATION_COLOR = new Color(255, 60, 20);
    private static final int Y_OFFSET = 35;
    private static final int RANGE_INDICATOR_HEIGHT = 4;
    private final IQuantity start;
    private final IQuantity end;
    private IXDataRenderer rendererRoot;
    private IRenderedRow rendererResult;
    private final int xOffset;
    private final int bucketWidth;
    private IQuantity currentStart;
    private IQuantity currentEnd;
    private final Set<Object> selectedRows = new HashSet<Object>();
    private IQuantity selectionStart;
    private IQuantity selectionEnd;
    private SubdividedQuantityRange xBucketRange;
    private SubdividedQuantityRange xTickRange;
    private int axisWidth;
    private List<Consumer<IRange<IQuantity>>> rangeListeners = new ArrayList<Consumer<IRange<IQuantity>>>();

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot);
    }

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot, int xOffset) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot, xOffset);
    }

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot, int xOffset, int bucketWidth) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot, xOffset, bucketWidth);
    }

    public XYChart(IQuantity start, IQuantity end, IXDataRenderer rendererRoot) {
        this(start, end, rendererRoot, 60);
    }

    public XYChart(IQuantity start, IQuantity end, IXDataRenderer rendererRoot, int xOffset) {
        this(start, end, rendererRoot, xOffset, 25);
    }

    public XYChart(IQuantity start, IQuantity end, IXDataRenderer rendererRoot, int xOffset, int bucketWidth) {
        this.rendererRoot = rendererRoot;
        assert (start.compareTo((Object)end) < 0);
        this.currentStart = start;
        this.start = start;
        this.currentEnd = end;
        this.end = end;
        this.xOffset = xOffset;
        this.bucketWidth = bucketWidth;
    }

    public void setRendererRoot(IXDataRenderer rendererRoot) {
        this.clearSelection();
        this.rendererRoot = rendererRoot;
    }

    public IXDataRenderer getRendererRoot() {
        return this.rendererRoot;
    }

    public Object[] getSelectedRows() {
        return this.selectedRows.toArray(new Object[this.selectedRows.size()]);
    }

    public IQuantity getSelectionStart() {
        return this.selectionStart;
    }

    public IQuantity getSelectionEnd() {
        return this.selectionEnd;
    }

    public IRange<IQuantity> getSelectionRange() {
        return this.selectionStart != null && this.selectionEnd != null ? QuantityRange.createWithEnd((IQuantity)this.selectionStart, (IQuantity)this.selectionEnd) : null;
    }

    public void render(Graphics2D context, int width, int height) {
        if (width > this.xOffset && height > 35) {
            this.axisWidth = width - this.xOffset;
            this.xBucketRange = new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, this.bucketWidth);
            this.xTickRange = new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, 100);
            AffineTransform oldTransform = context.getTransform();
            context.translate(this.xOffset, 0);
            this.doRender(context, height - 35);
            context.setTransform(oldTransform);
        }
    }

    private void renderRangeIndication(Graphics2D context, int rangeIndicatorY) {
        SubdividedQuantityRange fullRangeAxis = new SubdividedQuantityRange(this.start, this.end, this.axisWidth, 25);
        int x1 = (int)fullRangeAxis.getPixel(this.currentStart);
        int x2 = (int)Math.ceil(fullRangeAxis.getPixel(this.currentEnd));
        if (x1 > 0 || x2 < this.axisWidth) {
            context.setPaint(RANGE_INDICATION_COLOR);
            context.fillRect(x1, rangeIndicatorY, x2 - x1, 4);
            context.setPaint(Color.DARK_GRAY);
            context.drawRect(0, rangeIndicatorY, this.axisWidth - 1, 4);
        }
    }

    private void doRender(Graphics2D context, int axisHeight) {
        context.setPaint(Color.LIGHT_GRAY);
        AWTChartToolkit.drawGrid(context, this.xTickRange, axisHeight, false);
        context.setPaint(Color.BLACK);
        AWTChartToolkit.drawAxis(context, this.xTickRange, axisHeight - 1, false, 1 - this.xOffset, false);
        this.rendererResult = this.rendererRoot.render(context, this.xBucketRange, axisHeight);
        AffineTransform oldTransform = context.getTransform();
        this.renderText(context, this.rendererResult);
        context.setTransform(oldTransform);
        if (!this.selectedRows.isEmpty()) {
            this.renderSelection(context, this.rendererResult);
            context.setTransform(oldTransform);
        }
        context.setPaint(new Color(0, 0, 0, 64));
        context.drawLine(0, axisHeight - 1, this.axisWidth - 1, axisHeight - 1);
        this.renderRangeIndication(context, axisHeight + 25);
    }

    private void renderSelection(Graphics2D context, IRenderedRow row) {
        if (this.selectedRows.contains(row.getPayload())) {
            this.renderSelection(context, this.xBucketRange, row.getHeight());
        } else {
            List<IRenderedRow> subdivision = row.getNestedRows();
            if (subdivision.isEmpty()) {
                XYChart.dimRect(context, 0, this.axisWidth, row.getHeight());
            } else {
                for (IRenderedRow nestedRow : row.getNestedRows()) {
                    this.renderSelection(context, nestedRow);
                }
                return;
            }
        }
        context.translate(0, row.getHeight());
    }

    private void renderText(Graphics2D context, IRenderedRow row) {
        String text = row.getName();
        int height = row.getHeight();
        if (height > 20) {
            if (text != null) {
                int charsWidth;
                context.setColor(Color.BLACK);
                if (height > 40) {
                    context.drawLine(-this.xOffset, height - 1, -15, height - 1);
                }
                if ((charsWidth = context.getFontMetrics().charsWidth(text.toCharArray(), 0, text.length())) > this.xOffset) {
                    float fitRatio = (float)this.xOffset / (float)(charsWidth + context.getFontMetrics().charsWidth(ELLIPSIS.toCharArray(), 0, ELLIPSIS.length()));
                    text = String.valueOf(text.substring(0, (int)((float)text.length() * fitRatio) - 1)) + ELLIPSIS;
                }
                context.drawString(text, -this.xOffset + 2, height - 4);
            } else {
                List<IRenderedRow> subdivision = row.getNestedRows();
                if (!subdivision.isEmpty()) {
                    for (IRenderedRow nestedRow : row.getNestedRows()) {
                        this.renderText(context, nestedRow);
                    }
                    return;
                }
            }
        }
        context.translate(0, height);
    }

    public boolean pan(int rightPercent) {
        if (this.xBucketRange != null) {
            IQuantity oldStart = this.currentStart;
            IQuantity oldEnd = this.currentEnd;
            if (rightPercent > 0) {
                this.currentEnd = (IQuantity)QuantitiesToolkit.min((Comparable)this.xBucketRange.getQuantityAtPixel(this.axisWidth + this.axisWidth * rightPercent / 100), (Comparable)this.end);
                this.currentStart = (IQuantity)QuantitiesToolkit.max((Comparable)this.xBucketRange.getQuantityAtPixel(this.xBucketRange.getPixel(this.currentEnd) - (double)this.axisWidth), (Comparable)this.start);
            } else if (rightPercent < 0) {
                this.currentStart = (IQuantity)QuantitiesToolkit.max((Comparable)this.xBucketRange.getQuantityAtPixel(this.axisWidth * rightPercent / 100), (Comparable)this.start);
                this.currentEnd = (IQuantity)QuantitiesToolkit.min((Comparable)this.xBucketRange.getQuantityAtPixel(this.xBucketRange.getPixel(this.currentStart) + (double)this.axisWidth), (Comparable)this.end);
            }
            return this.currentStart.compareTo((Object)oldStart) != 0 || this.currentEnd.compareTo((Object)oldEnd) != 0;
        }
        return true;
    }

    public boolean zoom(int zoomInSteps) {
        return this.zoomXAxis(this.axisWidth / 2, zoomInSteps);
    }

    public boolean zoom(int x, int zoomInSteps) {
        return this.zoomXAxis(x - this.xOffset, zoomInSteps);
    }

    private boolean zoomXAxis(int x, int zoomInSteps) {
        if (this.xBucketRange == null) {
            return true;
        }
        if (x > 0 && x < this.axisWidth) {
            IQuantity oldStart = this.currentStart;
            IQuantity oldEnd = this.currentEnd;
            double zoomFactor = Math.atan(zoomInSteps) / Math.PI;
            int newStart = (int)(zoomFactor * (double)x);
            int newEnd = (int)((double)this.axisWidth * (1.0 - zoomFactor)) + newStart;
            SubdividedQuantityRange xAxis = new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, 1);
            this.setVisibleRange(xAxis.getQuantityAtPixel(newStart), xAxis.getQuantityAtPixel(newEnd));
            return this.currentStart.compareTo((Object)oldStart) != 0 || this.currentEnd.compareTo((Object)oldEnd) != 0;
        }
        return false;
    }

    public void setVisibleRange(IQuantity rangeStart, IQuantity rangeEnd) {
        if ((rangeStart = (IQuantity)QuantitiesToolkit.max((Comparable)rangeStart, (Comparable)this.start)).compareTo((Object)(rangeEnd = (IQuantity)QuantitiesToolkit.min((Comparable)rangeEnd, (Comparable)this.end))) < 0) {
            SubdividedQuantityRange testRange = new SubdividedQuantityRange(rangeStart, rangeEnd, 10000, 1);
            if (testRange.getQuantityAtPixel(0).compareTo((Object)testRange.getQuantityAtPixel(1)) < 0) {
                this.currentStart = rangeStart;
                this.currentEnd = rangeEnd;
            } else {
                this.currentStart = (IQuantity)QuantitiesToolkit.min((Comparable)rangeStart, (Comparable)this.currentStart);
                this.currentEnd = (IQuantity)QuantitiesToolkit.max((Comparable)rangeEnd, (Comparable)this.currentEnd);
            }
            this.rangeListeners.stream().forEach(l -> l.accept(this.getVisibleRange()));
        }
    }

    public void addVisibleRangeListener(Consumer<IRange<IQuantity>> rangeListener) {
        this.rangeListeners.add(rangeListener);
    }

    public IRange<IQuantity> getVisibleRange() {
        return this.currentStart != null && this.currentEnd != null ? QuantityRange.createWithEnd((IQuantity)this.currentStart, (IQuantity)this.currentEnd) : null;
    }

    public void clearVisibleRange() {
        this.currentStart = this.start;
        this.currentEnd = this.end;
    }

    public boolean select(int x1, int x2, int y1, int y2) {
        int xStart = Math.min(x1, x2) - this.xOffset;
        int xEnd = Math.max(x1, x2) - this.xOffset;
        if (this.xBucketRange != null && xEnd >= 0) {
            return this.select(this.xBucketRange.getQuantityAtPixel(Math.max(0, xStart)), this.xBucketRange.getQuantityAtPixel(xEnd), y1, y2);
        }
        return this.select(null, null, y1, y2);
    }

    public boolean select(IQuantity xStart, IQuantity xEnd, int y1, int y2) {
        if (xStart != null && xStart.compareTo((Object)this.start) < 0) {
            xStart = this.start;
        }
        if (xEnd != null && xEnd.compareTo((Object)this.end) > 0) {
            xEnd = this.end;
        }
        HashSet<Object> oldRows = null;
        if (QuantitiesToolkit.same((Comparable)this.selectionStart, (Comparable)xStart) && QuantitiesToolkit.same((Comparable)this.selectionEnd, (Comparable)xEnd)) {
            oldRows = new HashSet<Object>(this.selectedRows);
        }
        this.selectedRows.clear();
        this.addSelectedRows(this.rendererResult, 0, Math.min(y1, y2), Math.max(y1, y2));
        this.selectionStart = xStart;
        this.selectionEnd = xEnd;
        return oldRows == null || !oldRows.equals(this.selectedRows);
    }

    public boolean clearSelection() {
        if (this.selectionStart == null && this.selectionEnd == null && this.selectedRows.isEmpty()) {
            return false;
        }
        this.selectedRows.clear();
        this.selectionEnd = null;
        this.selectionStart = null;
        return true;
    }

    private boolean addSelectedRows(IRenderedRow row, int yRowStart, int ySelectionStart, int ySelectionEnd) {
        List<IRenderedRow> subdivision = row.getNestedRows();
        if (subdivision.isEmpty()) {
            return this.addPayload(row);
        }
        boolean nestedHasPayload = false;
        for (IRenderedRow nestedRow : row.getNestedRows()) {
            int yRowEnd = yRowStart + nestedRow.getHeight();
            if (yRowStart > ySelectionEnd) break;
            if (yRowEnd > ySelectionStart) {
                nestedHasPayload |= this.addSelectedRows(nestedRow, yRowStart, ySelectionStart, ySelectionEnd);
            }
            yRowStart = yRowEnd;
        }
        return nestedHasPayload || this.addPayload(row);
    }

    private boolean addPayload(IRenderedRow row) {
        Object payload = row.getPayload();
        if (payload != null) {
            this.selectedRows.add(payload);
            return true;
        }
        return false;
    }

    private void renderSelection(Graphics2D context, SubdividedQuantityRange xRange, int height) {
        int selFrom = 0;
        int selTo = this.axisWidth;
        if (this.selectionStart != null && this.selectionEnd != null) {
            selFrom = (int)xRange.getPixel(this.selectionStart);
            selTo = (int)xRange.getPixel(this.selectionEnd);
        }
        if (selFrom > 0) {
            XYChart.dimRect(context, 0, selFrom, height);
            context.setColor(Color.BLACK);
            context.drawLine(selFrom, 0, selFrom, height);
        }
        if (selTo < this.axisWidth) {
            XYChart.dimRect(context, selTo, this.axisWidth - selTo, height);
            context.setColor(Color.BLACK);
            context.drawLine(selTo, 0, selTo, height);
        }
    }

    private static void dimRect(Graphics2D context, int from, int width, int height) {
        context.setColor(SELECTION_COLOR);
        context.fillRect(from, 0, width, height);
    }

    public void infoAt(IChartInfoVisitor visitor, int x, int y) {
        if (this.rendererResult == null) {
            return;
        }
        int height = this.rendererResult.getHeight();
        if (y < height) {
            this.rendererResult.infoAt(visitor, x - this.xOffset, y, new Point(this.xOffset, 0));
        } else if ((x -= this.xOffset) >= 0) {
            int tickIndex = this.xTickRange.getClosestSubdividerAtPixel(x);
            double tickX = this.xTickRange.getSubdividerPixel(tickIndex);
            int bucketIndex = this.xBucketRange.getClosestSubdividerAtPixel(x);
            double bucketX = this.xBucketRange.getSubdividerPixel(bucketIndex);
            if (Math.abs((double)x - bucketX) < Math.abs((double)x - tickX)) {
                visitor.visit(this.tickFor(this.xBucketRange, bucketIndex));
            } else {
                visitor.visit(this.tickFor(this.xTickRange, tickIndex));
            }
        }
    }

    private IChartInfoVisitor.ITick tickFor(final SubdividedQuantityRange xRange, final int index) {
        return new IChartInfoVisitor.ITick(){

            @Override
            public IDisplayable getValue() {
                return xRange.getSubdivider(index);
            }

            @Override
            public Point2D getTarget() {
                return new Point(XYChart.this.xOffset + (int)xRange.getSubdividerPixel(index), XYChart.this.rendererResult.getHeight() - 1);
            }
        };
    }
}

