/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.Messages;
import org.openjdk.jmc.ui.column.TableSettings;

public class ColumnManager {
    private static final int DEFAULT_WIDTH = 150;
    private static final boolean DEFAULT_HIDDEN = false;
    private static final boolean DEFAULT_SORT_ASC = true;
    private final List<ColumnEntry> addedColumns;
    private final ColumnViewer viewer;
    private ColumnEntry sortColumn;
    private final Listener customDrawer = new Listener(){

        public void handleEvent(Event event) {
            Item[] columnWidgets = ColumnManager.this.getColumnWidgets();
            if (event.index < columnWidgets.length) {
                Item colWidget = columnWidgets[event.index];
                for (ColumnEntry ce : ColumnManager.this.addedColumns) {
                    Listener drawer;
                    if (ce.ui == null || colWidget != ColumnManager.getColumnWidget(ce.ui) || (drawer = ce.getColumn().getColumnDrawer()) == null) continue;
                    drawer.handleEvent(event);
                }
            }
        }
    };
    private final Consumer<ColumnComparator> onSortChange;

    private static Boolean getNullForDefault(boolean hidden) {
        return !hidden ? null : Boolean.valueOf(hidden);
    }

    public static ColumnManager build(TableViewer viewer, List<IColumn> columns, TableSettings ts) {
        return ColumnManager.build((ColumnViewer)viewer, columns, ts, arg_0 -> ((TableViewer)viewer).setComparator(arg_0));
    }

    public static ColumnManager build(TableViewer viewer, List<IColumn> columns, TableSettings ts, Consumer<ColumnComparator> onSortChange) {
        return ColumnManager.build((ColumnViewer)viewer, columns, ts, onSortChange);
    }

    public static ColumnManager build(TreeViewer viewer, List<IColumn> columns, TableSettings ts) {
        return ColumnManager.build((ColumnViewer)viewer, columns, ts, arg_0 -> ((TreeViewer)viewer).setComparator(arg_0));
    }

    public static ColumnManager build(TreeViewer viewer, List<IColumn> columns, TableSettings ts, Consumer<ColumnComparator> onSortChange) {
        return ColumnManager.build((ColumnViewer)viewer, columns, ts, onSortChange);
    }

    private static ColumnManager build(ColumnViewer viewer, List<IColumn> columns, TableSettings ts, Consumer<ColumnComparator> onSortChange) {
        ArrayList<ColumnEntry> entries = new ArrayList<ColumnEntry>();
        String sortColumn = null;
        if (ts != null) {
            LinkedHashMap<String, IColumn> columnsMap = new LinkedHashMap<String, IColumn>();
            for (IColumn c : columns) {
                columnsMap.put(c.getId(), c);
            }
            if (ts.getOrderBy() != null && columnsMap.containsKey(ts.getOrderBy())) {
                sortColumn = ts.getOrderBy();
            }
            for (TableSettings.ColumnSettings cc : ts.getColumns()) {
                IColumn c = (IColumn)columnsMap.remove(cc.getId());
                if (c == null) continue;
                entries.add(new ColumnEntry(c, cc.isHidden(), cc.getWidth(), cc.isSortAscending()));
            }
            for (IColumn c : columnsMap.values()) {
                entries.add(new ColumnEntry(c, ColumnManager.getNullForDefault(true), null, null));
            }
        } else {
            for (IColumn c : columns) {
                entries.add(new ColumnEntry(c, ColumnManager.getNullForDefault(false), null, null));
            }
        }
        return new ColumnManager(viewer, sortColumn, entries, onSortChange);
    }

    ColumnManager(ColumnViewer viewer, String sortColumnId, List<ColumnEntry> columns, Consumer<ColumnComparator> onSortChange) {
        this.viewer = viewer;
        this.addedColumns = columns;
        this.onSortChange = onSortChange;
        this.setLinesVisible(true);
        this.setHeaderVisible(true);
        viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Messages.ALL_COLUMNS_HIDDEN_LABEL;
            }

            public Font getFont(Object element) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }

            public Color getForeground(Object element) {
                return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
            }
        });
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ColumnManager.this.updateColumnOrder();
            }
        });
        for (ColumnEntry ce : this.addedColumns) {
            if (ce.hidden != null && ce.hidden.booleanValue()) continue;
            this.createColumnUi(ce);
        }
        this.updateEraseItemListener();
        if (sortColumnId != null) {
            this.setSortColumn(sortColumnId);
        }
    }

    private void updateEraseItemListener() {
        for (ColumnEntry c : this.addedColumns) {
            if (!c.isVisible() || c.getColumn().getColumnDrawer() == null) continue;
            Listener[] listenerArray = this.viewer.getControl().getListeners(40);
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener l = listenerArray[n2];
                if (l == this.customDrawer) {
                    return;
                }
                ++n2;
            }
            this.viewer.getControl().addListener(40, this.customDrawer);
            return;
        }
        this.viewer.getControl().removeListener(40, this.customDrawer);
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    void setColumnHidden(String columnId, boolean hidden) {
        this.updateColumnOrder();
        ColumnEntry columnEntry = this.getColumnEntry(columnId);
        columnEntry.hidden = hidden;
        if (hidden) {
            columnEntry.doHide();
            this.updateEraseItemListener();
        } else {
            this.createColumnUi(columnEntry);
            this.updateEraseItemListener();
            this.getViewer().refresh();
        }
        this.getViewer().getControl().getParent().layout();
    }

    private void createColumnUi(ColumnEntry columnEntry) {
        Item columnWidget = columnEntry.create(this.viewer, this.countVisibleColumnsBefore(columnEntry));
        columnWidget.addListener(13, e -> this.changeOrFlipSortColumn(columnEntry));
    }

    private int countVisibleColumnsBefore(ColumnEntry columnEntry) {
        int i = 0;
        for (ColumnEntry c : this.addedColumns) {
            if (c == columnEntry) {
                return i;
            }
            if (!c.isVisible()) continue;
            ++i;
        }
        return i;
    }

    private void updateColumnOrder() {
        if (this.viewer instanceof TableViewer) {
            Table table = ((TableViewer)this.viewer).getTable();
            this.updateColumnOrder((Widget[])table.getColumns(), table.getColumnOrder());
        } else {
            Tree tree = ((TreeViewer)this.viewer).getTree();
            this.updateColumnOrder((Widget[])tree.getColumns(), tree.getColumnOrder());
        }
    }

    private void updateColumnOrder(Widget[] columns, int[] order) {
        int visibleIndex = 0;
        int i = 0;
        while (i < this.addedColumns.size()) {
            Item v1;
            Widget v2;
            ColumnEntry e = this.addedColumns.get(i);
            if (e.isVisible() && (v2 = columns[order[visibleIndex++]]) != (v1 = ColumnManager.getColumnWidget(e.ui))) {
                int j = i;
                while (j < this.addedColumns.size()) {
                    ColumnEntry e2 = this.addedColumns.get(j);
                    if (e2.ui != null && v2 == ColumnManager.getColumnWidget(e2.ui)) {
                        this.addedColumns.set(i, e2);
                        this.addedColumns.set(j, e);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void changeOrFlipSortColumn(ColumnEntry entry) {
        if (this.sortColumn == entry) {
            this.setSortColumn(entry, !entry.isSortAscendingPreferred());
        } else {
            this.setSortColumn(entry, entry.isSortAscendingPreferred());
        }
    }

    public void clearSortColumn() {
        this.sortColumn = null;
        this.setSortColumn(null, 128);
    }

    public void setSortColumn(String columnId) {
        ColumnEntry columnEntry = this.getColumnEntry(columnId);
        this.setSortColumn(columnEntry, columnEntry.isSortAscendingPreferred());
    }

    public void setSortColumn(String columnId, boolean sortAscending) {
        this.setSortColumn(this.getColumnEntry(columnId), sortAscending);
    }

    public ColumnComparator getColumnComparator() {
        return this.sortColumn == null ? null : new ColumnComparator(this.sortColumn.impl, this.sortColumn.isSortAscendingPreferred());
    }

    private void setSortColumn(ColumnEntry entry, boolean sortAscending) {
        this.sortColumn = entry;
        entry.sortAscending = sortAscending;
        this.setSortColumn(entry.ui, sortAscending ? 128 : 1024);
    }

    private ColumnEntry getColumnEntry(String columnId) {
        return this.addedColumns.stream().filter(ce -> ((ColumnEntry)ce).impl.getId().equals(columnId)).findAny().get();
    }

    private void setSortColumn(ViewerColumn vc, int direction) {
        if (this.viewer instanceof TableViewer) {
            Table table = ((TableViewer)this.viewer).getTable();
            table.setSortColumn(vc == null ? null : ((TableViewerColumn)vc).getColumn());
            table.setSortDirection(direction);
        } else {
            Tree tree = ((TreeViewer)this.viewer).getTree();
            tree.setSortColumn(vc == null ? null : ((TreeViewerColumn)vc).getColumn());
            tree.setSortDirection(direction);
        }
        this.onSortChange.accept(this.getColumnComparator());
    }

    private static Item getColumnWidget(ViewerColumn vc) {
        if (vc instanceof TableViewerColumn) {
            return ((TableViewerColumn)vc).getColumn();
        }
        return ((TreeViewerColumn)vc).getColumn();
    }

    private Item[] getColumnWidgets() {
        if (this.viewer instanceof TableViewer) {
            return ((TableViewer)this.viewer).getTable().getColumns();
        }
        return ((TreeViewer)this.viewer).getTree().getColumns();
    }

    private static int getColumnWidth(ViewerColumn vc) {
        if (vc instanceof TableViewerColumn) {
            return ((TableViewerColumn)vc).getColumn().getWidth();
        }
        return ((TreeViewerColumn)vc).getColumn().getWidth();
    }

    private void setHeaderVisible(boolean visible) {
        if (this.viewer instanceof TableViewer) {
            ((TableViewer)this.viewer).getTable().setHeaderVisible(visible);
        } else {
            ((TreeViewer)this.viewer).getTree().setHeaderVisible(visible);
        }
    }

    private void setLinesVisible(boolean visible) {
        if (this.viewer instanceof TableViewer) {
            ((TableViewer)this.viewer).getTable().setLinesVisible(visible);
        } else {
            ((TreeViewer)this.viewer).getTree().setLinesVisible(visible);
        }
    }

    public Stream<? extends IColumnState> getColumnStates() {
        if (!this.viewer.getControl().isDisposed()) {
            this.updateColumnOrder();
        }
        return this.addedColumns.stream();
    }

    public TableSettings getSettings() {
        List<TableSettings.ColumnSettings> cols = this.getColumnStates().map(ColumnManager::buildColumnConfig).collect(Collectors.toList());
        return new TableSettings(this.sortColumn == null ? null : this.sortColumn.getColumn().getId(), cols);
    }

    private static TableSettings.ColumnSettings buildColumnConfig(IColumnState state) {
        return new TableSettings.ColumnSettings(state.getColumn().getId(), state.isHidden(), state.getWidth(), state.isSortAscending());
    }

    public int getVisibilityIndex(IColumn column) {
        for (ColumnEntry c : this.addedColumns) {
            if (c.impl != column) continue;
            if (c.ui == null) break;
            return Arrays.asList(this.getColumnWidgets()).indexOf(ColumnManager.getColumnWidget(c.ui));
        }
        return -1;
    }

    public SelectionState getSelectionState() {
        Table table = (Table)this.getViewer().getControl();
        return new SelectionState(table.getTopIndex(), table.getSelectionIndices());
    }

    public void setSelectionState(SelectionState state) {
        if (state == null) {
            return;
        }
        Table table = (Table)this.getViewer().getControl();
        table.setSelection(state.getSelectionIndices());
        this.getViewer().setSelection(this.getViewer().getSelection());
        table.setTopIndex(state.getScrollIndex());
    }

    public static class ColumnComparator
    extends ViewerComparator
    implements Comparator<Object> {
        private final IColumn column;
        private final boolean sortAscending;

        private ColumnComparator(IColumn column, boolean sortAscending) {
            this.column = column;
            this.sortAscending = sortAscending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare(e1, e2);
        }

        @Override
        public int compare(Object row1, Object row2) {
            int compare = 0;
            Comparator<Object> comparator = this.column.getComparator();
            if (comparator != null) {
                compare = comparator.compare(row1, row2);
            } else {
                ColumnLabelProvider clp = this.column.getLabelProvider();
                String l1 = clp.getText(row1);
                String l2 = clp.getText(row2);
                compare = l1 == null ? (l2 == null ? 0 : -1) : (l2 == null ? 1 : l1.compareTo(l2));
            }
            return this.sortAscending ? compare : -compare;
        }

        public IColumn getColumn() {
            return this.column;
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }
    }

    static class ColumnEntry
    implements ControlListener,
    IColumnState {
        private final IColumn impl;
        private Boolean hidden;
        private Integer width;
        private Boolean sortAscending;
        private ViewerColumn ui;

        public ColumnEntry(IColumn columnImpl, Boolean hidden, Integer width, Boolean sortAscending) {
            this.impl = columnImpl;
            this.hidden = hidden;
            this.width = width;
            this.sortAscending = sortAscending;
        }

        @Override
        public IColumn getColumn() {
            return this.impl;
        }

        @Override
        public Integer getWidth() {
            return this.width;
        }

        @Override
        public Boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isVisible() {
            return this.ui != null;
        }

        @Override
        public Boolean isSortAscending() {
            return this.sortAscending;
        }

        boolean isSortAscendingPreferred() {
            return this.sortAscending == null ? true : this.sortAscending;
        }

        Item create(ColumnViewer viewer, int columnIndex) {
            TableColumn columnWidget;
            int colWidth;
            int n = colWidth = this.width == null ? 150 : this.width;
            if (viewer instanceof TableViewer) {
                TableViewerColumn vc = new TableViewerColumn((TableViewer)viewer, this.getColumn().getStyle(), columnIndex);
                this.ui = vc;
                vc.getColumn().setMoveable(true);
                vc.getColumn().addControlListener((ControlListener)this);
                vc.getColumn().setToolTipText(this.getColumn().getDescription());
                vc.getColumn().setWidth(colWidth);
                columnWidget = vc.getColumn();
            } else {
                TreeViewerColumn vc = new TreeViewerColumn((TreeViewer)viewer, this.getColumn().getStyle(), columnIndex);
                this.ui = vc;
                vc.getColumn().setMoveable(true);
                vc.getColumn().addControlListener((ControlListener)this);
                vc.getColumn().setToolTipText(this.getColumn().getDescription());
                vc.getColumn().setWidth(colWidth);
                columnWidget = vc.getColumn();
            }
            this.ui.setEditingSupport(this.getColumn().getEditingSupport());
            this.ui.setLabelProvider((CellLabelProvider)this.getColumn().getLabelProvider());
            columnWidget.setText(this.getColumn().getName());
            return columnWidget;
        }

        private void doHide() {
            ViewerColumn vc = this.ui;
            this.ui = null;
            if (vc instanceof TableViewerColumn) {
                TableViewerColumn tc = (TableViewerColumn)vc;
                ColumnViewer viewer = vc.getViewer();
                try {
                    viewer.getControl().setRedraw(false);
                    tc.getColumn().dispose();
                }
                catch (Throwable throwable) {
                    try {
                        viewer.getControl().setRedraw(true);
                    }
                    catch (SWTException sWTException) {}
                    throw throwable;
                }
                try {
                    viewer.getControl().setRedraw(true);
                }
                catch (SWTException sWTException) {}
            } else if (vc != null) {
                ((TreeViewerColumn)vc).getColumn().dispose();
            }
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            this.width = ColumnManager.getColumnWidth(this.ui);
            this.ui.getViewer().getControl().redraw();
        }
    }

    public static interface IColumnState {
        public IColumn getColumn();

        public Integer getWidth();

        public Boolean isHidden();

        public Boolean isSortAscending();

        public boolean isVisible();
    }

    public static class SelectionState {
        private int scrollIndex;
        private int[] selectionIndices;

        private SelectionState(int scrollIndex, int[] selectionIndices) {
            this.scrollIndex = scrollIndex;
            this.selectionIndices = selectionIndices;
        }

        private int[] getSelectionIndices() {
            return this.selectionIndices;
        }

        private int getScrollIndex() {
            return this.scrollIndex;
        }
    }
}

