/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.handlers;

import java.util.logging.Level;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.openjdk.jmc.ui.UIPlugin;

public class InFocusHandlerActivator
implements FocusListener,
DisposeListener {
    private IHandlerService hs;
    private IHandlerActivation ha;
    private final String commandId;
    private final IHandler handler;

    public static void install(Control control, IAction handler) {
        InFocusHandlerActivator.install(control, handler.getActionDefinitionId(), (IHandler)new ActionHandler(handler));
    }

    public static void install(Control control, String commandId, IHandler handler) {
        InFocusHandlerActivator activator = new InFocusHandlerActivator(commandId, handler);
        control.addDisposeListener((DisposeListener)activator);
        control.addFocusListener((FocusListener)activator);
    }

    private InFocusHandlerActivator(String commandId, IHandler handler) {
        this.commandId = commandId;
        this.handler = handler;
    }

    public void focusLost(FocusEvent e) {
        this.deactivateHandler();
    }

    public void focusGained(FocusEvent e) {
        this.activateHandler();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.deactivateHandler();
    }

    private void activateHandler() {
        try {
            this.hs = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            this.ha = this.hs.activateHandler(this.commandId, this.handler, new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    return EvaluationResult.TRUE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activeFocusControl");
                }
            });
        }
        catch (RuntimeException e1) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not activate handler " + this, e1);
        }
    }

    private void deactivateHandler() {
        try {
            if (this.ha != null) {
                this.hs.deactivateHandler(this.ha);
                this.ha = null;
            }
        }
        catch (RuntimeException e1) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not deactivate handler " + this, e1);
        }
    }
}

