/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.ItemIterableToolkit;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYQuantities;

public class PairBucketBuilder<C extends IItemConsumer<C>, CC extends IItemConsumer<CC>> {
    int bucketCount;
    IAttribute<IQuantity> xAttribute;
    IAggregator<IQuantity, C> aggregator;
    SubdividedQuantityRange xRange;
    IAggregator<IQuantity, CC> secondAggregator;

    PairBucketBuilder(int bucketCount, IAttribute<IQuantity> xAttribute, IAggregator<IQuantity, C> aggregator, IAggregator<IQuantity, CC> secondAggregator, SubdividedQuantityRange xRange) {
        this.bucketCount = bucketCount;
        this.xAttribute = xAttribute;
        this.aggregator = aggregator;
        this.secondAggregator = secondAggregator;
        this.xRange = xRange;
    }

    private List<Pair<C, CC>> build(IType<IItem> type) {
        ArrayList<Pair<C, CC>> calculators = new ArrayList<Pair<C, CC>>(this.bucketCount);
        int i = 0;
        while (i < this.bucketCount) {
            calculators.add(new Pair((Object)this.aggregator.newItemConsumer(type), (Object)this.secondAggregator.newItemConsumer(type)));
            ++i;
        }
        return calculators;
    }

    private void consume(List<Pair<C, CC>> list, IItem item, IMemberAccessor<IQuantity, IItem> xAccessor) {
        int xPos = this.xRange.getFloorSubdivider((IQuantity)xAccessor.getMember((Object)item));
        if (xPos >= 0 && xPos < list.size()) {
            ((IItemConsumer)list.get((int)xPos).left).consume(item);
            ((IItemConsumer)list.get((int)xPos).right).consume(item);
        }
    }

    private List<Pair<C, CC>> combine(List<Pair<C, CC>> l1, List<Pair<C, CC>> l2) {
        int i = 0;
        while (i < this.bucketCount) {
            l1.set(i, new Pair((Object)((IItemConsumer)((IItemConsumer)l1.get((int)i).left).merge((Object)((IItemConsumer)l2.get((int)i).left))), (Object)((IItemConsumer)((IItemConsumer)l1.get((int)i).right).merge((Object)((IItemConsumer)l2.get((int)i).right)))));
            ++i;
        }
        return l1;
    }

    private Collector<IItem, List<Pair<C, CC>>, List<Pair<C, CC>>> collector(IType<IItem> type) {
        IMemberAccessor xAccessor = this.xAttribute.getAccessor(type);
        return Collector.of(() -> this.build(type), (l, i) -> this.consume((List<Pair<C, CC>>)l, (IItem)i, (IMemberAccessor<IQuantity, IItem>)xAccessor), this::combine, Collector.Characteristics.UNORDERED);
    }

    private boolean acceptItems(IItemIterable is) {
        return this.aggregator.acceptType(is.getType());
    }

    private List<Pair<C, CC>> collectItems(IItemIterable is) {
        return ItemIterableToolkit.parallelStream(is).collect(this.collector((IType<IItem>)is.getType()));
    }

    Pair<IQuantity[], IQuantity[]> buildBuckets(IItemCollection items) {
        IQuantity[] q1 = new IQuantity[this.bucketCount];
        IQuantity[] q2 = new IQuantity[this.bucketCount];
        List collect = ItemCollectionToolkit.parallelStream(items).filter(this::acceptItems).map(this::collectItems).collect(Collectors.toList());
        int i = 0;
        while (i < this.bucketCount) {
            int bucketIndex = i;
            List pairList = collect.stream().map(list -> (Pair)list.get(bucketIndex)).collect(Collectors.toList());
            ArrayList<IItemConsumer> l1 = new ArrayList<IItemConsumer>();
            ArrayList<IItemConsumer> l2 = new ArrayList<IItemConsumer>();
            for (Pair pair : pairList) {
                l1.add((IItemConsumer)pair.left);
                l2.add((IItemConsumer)pair.right);
            }
            q1[i] = (IQuantity)this.aggregator.getValue(l1.iterator());
            q2[i] = (IQuantity)this.secondAggregator.getValue(l2.iterator());
            ++i;
        }
        return new Pair((Object)q1, (Object)q2);
    }

    public static <C extends IItemConsumer<C>, CC extends IItemConsumer<CC>> IQuantitySeries<IQuantity[]> aggregatorSeries(final IItemCollection items, final IAggregator<IQuantity, C> a, final IAggregator<IQuantity, CC> c, final IAttribute<IQuantity> xAttribute) {
        return new IQuantitySeries<IQuantity[]>(){

            public XYQuantities<IQuantity[]> getQuantities(SubdividedQuantityRange xBucketRange) {
                int bucketCount = xBucketRange.getNumSubdividers();
                PairBucketBuilder bb = new PairBucketBuilder(bucketCount, (IAttribute<IQuantity>)xAttribute, a, c, xBucketRange);
                Pair<IQuantity[], IQuantity[]> pairBuckets = bb.buildBuckets(items);
                return XYQuantities.create((Object)((IQuantity[])pairBuckets.right), Arrays.asList((IQuantity[])pairBuckets.left), (SubdividedQuantityRange)xBucketRange);
            }
        };
    }
}

