/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs;

import java.io.Closeable;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.rjmx.services.jfr.IRecordingDescriptor;
import org.openjdk.jmc.ui.common.util.StatusFactory;

public class UpdateRecordingJob
extends Job {
    private final IRecordingDescriptor m_recordingDescriptor;
    private final IConstrainedMap<String> m_recordingOptions;
    private final IConstrainedMap<EventOptionID> m_recordingSettings;
    private final IServerHandle m_server;

    public UpdateRecordingJob(IServerHandle server, IRecordingDescriptor recordingDescriptor, IConstrainedMap<String> recordingOptions, IConstrainedMap<EventOptionID> recordingSettings) {
        super(NLS.bind((String)Messages.UPDATE_RECORDING_JOB_NAME, (Object)recordingDescriptor.getName()));
        this.m_server = server;
        this.m_recordingDescriptor = recordingDescriptor;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IConnectionHandle connection = null;
        try {
            connection = this.m_server.connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
            flightRecorderService.updateRecordingOptions(this.m_recordingDescriptor, this.m_recordingOptions);
            flightRecorderService.updateEventOptions(this.m_recordingDescriptor, this.m_recordingSettings);
            iStatus = StatusFactory.createOk((String)Messages.UPDATE_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (Exception e) {
            IStatus iStatus2;
            try {
                ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not update recording", e);
                iStatus2 = StatusFactory.createErr((String)NLS.bind((String)Messages.UPDATE_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)this.m_recordingDescriptor.getName()));
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(connection);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }
}

