/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.Messages;
import org.openjdk.jmc.ui.charts.RenderedRowBase;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;

public class RendererToolkit {
    private static final IXDataRenderer EMPTY = new IXDataRenderer(){

        @Override
        public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
            return new RenderedRowBase(height);
        }
    };

    public static IXDataRenderer layers(IXDataRenderer ... layers) {
        return RendererToolkit.layers(Arrays.asList(layers));
    }

    public static IXDataRenderer layers(List<IXDataRenderer> layers) {
        return layers.isEmpty() ? RendererToolkit.empty() : new LayeredRenderer(layers);
    }

    public static IXDataRenderer uniformRows(List<IXDataRenderer> rows) {
        return RendererToolkit.uniformRows(rows, null);
    }

    public static IXDataRenderer uniformRows(List<IXDataRenderer> rows, String text) {
        return RendererToolkit.weightedRows(rows, text, null);
    }

    public static IXDataRenderer weightedRows(List<IXDataRenderer> rows, List<Double> weights) {
        return RendererToolkit.weightedRows(rows, null, weights);
    }

    public static IXDataRenderer weightedRows(List<IXDataRenderer> rows, String text, List<Double> weights) {
        return rows.isEmpty() ? RendererToolkit.empty() : new CompositeRenderer(rows, text, weights);
    }

    public static IXDataRenderer empty() {
        return EMPTY;
    }

    private static class CompositeRenderer
    implements IXDataRenderer {
        private static final Color TOO_MUCH_CONTENT_BG = new Color(240, 240, 240, 190);
        private static final String TOO_MUCH_CONTENT_MSG = Messages.getString("RendererToolkit_TOO_MUCH_CONTENT");
        private final List<IXDataRenderer> children;
        private final List<Double> weights;
        private final String text;
        private final double totalWeight;

        CompositeRenderer(List<IXDataRenderer> children, String text, List<Double> weights) {
            this.children = children;
            this.text = text;
            this.weights = weights;
            if (weights == null) {
                this.totalWeight = children.size();
            } else {
                double sum = 0.0;
                for (Double w : weights) {
                    sum += w.doubleValue();
                }
                this.totalWeight = sum;
            }
        }

        @Override
        public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
            List<Object> result = new ArrayList(this.children.size());
            AffineTransform oldTransform = context.getTransform();
            int heightLeft = height;
            double weightLeft = this.totalWeight;
            int i = 0;
            while (i < this.children.size()) {
                double rowWeight = this.weights == null ? 1.0 : this.weights.get(i);
                int rowHeight = (int)Math.round((double)heightLeft / weightLeft * rowWeight);
                weightLeft -= rowWeight;
                if (rowHeight > 0) {
                    heightLeft -= rowHeight;
                    result.add(this.children.get(i).render(context, xRange, rowHeight));
                    context.translate(0, rowHeight);
                }
                ++i;
            }
            context.setTransform(oldTransform);
            if (result.size() != this.children.size()) {
                result = Collections.emptyList();
                context.setPaint(TOO_MUCH_CONTENT_BG);
                context.fillRect(0, 0, xRange.getPixelExtent(), height);
                Font orgFont = context.getFont();
                Font italicFont = orgFont.deriveFont(2);
                FontMetrics fm = context.getFontMetrics(italicFont);
                int msgWidth = fm.stringWidth(TOO_MUCH_CONTENT_MSG);
                if (height > fm.getHeight() && xRange.getPixelExtent() > msgWidth) {
                    context.setFont(italicFont);
                    context.setPaint(Color.BLACK);
                    context.drawString(TOO_MUCH_CONTENT_MSG, (xRange.getPixelExtent() - msgWidth) / 2, (height - fm.getHeight()) / 2 + fm.getAscent());
                    context.setFont(orgFont);
                }
            }
            return new RenderedRowBase(result, height, this.text, null, null){

                @Override
                public void infoAt(IChartInfoVisitor visitor, int x, int y, Point offset) {
                    boolean notifyLeave = false;
                    if (text != null) {
                        notifyLeave = visitor.enterScope(text, this.getHeight() > 20 && text.length() <= 26);
                    }
                    int yRowStart = 0;
                    for (IRenderedRow nestedRow : this.getNestedRows()) {
                        int yRowEnd = yRowStart + nestedRow.getHeight();
                        if (yRowStart > y) break;
                        if (yRowEnd > y) {
                            Point newOffset = new Point(offset.x, offset.y + yRowStart);
                            nestedRow.infoAt(visitor, x, y - yRowStart, newOffset);
                        }
                        yRowStart = yRowEnd;
                    }
                    if (notifyLeave) {
                        visitor.leaveScope();
                    }
                }
            };
        }
    }

    private static class LayeredRenderer
    implements IXDataRenderer {
        private final List<IXDataRenderer> layers;

        LayeredRenderer(List<IXDataRenderer> layers) {
            this.layers = layers;
        }

        @Override
        public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
            final ArrayList<IRenderedRow> results = new ArrayList<IRenderedRow>(this.layers.size());
            String text = null;
            String description = null;
            Object payload = null;
            List<Object> subdivision = Collections.emptyList();
            for (IXDataRenderer layer : this.layers) {
                IRenderedRow result = layer.render(context, xRange, height);
                results.add(result);
                if (result.getName() != null && !result.getName().isEmpty()) {
                    text = result.getName();
                }
                if (result.getDescription() != null && !result.getDescription().isEmpty()) {
                    description = result.getDescription();
                }
                if (result.getPayload() != null) {
                    payload = result.getPayload();
                }
                if (result.getNestedRows().isEmpty()) continue;
                subdivision = result.getNestedRows();
            }
            return new RenderedRowBase(subdivision, height, text, description, payload){

                @Override
                public void infoAt(IChartInfoVisitor visitor, int x, int y, Point offset) {
                    for (IRenderedRow rr : results) {
                        rr.infoAt(visitor, x, y, offset);
                    }
                }
            };
        }
    }
}

