/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.celleditors;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.rjmx.ui.celleditors.StringConstructorCellEditor;

public class NumberCellEditor<T extends Number>
extends StringConstructorCellEditor<T> {
    public NumberCellEditor(Composite parent, Class<? extends T> type, boolean allowNull, final boolean allowNegative) {
        super(parent, type, allowNull);
        final boolean isFloatingPoint = type == Double.class || type == Float.class;
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.character == '\u0000' ? this.verifyString(e.text, e.start) : this.verifyChar(e.character, e.start);
            }

            protected boolean verifyString(String s, int atIndex) {
                int i = 0;
                while (i < s.length()) {
                    if (!this.verifyChar(s.charAt(i), atIndex + i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            protected boolean verifyChar(char c, int atIndex) {
                switch (c) {
                    case '\b': 
                    case '\u007f': {
                        return true;
                    }
                    case '-': {
                        return allowNegative && atIndex == 0 || isFloatingPoint && atIndex > 0;
                    }
                    case '.': 
                    case 'E': 
                    case 'e': {
                        return isFloatingPoint && atIndex > 0;
                    }
                }
                return Character.isDigit(c);
            }
        });
    }
}

