/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.jdp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.browser.jdp.JDPPlugin;
import org.openjdk.jmc.browser.jdp.Messages;
import org.openjdk.jmc.jdp.client.DiscoveryEvent;
import org.openjdk.jmc.jdp.client.DiscoveryListener;
import org.openjdk.jmc.jdp.client.JDPClient;
import org.openjdk.jmc.rjmx.IServerDescriptor;
import org.openjdk.jmc.rjmx.descriptorprovider.AbstractDescriptorProvider;
import org.openjdk.jmc.rjmx.descriptorprovider.IDescriptorListener;
import org.openjdk.jmc.ui.common.jvm.Connectable;
import org.openjdk.jmc.ui.common.jvm.JVMArch;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;
import org.openjdk.jmc.ui.common.jvm.JVMType;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class JDPDescriptorProvider
extends AbstractDescriptorProvider
implements IPropertyChangeListener {
    private JDPClient jdpClient;
    private final JDPDiscoveryListener discoveryListener = new JDPDiscoveryListener();

    public JDPDescriptorProvider() {
        JDPPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public String getName() {
        return Messages.JDPDescriptorProvider_PROVIDER_NAME;
    }

    public String getDescription() {
        return Messages.JDPDescriptorProvider_PROVIDER_DESCRIPTION;
    }

    private synchronized void startClient() {
        if (this.jdpClient == null) {
            InetAddress address;
            String addressStr = JDPPlugin.getDefault().getPreferenceStore().getString("org.openjdk.jmc.jdp.address");
            try {
                address = InetAddress.getByName(addressStr);
            }
            catch (UnknownHostException unknownHostException) {
                DialogToolkit.showWarningDialogAsync((Display)PlatformUI.getWorkbench().getDisplay(), (String)Messages.JDPDescriptorProvider_COULD_NOT_RESOLVE_HOST_TITLE, (String)NLS.bind((String)Messages.JDPDescriptorProvider_COULD_NOT_RESOLVE_HOST_TEXT, (Object)addressStr));
                JDPPlugin.getDefault().getLogger().info("Could not resolve address for JDP: " + addressStr);
                return;
            }
            this.jdpClient = new JDPClient(address, this.getPort(), this.getHeartBeatTimeout() * 1000);
            this.jdpClient.addDiscoveryListener((DiscoveryListener)this.discoveryListener);
            try {
                this.jdpClient.start();
            }
            catch (IOException e) {
                this.jdpClient.stop();
                this.jdpClient = null;
                JDPPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not start the JDP client. JDP discovery will not be possible for this session. One possible reason for this error can be that no network is available.", e);
            }
        }
    }

    private synchronized void shutDownClient() {
        if (this.jdpClient != null) {
            this.jdpClient.removeDiscoveryListener((DiscoveryListener)this.discoveryListener);
            this.jdpClient.stop();
            this.jdpClient = null;
        }
    }

    private int getHeartBeatTimeout() {
        return JDPPlugin.getDefault().getPreferenceStore().getInt("org.openjdk.jmc.jdp.hbtimeout");
    }

    private int getPort() {
        return JDPPlugin.getDefault().getPreferenceStore().getInt("org.openjdk.jmc.jdp.port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            if (this.m_descriptorListeners.size() == 0) {
                super.addDescriptorListener(l);
                this.startClient();
                return;
            }
            super.addDescriptorListener(l);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.restartJDPClient();
    }

    private synchronized void restartJDPClient() {
        this.shutDownClient();
        this.startClient();
    }

    private class JDPDiscoveryListener
    implements DiscoveryListener {
        private static final String PATH_SEPARATOR = "/";

        private JDPDiscoveryListener() {
        }

        public void onDiscovery(DiscoveryEvent event) {
            switch (event.getKind()) {
                case LOST: {
                    JDPDescriptorProvider.this.onDescriptorRemoved(event.getDiscoverable().getSessionId());
                    break;
                }
                default: {
                    Map map = event.getDiscoverable().getPayload();
                    String name = (String)map.get("INSTANCE_NAME");
                    String url = (String)map.get("JMX_SERVICE_URL");
                    String commandLine = (String)map.get("MAIN_CLASS");
                    String pid = (String)map.get("PROCESS_ID");
                    JVMDescriptor jvmInfo = new JVMDescriptor(null, JVMType.UNKNOWN, JVMArch.UNKNOWN, commandLine, null, pid == null ? null : Integer.valueOf(Integer.parseInt(pid)), false, Connectable.MGMNT_AGENT_STARTED);
                    String path = null;
                    if (name != null) {
                        if (name.endsWith(PATH_SEPARATOR)) {
                            path = name;
                            name = null;
                        } else {
                            int index = name.lastIndexOf(47);
                            if (index != -1) {
                                path = name.substring(0, index);
                                name = name.substring(index + 1);
                            }
                        }
                    }
                    IServerDescriptor sd = IServerDescriptor.create((String)event.getDiscoverable().getSessionId(), (String)name, (JVMDescriptor)jvmInfo);
                    try {
                        JDPDescriptorProvider.this.onDescriptorDetected(sd, path, new JMXServiceURL(url), null);
                        break;
                    }
                    catch (Exception e) {
                        JDPPlugin.getDefault().getLogger().log(Level.SEVERE, "Got broken event from JDP: " + url, e);
                    }
                }
            }
        }
    }
}

