/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.internal;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.services.IOperation;
import org.openjdk.jmc.rjmx.services.IllegalOperandException;
import org.openjdk.jmc.rjmx.services.internal.AbstractOperation;
import org.openjdk.jmc.rjmx.services.internal.Messages;
import org.openjdk.jmc.rjmx.util.internal.SimpleAttributeInfo;

public final class MBeanOperationsWrapper
extends ArrayList<IOperation> {
    private static final int MAX_DESCRIPTORS = 8;
    private static final int MAX_LINE_LENGTH = 100;
    private static final String ELLIPSIS_STRING = "...";
    private static final long serialVersionUID = -8499920218074514535L;
    private static final String IMPACT = ".vmImpact";
    private final ObjectName bean;
    private final transient MBeanServerConnection connection;

    public MBeanOperationsWrapper(ObjectName bean, MBeanOperationInfo[] operations, MBeanServerConnection connection) {
        super(operations.length);
        this.connection = connection;
        this.bean = bean;
        MBeanOperationInfo[] mBeanOperationInfoArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo info = mBeanOperationInfoArray[n2];
            this.add(new MBeanOperation(info));
            ++n2;
        }
    }

    private static String convertDescription(MBeanFeatureInfo info) {
        String[] fields;
        StringBuilder sb = new StringBuilder();
        if (info.getDescriptor() != null && info.getDescriptor().getFields() != null && (fields = info.getDescriptor().getFields()).length > 0) {
            sb.append(Messages.MBeanOperationsWrapper_DESCRIPTOR).append(":\n ");
            int i = 0;
            while (i < Math.min(fields.length, 8)) {
                String str = fields[i];
                int cur = 0;
                int newLine = 0;
                while (cur < str.length() && newLine != -1) {
                    newLine = str.indexOf(10, cur);
                    if (newLine == -1) {
                        sb.append(MBeanOperationsWrapper.shorten(str.substring(cur))).append("\n ");
                        continue;
                    }
                    sb.append(MBeanOperationsWrapper.shorten(str.substring(cur, newLine))).append("\n ");
                    cur = newLine + 1;
                }
                ++i;
            }
        }
        return String.valueOf(MBeanOperationsWrapper.shorten(info.getDescription())) + "\n " + sb.toString().trim();
    }

    private static String shorten(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() > 100) {
            return s.subSequence(0, 100 - ELLIPSIS_STRING.length()) + ELLIPSIS_STRING;
        }
        return s;
    }

    private static List<SimpleAttributeInfo> convertArguments(MBeanOperationInfo info) {
        MBeanParameterInfo[] sign = info.getSignature();
        ArrayList<SimpleAttributeInfo> signature = new ArrayList<SimpleAttributeInfo>(sign.length);
        MBeanParameterInfo[] mBeanParameterInfoArray = sign;
        int n = sign.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo paramInfo = mBeanParameterInfoArray[n2];
            String name = MBeanOperationsWrapper.asNonNullNorEmptyString(paramInfo.getName(), MBeanOperationsWrapper.asNonNullNorEmptyString(paramInfo.getDescription(), ""));
            signature.add(new SimpleAttributeInfo(name, paramInfo.getType(), MBeanOperationsWrapper.convertDescription(paramInfo)));
            ++n2;
        }
        return signature;
    }

    private static String asNonNullNorEmptyString(String string, String defaultString) {
        return string != null && string.trim().length() > 0 ? string : defaultString;
    }

    private static IOperation.OperationImpact convertImpact(MBeanOperationInfo info) {
        String[] stringArray = info.getDescriptor().getFieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object impactField;
            String name = stringArray[n2];
            if (name.endsWith(IMPACT) && (impactField = info.getDescriptor().getFieldValue(name)) != null) {
                String impact = impactField.toString();
                if (impact.startsWith("Low")) {
                    return IOperation.OperationImpact.IMPACT_LOW;
                }
                if (impact.startsWith("Medium")) {
                    return IOperation.OperationImpact.IMPACT_MEDIUM;
                }
                if (impact.startsWith("High")) {
                    return IOperation.OperationImpact.IMPACT_HIGH;
                }
            }
            ++n2;
        }
        return IOperation.OperationImpact.IMPACT_UNKNOWN;
    }

    private static String describeValue(Object o) {
        if (o.getClass().isArray()) {
            return String.valueOf(o.getClass().getComponentType().getName()) + "[" + Array.getLength(o) + "]";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        return o.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("MBeanOperationsWrappers should not be serialized!");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("MBeanOperationsWrappers should not be serialized!");
    }

    private class MBeanOperation
    extends AbstractOperation<SimpleAttributeInfo> {
        public MBeanOperation(MBeanOperationInfo info) {
            super(info.getName(), MBeanOperationsWrapper.convertDescription(info), info.getReturnType(), MBeanOperationsWrapper.convertArguments(info), MBeanOperationsWrapper.convertImpact(info));
        }

        @Override
        public Callable<?> getInvocator(final Object ... argVals) throws IllegalOperandException {
            List params = this.getSignature();
            final StringBuilder argString = new StringBuilder("(");
            if (argVals.length < params.size()) {
                throw new IllegalOperandException(params.subList(argVals.length, params.size()));
            }
            final String[] sig = new String[params.size()];
            int i = 0;
            while (i < params.size()) {
                sig[i] = ((SimpleAttributeInfo)params.get(i)).getType();
                if (argVals[i] != null) {
                    argString.append(' ').append(MBeanOperationsWrapper.describeValue(argVals[i])).append(',');
                } else if (TypeHandling.isPrimitive((String)sig[i])) {
                    IllegalOperandException ex = new IllegalOperandException((IAttributeInfo)params.get(i));
                    while (++i < params.size()) {
                        if (argVals[i] != null || !TypeHandling.isPrimitive((String)((SimpleAttributeInfo)params.get(i)).getType())) continue;
                        ex.addInvalidValue((IAttributeInfo)params.get(i));
                    }
                    throw ex;
                }
                ++i;
            }
            if (argString.charAt(argString.length() - 1) == ',') {
                argString.deleteCharAt(argString.length() - 1);
            }
            argString.append(" )");
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return MBeanOperationsWrapper.this.connection.invoke(MBeanOperationsWrapper.this.bean, MBeanOperation.this.getName(), argVals, sig);
                }

                public String toString() {
                    return String.valueOf(MBeanOperation.this.getName()) + argString.toString().replace("\n", "\\n").replace("\r", "\\r");
                }
            };
        }
    }
}

