/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.common.util.Environment;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.AwtCanvas;

public class ChartCanvas
extends Canvas {
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private List<Rectangle2D> highlightRects;
    private final double xScale;
    private final double yScale;
    private final AwtCanvas awtCanvas;
    private boolean awtNeedsRedraw;
    private Runnable selectionListener;
    private IPropertyChangeListener aaListener;
    private XYChart awtChart;
    private MCContextMenuManager chartMenu;

    public ChartCanvas(Composite parent) {
        super(parent, 262144);
        this.xScale = (double)Display.getDefault().getDPI().x / Environment.getNormalDPI();
        this.yScale = (double)Display.getDefault().getDPI().y / Environment.getNormalDPI();
        this.awtCanvas = new AwtCanvas();
        this.addPaintListener(new Painter());
        Selector selector = new Selector();
        this.addMouseListener((MouseListener)selector);
        this.addMouseMoveListener(selector);
        this.addMouseTrackListener(selector);
        FocusTracker.enableFocusTracking((Composite)this);
        this.addListener(37, new Zoomer());
        this.addKeyListener(new KeyNavigator());
        this.aaListener = new AntiAliasingListener();
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.aaListener);
        this.addDisposeListener(e -> UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.aaListener));
        if (Environment.getOSType() == Environment.OSType.WINDOWS) {
            this.addMouseTrackListener(new WheelStealingZoomer());
        }
    }

    public IMenuManager getContextMenu() {
        if (this.chartMenu == null) {
            this.chartMenu = MCContextMenuManager.create((Control)this);
            this.chartMenu.addMenuListener(manager -> this.clearHighlightRects());
        }
        return this.chartMenu;
    }

    private void render(Graphics2D context, int width, int height) {
        if (this.awtChart != null) {
            this.awtChart.render(context, width, height);
        }
    }

    private Point translateDisplayToImageCoordinates(int x, int y) {
        int xImage = (int)Math.round((double)x / this.xScale);
        int yImage = (int)Math.round((double)y / this.yScale);
        return new Point(xImage, yImage);
    }

    private int translateDisplayToImageXCoordinates(int x) {
        return (int)Math.round((double)x / this.xScale);
    }

    private void updateHighlightRects() {
        final ArrayList<Rectangle2D> newRects = new ArrayList<Rectangle2D>();
        this.infoAt(new IChartInfoVisitor.Adapter(){

            @Override
            public void visit(IChartInfoVisitor.IBucket bucket) {
                newRects.add(bucket.getTarget());
            }

            @Override
            public void visit(IChartInfoVisitor.IPoint point) {
                Point2D target = point.getTarget();
                newRects.add(new Rectangle2D.Double(target.getX(), target.getY(), 0.0, 0.0));
            }

            @Override
            public void visit(IChartInfoVisitor.ISpan span) {
                newRects.add(span.getTarget());
            }

            @Override
            public void visit(IChartInfoVisitor.ITick tick) {
                Point2D target = tick.getTarget();
                newRects.add(new Rectangle2D.Double(target.getX(), target.getY(), 0.0, 0.0));
            }

            @Override
            public void visit(IChartInfoVisitor.ILane lane) {
            }
        }, this.lastMouseX, this.lastMouseY);
        if (!newRects.equals(this.highlightRects)) {
            this.highlightRects = newRects;
            this.redraw();
        }
    }

    private void clearHighlightRects() {
        if (this.highlightRects != null) {
            this.highlightRects = null;
            this.redraw();
        }
    }

    private void handleWheelEvent(int stateMask, int x, int count) {
        if ((stateMask & SWT.MOD1) != 0) {
            this.pan(count * 3);
        } else {
            this.zoom(this.translateDisplayToImageXCoordinates(x), count);
        }
    }

    private void pan(int rightPercent) {
        if (this.awtChart != null && this.awtChart.pan(rightPercent)) {
            this.redrawChart();
        }
    }

    private void zoom(int zoomInSteps) {
        if (this.awtChart != null && this.awtChart.zoom(zoomInSteps)) {
            this.redrawChart();
        }
    }

    private void zoom(int x, int zoomInSteps) {
        if (this.awtChart != null && this.awtChart.zoom(x, zoomInSteps)) {
            this.redrawChart();
        }
    }

    private void select(int x1, int x2, int y1, int y2) {
        if (this.awtChart != null && this.awtChart.select(x1, x2, y1, y2)) {
            this.redrawChart();
        }
    }

    private void toggleSelect(int x, int y) {
        Point p = this.translateDisplayToImageCoordinates(x, y);
        if (this.awtChart != null) {
            final IQuantity[] range = new IQuantity[2];
            this.infoAt(new IChartInfoVisitor.Adapter(){

                @Override
                public void visit(IChartInfoVisitor.IBucket bucket) {
                    if (range[0] == null) {
                        range[0] = (IQuantity)bucket.getStartX();
                        range[1] = (IQuantity)bucket.getEndX();
                    }
                }

                @Override
                public void visit(IChartInfoVisitor.ISpan span) {
                    if (range[0] == null) {
                        IDisplayable x0 = span.getStartX();
                        IDisplayable x1 = span.getEndX();
                        range[0] = x0 instanceof IQuantity ? (IQuantity)x0 : null;
                        range[1] = x1 instanceof IQuantity ? (IQuantity)x1 : null;
                    }
                }
            }, x, y);
            if (range[0] != null || range[1] != null) {
                if (!this.awtChart.select(range[0], range[1], p.y, p.y)) {
                    this.awtChart.clearSelection();
                }
            } else if (!this.awtChart.select(p.x, p.x, p.y, p.y)) {
                this.awtChart.clearSelection();
            }
            this.redrawChart();
        }
    }

    public void setChart(XYChart awtChart) {
        this.awtChart = awtChart;
        this.notifyListener();
        this.redrawChart();
    }

    public void replaceRenderer(IXDataRenderer rendererRoot) {
        assert (this.awtChart != null);
        this.awtChart.setRendererRoot(rendererRoot);
        this.notifyListener();
        this.redrawChart();
    }

    public void setSelectionListener(Runnable selectionListener) {
        this.selectionListener = selectionListener;
    }

    private void notifyListener() {
        if (this.selectionListener != null) {
            this.selectionListener.run();
        }
    }

    public void infoAt(IChartInfoVisitor visitor, int x, int y) {
        Point p = this.translateDisplayToImageCoordinates(x, y);
        if (this.awtChart != null) {
            this.awtChart.infoAt(visitor, p.x, p.y);
        }
    }

    public void redrawChart() {
        this.awtNeedsRedraw = true;
        this.redraw();
    }

    private class AntiAliasingListener
    implements IPropertyChangeListener {
        private AntiAliasingListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ChartCanvas.this.redrawChart();
        }
    }

    class KeyNavigator
    implements KeyListener {
        KeyNavigator() {
        }

        public void keyPressed(KeyEvent event) {
            block0 : switch (event.character) {
                case '+': {
                    ChartCanvas.this.zoom(1);
                    break;
                }
                case '-': {
                    ChartCanvas.this.zoom(-1);
                    break;
                }
                default: {
                    switch (event.keyCode) {
                        case 0x1000004: {
                            ChartCanvas.this.pan(10);
                            break block0;
                        }
                        case 0x1000003: {
                            ChartCanvas.this.pan(-10);
                            break block0;
                        }
                        case 0x1000001: {
                            ChartCanvas.this.zoom(1);
                            break block0;
                        }
                        case 0x1000002: {
                            ChartCanvas.this.zoom(-1);
                        }
                    }
                }
            }
        }

        public void keyReleased(KeyEvent event) {
        }
    }

    class Painter
    implements PaintListener {
        Painter() {
        }

        public void paintControl(PaintEvent e) {
            Rectangle rect = ChartCanvas.this.getClientArea();
            if (ChartCanvas.this.awtNeedsRedraw || !ChartCanvas.this.awtCanvas.hasImage(rect.width, rect.height)) {
                Graphics2D g2d = ChartCanvas.this.awtCanvas.getGraphics(rect.width, rect.height);
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, rect.width, rect.height);
                Point adjusted = ChartCanvas.this.translateDisplayToImageCoordinates(rect.width, rect.height);
                ChartCanvas.this.render(g2d, adjusted.x, adjusted.y);
                if (ChartCanvas.this.highlightRects != null) {
                    ChartCanvas.this.updateHighlightRects();
                }
                ChartCanvas.this.awtNeedsRedraw = false;
            }
            ChartCanvas.this.awtCanvas.paint(e, 0, 0);
            List rs = ChartCanvas.this.highlightRects;
            if (rs != null) {
                GC gc = e.gc;
                gc.setForeground(ChartCanvas.this.getForeground());
                for (Rectangle2D r : rs) {
                    int height;
                    int width;
                    int x = (int)((double)((int)r.getX()) * ChartCanvas.this.xScale);
                    int y = (int)((double)((int)r.getY()) * ChartCanvas.this.yScale);
                    if (r.getWidth() == 0.0 && r.getHeight() == 0.0) {
                        width = (int)Math.round(4.0 * ChartCanvas.this.xScale);
                        height = (int)Math.round(4.0 * ChartCanvas.this.yScale);
                        gc.drawOval(x - (int)Math.round(2.0 * ChartCanvas.this.xScale), y - (int)Math.round(2.0 * ChartCanvas.this.yScale), width, height);
                        continue;
                    }
                    width = (int)Math.round(r.getWidth() * ChartCanvas.this.xScale);
                    height = (int)Math.round(r.getHeight() * ChartCanvas.this.yScale);
                    gc.drawRectangle(x, y, width, height);
                }
            }
        }
    }

    private class Selector
    extends MouseAdapter
    implements MouseMoveListener,
    MouseTrackListener {
        int selectionStartX = -1;
        int selectionStartY = -1;
        boolean selectionIsClick = false;

        private Selector() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
                this.selectionStartX = e.x;
                this.selectionStartY = e.y;
                this.selectionIsClick = true;
                ChartCanvas.this.toggleSelect(this.selectionStartX, this.selectionStartY);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.selectionStartX >= 0) {
                ChartCanvas.this.highlightRects = null;
                this.updateSelectionState(e);
            } else {
                ChartCanvas.this.lastMouseX = e.x;
                ChartCanvas.this.lastMouseY = e.y;
                ChartCanvas.this.updateHighlightRects();
            }
        }

        private void updateSelectionState(MouseEvent e) {
            int x = e.x;
            int y = e.y;
            if (this.selectionIsClick && (Math.abs(x - this.selectionStartX) > 3 || Math.abs(y - this.selectionStartY) > 3)) {
                this.selectionIsClick = false;
            }
            if (!this.selectionIsClick) {
                ChartCanvas.this.select((int)((double)this.selectionStartX / ChartCanvas.this.xScale), (int)((double)x / ChartCanvas.this.xScale), (int)((double)this.selectionStartY / ChartCanvas.this.yScale), (int)((double)y / ChartCanvas.this.yScale));
            }
        }

        public void mouseUp(MouseEvent e) {
            if (this.selectionStartX >= 0 && e.button == 1) {
                this.updateSelectionState(e);
                this.selectionStartX = -1;
                this.selectionStartY = -1;
                if (ChartCanvas.this.selectionListener != null) {
                    ChartCanvas.this.selectionListener.run();
                }
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            ChartCanvas.this.clearHighlightRects();
        }

        public void mouseHover(MouseEvent e) {
        }
    }

    class WheelStealingZoomer
    implements Listener,
    MouseTrackListener,
    FocusListener {
        private Control stealWheelFrom;

        WheelStealingZoomer() {
        }

        public void handleEvent(Event event) {
            if (ChartCanvas.this.isDisposed()) {
                this.stop();
            } else if (this.stealWheelFrom != null && !this.stealWheelFrom.isDisposed()) {
                Point canvasSize = ChartCanvas.this.getSize();
                Point canvasPoint = ChartCanvas.this.toControl(this.stealWheelFrom.toDisplay(event.x, event.y));
                if (canvasPoint.x >= 0 && canvasPoint.y >= 0 && canvasPoint.x < canvasSize.x && canvasPoint.y < canvasSize.y) {
                    ChartCanvas.this.handleWheelEvent(event.stateMask, canvasPoint.x, event.count);
                    event.doit = false;
                }
            }
        }

        private void stop() {
            if (this.stealWheelFrom != null && !this.stealWheelFrom.isDisposed()) {
                this.stealWheelFrom.removeListener(37, (Listener)this);
                this.stealWheelFrom.removeFocusListener((FocusListener)this);
                this.stealWheelFrom = null;
            }
        }

        public void mouseEnter(MouseEvent e) {
            this.stop();
            Control stealWheelFrom = ChartCanvas.this.getDisplay().getFocusControl();
            if (stealWheelFrom != null && stealWheelFrom != ChartCanvas.this) {
                stealWheelFrom.addListener(37, (Listener)this);
                stealWheelFrom.addFocusListener((FocusListener)this);
                this.stealWheelFrom = stealWheelFrom;
            }
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.stop();
        }
    }

    class Zoomer
    implements Listener {
        Zoomer() {
        }

        public void handleEvent(Event event) {
            ChartCanvas.this.handleWheelEvent(event.stateMask, event.x, event.count);
        }
    }
}

