/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.openjdk.jmc.ui.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public abstract class MCAbstractUIPlugin
extends AbstractUIPlugin {
    public static final String ICON_DIRECTORY = "icons/";
    private static final int HIGH_CONTRAST_CUTOFF = 100;
    protected final Logger m_logger;
    protected final String m_pluginId;
    protected FormColors m_formColors;
    private volatile Vector<String> m_preloadImages = new Vector();
    private FormToolkit m_formToolkit;
    static volatile boolean hasInitiatedAWT;

    public MCAbstractUIPlugin(String pluginId) {
        this.m_logger = Logger.getLogger(pluginId);
        this.m_pluginId = pluginId;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.attemptToInitAWT();
    }

    private void attemptToInitAWT() {
        if (Display.getCurrent() != null) {
            if (!hasInitiatedAWT) {
                this.getLogger().log(Level.INFO, "Initiating AWT from " + this.getPluginId() + " activator.");
                Color.GREEN.toString();
                hasInitiatedAWT = true;
            }
        } else if (!hasInitiatedAWT) {
            this.getLogger().log(Level.WARNING, "Not in main thread with SWT Display when activating " + this.getPluginId(), new Exception(){

                @Override
                public String toString() {
                    return "Diagnostic stack trace";
                }
            });
        }
    }

    public void registerFromImageConstantClass(ImageRegistry registry, Class<?> classWithConstants) {
        Field[] fieldArray = classWithConstants.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String iconName = (String)field.get(null);
                this.registerImage(registry, iconName, iconName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Could not access field icon constant class");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Could not access field icon constant class");
            }
            ++n2;
        }
    }

    public String getPluginId() {
        return this.m_pluginId;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public FormToolkit getFormToolkit() {
        if (this.m_formToolkit == null) {
            this.m_formToolkit = new FormToolkit(this.getFormColors(Display.getCurrent()));
        }
        return this.m_formToolkit;
    }

    public FormColors getFormColors(Display display) {
        if (this.m_formColors == null) {
            this.m_formColors = new FormColors(display);
            this.m_formColors.markShared();
            RGB BLACK = new RGB(0, 0, 0);
            if (this.colorDistance(BLACK, this.m_formColors.getBackground().getRGB()) > 100) {
                this.m_formColors.createColor("org.eclipse.ui.forms.TITLE", BLACK);
            }
        }
        return this.m_formColors;
    }

    private int colorDistance(RGB title, RGB background) {
        int r = Math.abs(title.red - background.red);
        int g = Math.abs(title.green - background.green);
        int b = Math.abs(title.blue - background.blue);
        return r + g + b;
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public void schedulePreloading() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ImageRegistry registry = MCAbstractUIPlugin.this.getImageRegistry();
                    for (String key : MCAbstractUIPlugin.this.m_preloadImages) {
                        UIPlugin.getDefault().getLogger().log(Level.INFO, "Preloading image" + key);
                        registry.get(key);
                    }
                }
                catch (Exception t) {
                    UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not preload images", t);
                }
            }
        };
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.m_formColors != null) {
                this.m_formColors.dispose();
                this.m_formColors = null;
            }
            if (this.m_formToolkit != null) {
                this.m_formToolkit.dispose();
                this.m_formToolkit = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    protected String getImageDescriptorPath(String imageName) {
        return ICON_DIRECTORY + imageName;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        URL url = this.getBundle().getEntry(path);
        if (url == null) {
            return null;
        }
        return this.getImageDescriptor(url);
    }

    public ImageDescriptor getImageDescriptor(URL url) {
        return ImageDescriptor.createFromURL((URL)url);
    }

    public ImageDescriptor getMCImageDescriptor(String imageName) {
        ImageDescriptor descriptor = this.getImageDescriptor(this.getImageDescriptorPath(imageName));
        if (descriptor == null) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Icon not found " + imageName);
        }
        return descriptor;
    }

    public ImageDescriptor getMCImageDescriptor(URL imageUrl) {
        ImageDescriptor descriptor = this.getImageDescriptor(imageUrl);
        if (descriptor == null) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Icon not found " + imageUrl);
        }
        return descriptor;
    }

    protected void registerImage(ImageRegistry registry, String key, String imageName) {
        try {
            this.m_preloadImages.add(key);
            if (registry.get(key) != null) {
                this.getLogger().log(Level.INFO, "Warning! ImageDescriptor already in image registry. Current descriptor will be replaced with " + imageName);
            }
            registry.put(key, this.getMCImageDescriptor(imageName));
        }
        catch (Exception e) {
            this.getLogger().log(Level.CONFIG, "Could not load icon with file name " + imageName, e);
        }
    }

    protected void registerImage(ImageRegistry registry, String key, URL imageUrl) {
        try {
            this.m_preloadImages.add(key);
            if (registry.get(key) != null) {
                this.getLogger().log(Level.INFO, "Warning! ImageDescriptor already in image registry. Current descriptor will be replaced with " + imageUrl);
            }
            registry.put(key, this.getMCImageDescriptor(imageUrl));
        }
        catch (Exception e) {
            this.getLogger().log(Level.CONFIG, "Could not load icon with URL " + imageUrl, e);
        }
    }

    public void runProgressTask(boolean async, final boolean fork, final boolean canceable, final IRunnableWithProgress runnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    progressService.run(fork, canceable, runnable);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null) {
                        MessageDialog.openError(null, (String)Messages.MCAbstractUIPlugin_ERROR_HAS_OCCURRED_TEXT, (String)e.getCause().getMessage());
                        MCAbstractUIPlugin.this.getLogger().log(Level.INFO, Messages.MCAbstractUIPlugin_ERROR_RUNNING_TASK_TEXT, e.getCause());
                    }
                }
                catch (InterruptedException e) {
                    MCAbstractUIPlugin.this.getLogger().log(Level.INFO, Messages.MCAbstractUIPlugin_PROGRESS_TASK_INTERRUPTED_TEXT, e);
                }
            }
        };
        Display display = Display.getDefault();
        if (async) {
            display.asyncExec(r);
        } else {
            r.run();
        }
    }

    public Preferences getPreferences(String ... path) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(this.m_pluginId);
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            node = node.node(p);
            ++n2;
        }
        return node;
    }
}

