/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.ISpanSeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RenderedRowBase;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYQuantities;

public class SpanRenderer<T>
implements IXDataRenderer {
    private final ISpanSeries<T> series;
    private final AWTChartToolkit.IColorProvider<? super T> colorProvider;
    private final boolean markBoundaries;

    public static <T> IXDataRenderer withBoundaries(ISpanSeries<T> series, AWTChartToolkit.IColorProvider<? super T> colorProvider) {
        return new SpanRenderer<T>(series, colorProvider, true);
    }

    public static <T> IXDataRenderer build(ISpanSeries<T> series, AWTChartToolkit.IColorProvider<? super T> colorProvider) {
        return new SpanRenderer<T>(series, colorProvider, false);
    }

    private SpanRenderer(ISpanSeries<T> series, AWTChartToolkit.IColorProvider<? super T> colorProvider, boolean markBoundaries) {
        this.series = series;
        this.colorProvider = colorProvider;
        this.markBoundaries = markBoundaries;
    }

    @Override
    public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
        XYQuantities<T[]> quantities = this.series.getQuantities(xRange);
        quantities.setYRange(xRange);
        AWTChartToolkit.drawSpan(context, quantities, height, this.markBoundaries, this.colorProvider);
        return new SpanRendering<T>(height, quantities, this.series, this.colorProvider);
    }

    private static class SpanRendering<T>
    extends RenderedRowBase {
        private final AWTChartToolkit.IColorProvider<? super T> colorProvider;
        private final ISpanSeries<T> series;
        private final XYQuantities<T[]> points;

        SpanRendering(int height, XYQuantities<T[]> quantities, ISpanSeries<T> series, AWTChartToolkit.IColorProvider<? super T> colorProvider) {
            super(height);
            this.points = quantities;
            this.series = series;
            this.colorProvider = colorProvider;
        }

        @Override
        public void infoAt(IChartInfoVisitor visitor, int x, int y, Point offset) {
            int bucket;
            if (this.points != null && (bucket = this.points.floorIndexAtX(x)) >= 0 && bucket < this.points.getSize()) {
                T[] payload = this.points.getPayload();
                Span span = new Span(bucket, offset);
                double limitPixel = payload[bucket] != null ? Math.max((double)x, this.points.getXRange().getPixel(span.getStartX())) : (double)x;
                while (bucket >= 0) {
                    if (payload[bucket] != null && limitPixel <= this.points.getPixelY(bucket)) {
                        span.index = bucket;
                        visitor.visit(span);
                    }
                    --bucket;
                }
            }
        }

        private class Span
        extends XYQuantities.AbstractSpan {
            public Span(int index, Point2D offset) {
                super(index, offset);
            }

            protected XYQuantities<T[]> getXYSet() {
                return SpanRendering.this.points;
            }

            @Override
            protected int getHeight() {
                return SpanRendering.this.getHeight();
            }

            @Override
            public Color getColor() {
                Object[] payload = (Object[])SpanRendering.this.points.getPayload();
                return SpanRendering.this.colorProvider != null ? SpanRendering.this.colorProvider.getColor(payload[this.index]) : null;
            }

            @Override
            public IQuantity getStartX() {
                Object[] payload = (Object[])SpanRendering.this.points.getPayload();
                IQuantity start = SpanRendering.this.series.getStartX(payload[this.index]);
                return start == null ? super.getStartX() : start;
            }
        }
    }
}

