/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jdp.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXServiceURL;

final class JRockitJDPPacketDecoder {
    public static final String KEY_VERSION = "version";
    private static final char DELIMITER = '!';
    private static final String KEY_SERVICE_URL = "serviceURL";
    private static final String KEY_NAME = "name";

    private JRockitJDPPacketDecoder() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static boolean checkJRockitJDP(byte[] data) {
        return data[4] == 33;
    }

    public static Map<String, String> decodeJRockitJDP(byte[] data) {
        boolean supportsJMXRMI;
        int port;
        String address;
        HashMap<String, String> result;
        block8: {
            ByteArrayInputStream bis = new ByteArrayInputStream(data, 2, data.length - 2);
            DataInputStream dis = new DataInputStream(bis);
            result = new HashMap<String, String>();
            address = null;
            port = 0;
            supportsJMXRMI = true;
            String payload = null;
            try {
                payload = dis.readUTF();
                StringTokenizer strTok = new StringTokenizer(payload, String.valueOf('!'), false);
                int totalTokens = strTok.countTokens();
                if (totalTokens >= 4) {
                    JRockitJDPPacketDecoder.decodeExtendedInfo(result, strTok.nextToken());
                    supportsJMXRMI = JRockitJDPPacketDecoder.useJMXMAPI(strTok.nextToken());
                    address = strTok.nextToken();
                    port = Integer.parseInt(strTok.nextToken());
                    if (totalTokens >= 5) {
                        result.put(KEY_NAME, strTok.nextToken());
                    }
                    break block8;
                }
                address = strTok.nextToken();
                try {
                    port = Integer.parseInt(strTok.nextToken());
                }
                catch (NumberFormatException numberFormatException) {}
                supportsJMXRMI = false;
            }
            catch (Exception exception) {}
        }
        try {
            result.put(KEY_SERVICE_URL, JRockitJDPPacketDecoder.createServiceURL(address, port, supportsJMXRMI).toString());
        }
        catch (MalformedURLException malformedURLException) {}
        result.put("DISCOVERABLE_SESSION_UUID", String.valueOf(address) + ":" + port);
        return result;
    }

    private static boolean useJMXMAPI(String token) {
        return "1".equals(token);
    }

    private static JMXServiceURL createServiceURL(String host, int port, boolean useJMXRMI) throws MalformedURLException {
        if (useJMXRMI) {
            return new JMXServiceURL("rmi", "", 0, "/jndi/rmi://" + host + ":" + port + "/jmxrmi");
        }
        return new JMXServiceURL("rmp", host, port);
    }

    private static void decodeExtendedInfo(Map<String, String> result, String extendedInfo) {
        String[] info = extendedInfo.split(",");
        if (info == null) {
            return;
        }
        if (info.length == 1 && extendedInfo.indexOf(61) < 0) {
            result.put(KEY_VERSION, extendedInfo);
            return;
        }
        String[] stringArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] keyValue = element.split("=");
            if (keyValue != null && keyValue.length == 2) {
                result.put(keyValue[0], keyValue[1]);
            }
            ++n2;
        }
    }
}

