/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.flightrecorder.configuration.internal.FixedDescriptorMap;
import org.openjdk.jmc.flightrecorder.configuration.internal.IMapper;
import org.openjdk.jmc.flightrecorder.configuration.internal.Messages;

public class DefaultValueMap<K>
implements IDescribedMap<K> {
    private final Map<K, ? extends IOptionDescriptor<?>> knownOptions;
    private final IMapper<K, IOptionDescriptor<?>> fallbacks;

    public DefaultValueMap(Map<K, ? extends IOptionDescriptor<?>> knownOptions) {
        this(knownOptions, null);
    }

    public DefaultValueMap(IMapper<K, IOptionDescriptor<?>> fallbacks) {
        this(Collections.emptyMap(), fallbacks);
    }

    public DefaultValueMap(Map<K, ? extends IOptionDescriptor<?>> knownOptions, IMapper<K, IOptionDescriptor<?>> fallbacks) {
        this.knownOptions = knownOptions;
        this.fallbacks = fallbacks;
    }

    public IMutableConstrainedMap<K> emptyWithSameConstraints() {
        return new FixedDescriptorMap<K>(this.makeCombinedMapper());
    }

    public IMutableConstrainedMap<K> mutableCopy() {
        FixedDescriptorMap<K> copy = new FixedDescriptorMap<K>(this.makeCombinedMapper());
        try {
            for (Map.Entry<K, IOptionDescriptor<?>> entry : this.knownOptions.entrySet()) {
                Object value = entry.getValue().getDefault();
                if (value == null) continue;
                copy.put(entry.getKey(), value);
            }
        }
        catch (QuantityConversionException e) {
            throw new RuntimeException("Implementation error", e);
        }
        return copy;
    }

    protected IMapper<K, ? extends IOptionDescriptor<?>> makeCombinedMapper() {
        if (this.knownOptions.isEmpty()) {
            return this.fallbacks;
        }
        if (this.fallbacks == null) {
            return new IMapper.MapMapper(this.knownOptions);
        }
        return new IMapper<K, IOptionDescriptor<?>>(){

            @Override
            public IOptionDescriptor<?> get(K key) {
                IOptionDescriptor desc = (IOptionDescriptor)DefaultValueMap.this.knownOptions.get(key);
                return desc != null ? desc : (IOptionDescriptor)DefaultValueMap.this.fallbacks.get(key);
            }
        };
    }

    protected IOptionDescriptor<?> getDescriptor(K key) {
        IOptionDescriptor<?> desc = this.knownOptions.get(key);
        return desc == null && this.fallbacks != null ? this.fallbacks.get(key) : desc;
    }

    public IConstraint<?> getConstraint(K key) {
        IOptionDescriptor<?> desc = this.getDescriptor(key);
        return desc != null ? desc.getConstraint() : null;
    }

    public IOptionDescriptor<?> getDescribable(K key) {
        return this.getDescriptor(key);
    }

    public Set<K> keySet() {
        return this.knownOptions.keySet();
    }

    public Object get(K key) {
        IOptionDescriptor<?> desc = this.knownOptions.get(key);
        return desc != null ? desc.getDefault() : null;
    }

    public String getPersistableString(K key) {
        return this.getPersistableDefault(this.getDescriptor(key));
    }

    private <V> String getPersistableDefault(IOptionDescriptor<V> desc) {
        if (desc != null) {
            try {
                Object value = desc.getDefault();
                return value == null ? null : desc.getConstraint().persistableString(value);
            }
            catch (QuantityConversionException e) {
                Messages.LOGGER.log(Level.WARNING, "Problem parsing option default", e);
            }
        }
        return null;
    }
}

