/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.widget;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.uicomponents.FieldRenderer;
import org.openjdk.jmc.console.ui.notification.widget.TableStackSelectionManager;
import org.openjdk.jmc.rjmx.triggers.ITriggerConstraint;
import org.openjdk.jmc.rjmx.triggers.TriggerConstraint;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.extension.internal.TriggerComponent;
import org.openjdk.jmc.rjmx.triggers.fields.internal.FieldHolder;
import org.openjdk.jmc.rjmx.triggers.internal.INotificationFactory;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;
import org.openjdk.jmc.rjmx.triggers.internal.RegistryEntry;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.uibuilder.IUIBuilder;

public class ConstraintChooser {
    private final IUIBuilder m_UIbuilder;
    private final TriggerRule m_notificationRule;
    private final HashMap<String, ITriggerConstraint> m_constraintCache = new HashMap();
    private CheckboxTableViewer m_viewer;
    private final Composite m_parent;
    private final boolean m_showDescription;
    private final boolean m_showIcons;

    public ConstraintChooser(IUIBuilder builder, TriggerRule notificationRule, NotificationRegistry notificationModel, Composite parent, boolean showDescription, boolean showIcons) {
        this.m_UIbuilder = builder;
        this.m_notificationRule = notificationRule;
        this.m_showDescription = showDescription;
        this.m_showIcons = showIcons;
        this.m_parent = parent;
        this.buildCache(notificationRule, notificationModel);
        this.create(parent);
    }

    void refreshCheckActiveConstraints() {
        this.m_viewer.setCheckedElements(this.m_notificationRule.getConstraintHolder().getConstraintList().toArray());
    }

    private void buildCache(TriggerRule notificationRule, NotificationRegistry notificationModel) {
        for (RegistryEntry entry : notificationModel.getAvailableConstraints()) {
            try {
                INotificationFactory af = notificationModel.getFactory();
                String name = entry.getRegisteredClass().getName();
                ITriggerConstraint nc = af.createConstraint(name);
                this.m_constraintCache.put(nc.getName(), nc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ITriggerConstraint nc : notificationRule.getConstraintHolder().getConstraintList()) {
            this.m_constraintCache.put(nc.getName(), nc);
        }
    }

    void addConstraintToCache(TriggerConstraint tc) {
        this.m_constraintCache.put(tc.getName(), (ITriggerConstraint)tc);
    }

    public IUIBuilder getUIBuilder() {
        return this.m_UIbuilder;
    }

    public List<ITriggerConstraint> getActivatedConstraints() {
        return this.m_notificationRule.getConstraintHolder().getConstraintList();
    }

    public void create(Composite container) {
        if (this.getUIBuilder() == null || this.m_notificationRule == null) {
            return;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.marginTop = 4;
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.verticalIndent = 2;
        gd1.horizontalIndent = 2;
        Table table = this.getUIBuilder().createTable(container, true);
        table.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        Composite stack = this.getUIBuilder().createComposite(container);
        stack.setLayoutData((Object)gd2);
        container.setLayout((Layout)gridLayout);
        TableStackSelectionManager tableItemSelector = new TableStackSelectionManager(stack);
        this.createStacks(stack, tableItemSelector);
        this.createViewer(table, tableItemSelector);
        this.refreshCheckActiveConstraints();
    }

    private TableStackSelectionManager createStacks(Composite container, TableStackSelectionManager tableItemSelector) {
        container.setLayout((Layout)tableItemSelector.getStackLayout());
        for (ITriggerConstraint contraint : this.m_constraintCache.values()) {
            if (!(contraint instanceof TriggerComponent)) continue;
            TriggerComponent component = (TriggerComponent)contraint;
            FieldHolder holder = component.getFieldHolder();
            Composite stackContainer = this.getUIBuilder().createComposite(container);
            stackContainer.setLayout((Layout)new FillLayout());
            this.getUIBuilder().setContainer(stackContainer);
            if (this.m_showDescription) {
                this.getUIBuilder().createCaption(component.getName());
                this.getUIBuilder().layout();
                this.getUIBuilder().createSeparator();
                this.getUIBuilder().layout();
                this.getUIBuilder().createWrapLabel(component.getDescription(), "");
                this.getUIBuilder().layout();
            }
            FieldRenderer tcr = new FieldRenderer(holder, this.getUIBuilder());
            tcr.render();
            tableItemSelector.addMapping(component, (Control)stackContainer);
        }
        return tableItemSelector;
    }

    private void selectConstraint(Object o) {
        if (o != null) {
            this.m_viewer.setSelection((ISelection)new StructuredSelection(o));
            return;
        }
        Object[] constraints = this.m_viewer.getCheckedElements();
        if (constraints.length > 0) {
            this.selectConstraint(constraints[0]);
            return;
        }
        if (this.m_constraintCache.size() > 0) {
            this.selectConstraint(this.m_constraintCache.values().iterator().next());
        }
    }

    private void createViewer(Table table, final TableStackSelectionManager tableItemSelector) {
        this.m_viewer = new CheckboxTableViewer(table);
        this.m_viewer.addCheckStateListener((ICheckStateListener)new CheckListener());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ConstraintLabelProvider());
        this.m_viewer.setContentProvider((IContentProvider)new TriggerContentProvider());
        this.m_viewer.setComparator(new ViewerComparator());
        this.m_viewer.setInput(this.m_constraintCache);
        this.m_viewer.refresh();
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object o = s.getFirstElement();
                tableItemSelector.select(o);
                ConstraintChooser.this.m_parent.layout();
            }
        });
        this.selectConstraint(null);
    }

    public class CheckListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            ITriggerConstraint nc = (ITriggerConstraint)event.getElement();
            if (event.getChecked()) {
                ConstraintChooser.this.m_notificationRule.getConstraintHolder().addConstraint(nc);
            } else {
                ConstraintChooser.this.m_notificationRule.getConstraintHolder().removeConstraint(nc);
                NotificationPlugin.getDefault().getLogger().info("Removing" + ConstraintChooser.this.m_notificationRule.getConstraintHolder().getConstraintList().size());
            }
        }
    }

    public class ConstraintLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return ConstraintChooser.this.m_showIcons ? NotificationPlugin.getDefault().getImage(element, true) : null;
        }

        public String getText(Object element) {
            if (element instanceof ITriggerConstraint) {
                return ((ITriggerConstraint)element).getName();
            }
            return null;
        }
    }

    public class TriggerContentProvider
    extends AbstractStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ConstraintChooser.this.m_constraintCache.values().toArray();
        }
    }
}

