/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.data;

import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.openjdk.jmc.greychart.data.DataSeriesProvider;
import org.openjdk.jmc.ui.common.xydata.DataSeries;

public class SeriesProviderSet<T>
extends Observable
implements DataSeriesProvider<T> {
    private final Set<DataSeries<T>> dataSeries = new HashSet<DataSeries<T>>();

    @Override
    public synchronized DataSeries<T>[] getDataSeries() {
        return this.dataSeries.toArray(new DataSeries[this.dataSeries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSeries(DataSeries<T> series) {
        SeriesProviderSet seriesProviderSet = this;
        synchronized (seriesProviderSet) {
            this.dataSeries.add(series);
        }
        this.sendNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSeries(List<? extends DataSeries<T>> series) {
        SeriesProviderSet seriesProviderSet = this;
        synchronized (seriesProviderSet) {
            this.dataSeries.addAll(series);
        }
        this.sendNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSeries(DataSeries<T> series) {
        boolean result;
        SeriesProviderSet seriesProviderSet = this;
        synchronized (seriesProviderSet) {
            result = this.dataSeries.remove(series);
        }
        this.sendNotification();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDataSeries(List<? extends DataSeries<T>> series) {
        boolean result;
        SeriesProviderSet seriesProviderSet = this;
        synchronized (seriesProviderSet) {
            result = this.dataSeries.removeAll(series);
        }
        this.sendNotification();
        return result;
    }

    public void sendNotification() {
        this.setChanged();
        this.notifyObservers();
    }
}

