/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class SocketReadRule
implements IRule {
    private static final String RESULT_ID = "SocketRead";
    public static final TypedPreference<IQuantity> READ_INFO_LIMIT = new TypedPreference("io.socket.read.info.limit", Messages.getString("SocketReadRule_CONFIG_INFO_LIMIT"), Messages.getString("SocketReadRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(275L));
    public static final TypedPreference<IQuantity> READ_WARNING_LIMIT = new TypedPreference("io.socket.read.warning.limit", Messages.getString("SocketReadRule_CONFIG_WARNING_LIMIT"), Messages.getString("SocketReadRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(READ_INFO_LIMIT, READ_WARNING_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return SocketReadRule.this.evaluate(items, (IQuantity)vp.getPreferenceValue(READ_INFO_LIMIT), (IQuantity)vp.getPreferenceValue(READ_WARNING_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, IQuantity infoLimit, IQuantity warningLimit) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.SocketRead"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.SocketRead"});
        }
        IItemCollection readItems = items.apply(JdkFilters.NO_RMI_SOCKET_READ);
        IType readType = RulesToolkit.getType((IItemCollection)readItems, (String)"jdk.SocketRead");
        if (!readType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.IO_ADDRESS)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)readType, (IAttribute)JdkAttributes.IO_ADDRESS);
        }
        IItem longestEvent = (IItem)readItems.getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            String shortMessage = Messages.getString("SocketReadRuleFactory_TEXT_NO_EVENTS");
            String longMessage = shortMessage + "<p>" + Messages.getString("SocketReadRuleFactory_TEXT_RMI_NOTE");
            return new Result((IRule)this, 0.0, shortMessage, longMessage, JdkQueries.NO_RMI_SOCKET_READ);
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String peakDuration = maxDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String address = SocketReadRule.sanitizeAddress((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_ADDRESS));
            String amountRead = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_SOCKET_BYTES_READ)).displayUsing("auto");
            String shortMessage = MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_WARN"), maxDuration.displayUsing("auto"));
            String longMessage = MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_WARN_LONG"), peakDuration, address, amountRead) + " " + Messages.getString("SocketReadRuleFactory_TEXT_RMI_NOTE");
            return new Result((IRule)this, score, shortMessage, longMessage, JdkQueries.NO_RMI_SOCKET_READ);
        }
        String shortMessage = MessageFormat.format(Messages.getString("SocketReadRuleFactory_TEXT_OK"), peakDuration);
        String longMessage = shortMessage + "<p>" + Messages.getString("SocketReadRuleFactory_TEXT_RMI_NOTE");
        return new Result((IRule)this, score, shortMessage, longMessage, JdkQueries.NO_RMI_SOCKET_READ);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SocketReadRuleFactory_RULE_NAME");
    }

    protected static String sanitizeAddress(String address) {
        if (address == null || address.isEmpty()) {
            return Encode.forHtml((String)Messages.getString("General_UNKNOWN_ADDRESS"));
        }
        return Encode.forHtml((String)address);
    }

    public String getTopic() {
        return "socket_io";
    }
}

