/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.common.tree.IParent;

public class EventTypeFolderNode
implements IParent<Object> {
    private final String name;
    private final List<Object> children = new ArrayList<Object>();

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventTypeFolderNode) {
            return Objects.equals(this.name, ((EventTypeFolderNode)obj).name);
        }
        return false;
    }

    private EventTypeFolderNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.name;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<?> getChildren() {
        return this.children;
    }

    public String toString() {
        return "EventTypeFolderNode: " + this.getName();
    }

    public IQuantity getCount() {
        return UnitLookup.NUMBER_UNITY.quantity(this.performCount());
    }

    private long performCount() {
        long childCount = 0L;
        for (Object c : this.children) {
            if (c instanceof EventTypeFolderNode) {
                childCount += ((EventTypeFolderNode)c).performCount();
                continue;
            }
            if (!(c instanceof EventTypeNode)) continue;
            childCount += ((EventTypeNode)c).count;
        }
        return childCount;
    }

    private void sortChildren() {
        for (Object c : this.getChildren()) {
            if (!(c instanceof EventTypeFolderNode)) continue;
            ((EventTypeFolderNode)c).sortChildren();
        }
        Collections.sort(this.getChildren(), new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof EventTypeFolderNode && o2 instanceof EventTypeFolderNode) {
                    return ((EventTypeFolderNode)o1).getName().compareTo(((EventTypeFolderNode)o2).getName());
                }
                if (o1 instanceof EventTypeNode && o2 instanceof EventTypeNode) {
                    return ((EventTypeNode)o1).type.getName().compareTo(((EventTypeNode)o2).type.getName());
                }
                return o1 instanceof EventTypeFolderNode ? -1 : 1;
            }
        });
    }

    private EventTypeFolderNode getOrCreateFolder(String label) {
        for (Object c : this.children) {
            if (!(c instanceof EventTypeFolderNode) || !((EventTypeFolderNode)c).getName().equals(label)) continue;
            return (EventTypeFolderNode)c;
        }
        EventTypeFolderNode folder = new EventTypeFolderNode(label);
        this.children.add(folder);
        return folder;
    }

    static EventTypeFolderNode buildRoot(Stream<TypeWithCategory> allEventTypes) {
        EventTypeFolderNode eventTypesRoot = new EventTypeFolderNode(Messages.EVENT_TYPE_FOLDER_NODE_EVENTS_BY_TYPE);
        allEventTypes.forEach(e -> EventTypeFolderNode.addEventType(eventTypesRoot, e.getType(), e.getCategory(), e.getCount()));
        eventTypesRoot.sortChildren();
        return eventTypesRoot;
    }

    private static void addEventType(EventTypeFolderNode parentNode, IType<IItem> t, String[] category, long count) {
        if (category != null && category.length > 0) {
            String[] stringArray = category;
            int n = category.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                parentNode = parentNode.getOrCreateFolder(part.trim());
                ++n2;
            }
        } else {
            parentNode = parentNode.getOrCreateFolder(Messages.EVENT_TYPE_FOLDER_NODE_UNCATEGORIZED);
        }
        parentNode.children.add(new EventTypeNode(t, count));
    }

    public static class EventTypeNode {
        private final IType<IItem> type;
        private final long count;

        EventTypeNode(IType<IItem> type, long count) {
            this.type = type;
            this.count = count;
        }

        public String toString() {
            return "EventTypeNode: " + this.type.getName() + "(" + this.type.getIdentifier() + ")";
        }

        public IType<IItem> getType() {
            return this.type;
        }

        public IQuantity getCount() {
            return UnitLookup.NUMBER_UNITY.quantity(this.count);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object obj) {
            if (obj instanceof EventTypeNode) {
                return Objects.equals(this.type, ((EventTypeNode)obj).type);
            }
            return false;
        }
    }

    static class TypeWithCategory {
        private final String[] category;
        private final IType<IItem> type;
        private final long count;

        TypeWithCategory(IType<IItem> type, String[] category, long count) {
            this.category = category;
            this.type = type;
            this.count = count;
        }

        IType<IItem> getType() {
            return this.type;
        }

        String[] getCategory() {
            return this.category;
        }

        long getCount() {
            return this.count;
        }
    }
}

