/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.collection.IteratorToolkit;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.QuantitiesToolkit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.RangeContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.FlavoredSelectionBase;
import org.openjdk.jmc.flightrecorder.ui.selection.IFilterFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IPropertyFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.ItemBackedSelection;
import org.openjdk.jmc.ui.TypeAppearance;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

public class JfrPropertySheet
extends Page
implements IPropertySheetPage {
    private static final String HELP_CONTEXT_ID = "org.openjdk.jmc.flightrecorder.ui.JfrPropertiesView";
    private static final Object TOO_MANY_VALUES = new Object();
    private static final PropertySheetRow CALCULATING = new PropertySheetRow(null, null);
    private static final IColumn FIELD_COLUMN = new ColumnBuilder(Messages.JFR_PROPERTY_SHEET_FIELD, "field", (ColumnLabelProvider)new TypedLabelProvider<PropertySheetRow>(PropertySheetRow.class){

        protected String getTextTyped(PropertySheetRow p) {
            return p.attribute == null ? "" : p.attribute.getName();
        }

        protected String getToolTipTextTyped(PropertySheetRow p) {
            return p.attribute == null ? "" : String.valueOf(NLS.bind((String)Messages.ATTRIBUTE_ID_LABEL, (Object)p.attribute.getIdentifier())) + System.getProperty("line.separator") + NLS.bind((String)Messages.ATTRIBUTE_DESCRIPTION_LABEL, (Object)p.attribute.getDescription());
        }

        protected Image getImageTyped(PropertySheetRow p) {
            if (p.attribute != null) {
                Image icon = TypeAppearance.getImage((String)p.attribute.getContentType().getIdentifier());
                return icon == null ? UIPlugin.getDefault().getImage("property_obj.gif") : icon;
            }
            return null;
        }
    }).build();
    private static final IColumn VALUE_COLUMN = new ColumnBuilder(Messages.JFR_PROPERTY_SHEET_VALUE, "value", (ColumnLabelProvider)new TypedLabelProvider<PropertySheetRow>(PropertySheetRow.class){

        protected String getTextTyped(PropertySheetRow p) {
            Object value = p.getValue();
            if (p == CALCULATING) {
                return Messages.JFR_PROPERTIES_CALCULATING;
            }
            if (value == TOO_MANY_VALUES) {
                return Messages.JFR_PROPERTIES_TOO_MANY_VALUES;
            }
            return this.getValueString(value);
        }

        private String getValueString(Object value) {
            if (value instanceof IItemCollection) {
                return JfrPropertySheet.itemCollectionDescription((IItemCollection)value);
            }
            if (value instanceof IDescribable) {
                return ((IDescribable)value).getName();
            }
            if (value instanceof IDescribable[] && ((IDescribable[])value).length > 0) {
                IDescribable[] values = (IDescribable[])value;
                return "[" + values[0].getName() + " ... " + values[values.length - 1].getName() + "]";
            }
            if (value instanceof Object[]) {
                return JfrPropertySheet.limitedDeepToString((Object[])value, this::getValueString);
            }
            if (value instanceof Collection) {
                return JfrPropertySheet.limitedDeepToString(((Collection)value).toArray(), this::getValueString);
            }
            return TypeHandling.getValueString((Object)value);
        }

        protected String getToolTipTextTyped(PropertySheetRow p) {
            Object value = p.getValue();
            if (value instanceof IQuantity) {
                return TypeHandling.getNumericString((Number)((IQuantity)value).numberValue());
            }
            return JfrPropertySheet.getVerboseString(value);
        }
    }).build();
    private static final IColumn VERBOSE_VALUE_COLUMN = new ColumnBuilder(Messages.JFR_PROPERTY_SHEET_VERBOSE_VALUE, "verboseValue", (ColumnLabelProvider)new TypedLabelProvider<PropertySheetRow>(PropertySheetRow.class){

        protected String getTextTyped(PropertySheetRow p) {
            Object value = p.getValue();
            if (p == CALCULATING) {
                return Messages.JFR_PROPERTIES_CALCULATING;
            }
            if (value == TOO_MANY_VALUES) {
                return Messages.JFR_PROPERTIES_TOO_MANY_VALUES;
            }
            return JfrPropertySheet.getVerboseString(value);
        }

        protected String getToolTipTextTyped(PropertySheetRow p) {
            return this.getTextTyped(p);
        }
    }).build();
    private TableViewer viewer;
    private final IPageContainer controller;
    private CompletableFuture<Void> viewerUpdater;
    private static final int MAX_DISTINCT_VALUES = 10;
    private static final Comparator<PropertySheetRow> RELEVANCE_ORDER = new Comparator<PropertySheetRow>(){

        @Override
        public int compare(PropertySheetRow o1, PropertySheetRow o2) {
            int a2c;
            int a1c = this.getAttributeCategory(o1.getAttribute());
            if (a1c == (a2c = this.getAttributeCategory(o2.getAttribute()))) {
                return o1.getAttribute().getIdentifier().compareTo(o2.getAttribute().getIdentifier());
            }
            return Integer.compare(a1c, a2c);
        }

        private int getAttributeCategory(IAttribute<?> attr) {
            ContentType ct = attr.getContentType();
            if (ct.equals(UnitLookup.TIMESTAMP)) {
                return 0;
            }
            if (ct instanceof KindOfQuantity) {
                return 2;
            }
            return 1;
        }
    };

    private static String limitedDeepToString(Object[] array, Function<Object, String> valueToStringProvider) {
        return JfrPropertySheet.limitedDeepToString(array, new StringBuilder(), true, valueToStringProvider);
    }

    private static String limitedDeepToString(Object[] array, StringBuilder builder, boolean isRootArray, Function<Object, String> valueToStringProvider) {
        int maxCharacters = FlightRecorderUI.getDefault().getPreferenceStore().getInt("flightrecorder.properties.array.string.size");
        int omitted = 0;
        builder.append('[');
        int i = 0;
        while (i < array.length) {
            Object element = array[i];
            if (element != null && element.getClass().isArray()) {
                JfrPropertySheet.limitedDeepToString((Object[])element, builder, false, valueToStringProvider);
            } else {
                builder.append(valueToStringProvider.apply(element));
            }
            if (i < array.length - 1 && builder.length() < maxCharacters) {
                builder.append(',');
                builder.append(' ');
            }
            if (isRootArray && builder.length() > maxCharacters) {
                builder.setLength(maxCharacters);
                builder.append(Messages.JFR_PROPERTIES_INSERTED_ELLIPSIS);
                omitted = array.length - 1 - i;
                break;
            }
            ++i;
        }
        if (isRootArray && omitted > 0) {
            builder.append(' ');
            if (omitted > 1) {
                builder.append(MessageFormat.format(Messages.JFR_PROPERTIES_ARRAY_WITH_OMITTED_ELEMENTS, omitted));
            } else {
                builder.append(Messages.JFR_PROPERTIES_ARRAY_WITH_OMITTED_ELEMENT);
            }
        }
        builder.append(']');
        return builder.toString();
    }

    private static String getVerboseString(Object value) {
        if (value instanceof IDisplayable) {
            return ((IDisplayable)value).displayUsing("verbose");
        }
        if (value instanceof IItemCollection) {
            return ItemCollectionToolkit.getDescription((IItemCollection)value);
        }
        if (value instanceof IDescribable) {
            return ((IDescribable)value).getDescription();
        }
        if (value instanceof IDescribable[] && ((IDescribable[])value).length > 0) {
            IDescribable[] values = (IDescribable[])value;
            return "[" + values[0].getDescription() + " ... " + values[values.length - 1].getDescription() + "]";
        }
        if (value instanceof Object[]) {
            return JfrPropertySheet.limitedDeepToString((Object[])value, JfrPropertySheet::getVerboseString);
        }
        if (value instanceof Collection) {
            return JfrPropertySheet.limitedDeepToString(((Collection)value).toArray(), JfrPropertySheet::getVerboseString);
        }
        return TypeHandling.getVerboseString((Object)value);
    }

    JfrPropertySheet(IPageContainer controller) {
        this.controller = controller;
    }

    public void createControl(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnManager manager = ColumnManager.build((TableViewer)this.viewer, Arrays.asList(FIELD_COLUMN, VALUE_COLUMN, VERBOSE_VALUE_COLUMN), (TableSettings)JfrPropertySheet.getTableSettings(null));
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.viewer.getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)manager, (MCContextMenuManager)mm);
        Function<Consumer, Function> actionProvider = flavorConsumer -> selected -> {
            if (selected.size() == 1 && ((PropertySheetRow)selected.get((int)0)).value != TOO_MANY_VALUES) {
                if (((PropertySheetRow)selected.get((int)0)).attribute != null) {
                    return () -> flavorConsumer.accept(new PropertySheetRowSelection((PropertySheetRow)selected.get(0)));
                }
                if (((PropertySheetRow)selected.get((int)0)).value instanceof IItemCollection) {
                    IItemCollection items = (IItemCollection)((PropertySheetRow)selected.get((int)0)).value;
                    String selectionName = JfrPropertySheet.itemCollectionDescription(items);
                    return () -> flavorConsumer.accept(new ItemBackedSelection(items, selectionName));
                }
            }
            return null;
        };
        mm.appendToGroup("group.edit", ActionToolkit.forListSelection((StructuredViewer)this.viewer, (String)Messages.STORE_SELECTION_ACTION, (boolean)false, (Function)actionProvider.apply(this.controller.getSelectionStore()::addSelection)));
        mm.appendToGroup("group.edit", ActionToolkit.forListSelection((StructuredViewer)this.viewer, (String)Messages.STORE_AND_ACTIVATE_SELECTION_ACTION, (boolean)false, (Function)actionProvider.apply(this.controller.getSelectionStore()::addAndSetAsCurrentSelection)));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), HELP_CONTEXT_ID);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            FocusTracker.enableFocusTracking((Composite)this.viewer.getTable());
        }
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings(null, Arrays.asList(new TableSettings.ColumnSettings(FIELD_COLUMN.getId(), Boolean.valueOf(false), Integer.valueOf(120), null), new TableSettings.ColumnSettings(VALUE_COLUMN.getId(), Boolean.valueOf(false), Integer.valueOf(120), null), new TableSettings.ColumnSettings(VERBOSE_VALUE_COLUMN.getId(), Boolean.valueOf(true), Integer.valueOf(400), null)));
        }
        return new TableSettings(state);
    }

    private static String itemCollectionDescription(IItemCollection items) {
        IQuantity count = (IQuantity)items.getAggregate(Aggregators.count());
        return NLS.bind((String)Messages.JFR_PROPERTY_SHEET_EVENTS, (Object)(count == null ? Integer.valueOf(0) : count.displayUsing("auto")));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object first;
        IItemCollection items;
        if (selection instanceof IStructuredSelection && (items = (IItemCollection)AdapterUtil.getAdapter((Object)(first = ((IStructuredSelection)selection).getFirstElement()), IItemCollection.class)) != null) {
            this.show(items);
        }
    }

    private void show(IItemCollection items) {
        if (this.viewerUpdater != null) {
            this.viewerUpdater.complete(null);
        }
        CompletableFuture<PropertySheetRow[]> modelBuilder = CompletableFuture.supplyAsync(() -> JfrPropertySheet.buildRows(items));
        this.viewerUpdater = modelBuilder.thenAcceptAsync(this::setViewerInput, DisplayToolkit.inDisplayThread());
        this.viewerUpdater.exceptionally(JfrPropertySheet::handleModelBuildException);
        DisplayToolkit.safeTimerExec((Display)Display.getCurrent(), (int)300, this::showCalculationFeedback);
    }

    private void setViewerInput(PropertySheetRow[] rows) {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.setInput((Object)rows);
        }
        this.viewerUpdater = null;
    }

    private void showCalculationFeedback() {
        if (this.viewerUpdater != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput((Object)new PropertySheetRow[]{CALCULATING});
        }
    }

    private static Void handleModelBuildException(Throwable ex) {
        FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to build properties view model", ex);
        return null;
    }

    private static PropertySheetRow[] buildRows(IItemCollection items) {
        Iterator nonEmpty = IteratorToolkit.filter((Iterator)items.iterator(), i -> i.iterator().hasNext());
        Stream<PropertySheetRow> rows = JfrPropertySheet.commonAttributes(nonEmpty).map(attr -> JfrPropertySheet.buildProperty(attr, items.iterator(), 10)).filter(Objects::nonNull);
        return (PropertySheetRow[])Stream.concat(rows, Stream.of(new PropertySheetRow(null, items))).toArray(PropertySheetRow[]::new);
    }

    private static Stream<IAttribute<?>> commonAttributes(Iterator<? extends IItemIterable> iterables) throws IllegalArgumentException {
        if (!iterables.hasNext()) {
            return Stream.empty();
        }
        IItemIterable single = iterables.next();
        ArrayList attributes = single.getType().getAttributes();
        if (iterables.hasNext()) {
            attributes = new ArrayList(attributes);
            while (iterables.hasNext()) {
                IType otherType = iterables.next().getType();
                Iterator aIterator = attributes.iterator();
                while (aIterator.hasNext()) {
                    if (otherType.hasAttribute((ICanonicalAccessorFactory)aIterator.next())) continue;
                    aIterator.remove();
                }
            }
        }
        return attributes.stream().filter(a -> a.getContentType() != UnitLookup.STACKTRACE);
    }

    public static Stream<IFilterFlavor> calculatePersistableFilterFlavors(IItemCollection srcItems, IItemCollection dstItems, IItemCollection allItems, List<IAttribute<?>> dstAttributes) {
        return JfrPropertySheet.calculatePersistableFilterFlavors(srcItems, dstItems, allItems, dstAttributes, a -> true);
    }

    public static Stream<IFilterFlavor> calculatePersistableFilterFlavors(IItemCollection srcItems, IItemCollection dstItems, IItemCollection allItems, List<IAttribute<?>> dstAttributes, Predicate<IAttribute<?>> include) {
        Stream<IAttribute<?>> commonAttributes = null;
        if (dstAttributes != null && !dstAttributes.isEmpty()) {
            commonAttributes = JfrPropertySheet.commonAttributes(srcItems.iterator()).filter(a -> dstAttributes.contains(a));
        } else {
            Stream<IItemIterable> items = Stream.concat(ItemCollectionToolkit.stream(srcItems), ItemCollectionToolkit.stream(dstItems));
            commonAttributes = JfrPropertySheet.commonAttributes(items.iterator());
        }
        Stream<IAttribute> persistableAttributes = DataPageToolkit.getPersistableAttributes(commonAttributes).filter(include::test);
        return persistableAttributes.map(attr -> JfrPropertySheet.buildProperty(attr, srcItems.iterator(), 10)).filter(p -> p != null && p.value != TOO_MANY_VALUES).sorted(RELEVANCE_ORDER).map(p -> IPropertyFlavor.build(p.attribute, p.value, allItems));
    }

    private static <M> PropertySheetRow buildProperty(IAttribute<M> attribute, Iterator<? extends IItemIterable> iterables, int maxDistinct) {
        Iterator items;
        IMemberAccessor accessor;
        IItemIterable ii;
        IQuantity maxValue;
        IQuantity minValue;
        ContentType contentType = attribute.getContentType();
        if (contentType instanceof KindOfQuantity) {
            IAttribute<M> qAttribute = attribute;
            minValue = null;
            maxValue = null;
            while (iterables.hasNext()) {
                ii = iterables.next();
                accessor = qAttribute.getAccessor(ii.getType());
                items = ii.iterator();
                while (items.hasNext()) {
                    IQuantity val = (IQuantity)accessor.getMember((Object)((IItem)items.next()));
                    if (val == null) continue;
                    if (minValue == null) {
                        minValue = maxValue = val;
                        continue;
                    }
                    minValue = (IQuantity)QuantitiesToolkit.min((Comparable)val, minValue);
                    maxValue = (IQuantity)QuantitiesToolkit.max((Comparable)val, (Comparable)maxValue);
                }
            }
            if (minValue != null) {
                if (minValue == maxValue) {
                    return new PropertySheetRow(qAttribute, minValue);
                }
                return new PropertySheetRow(qAttribute, QuantityRange.createWithEnd(minValue, maxValue));
            }
        } else if (contentType instanceof RangeContentType && ((RangeContentType)contentType).getEndPointContentType() instanceof KindOfQuantity) {
            IAttribute<M> rangeAttribute = attribute;
            minValue = null;
            maxValue = null;
            while (iterables.hasNext()) {
                ii = iterables.next();
                accessor = rangeAttribute.getAccessor(ii.getType());
                items = ii.iterator();
                while (items.hasNext()) {
                    IRange range = (IRange)accessor.getMember((Object)((IItem)items.next()));
                    if (range == null) continue;
                    if (minValue == null) {
                        minValue = (IQuantity)range.getStart();
                        maxValue = (IQuantity)range.getEnd();
                        continue;
                    }
                    minValue = (IQuantity)QuantitiesToolkit.min((Comparable)((IQuantity)range.getStart()), (Comparable)minValue);
                    maxValue = (IQuantity)QuantitiesToolkit.max((Comparable)((IQuantity)range.getEnd()), (Comparable)maxValue);
                }
            }
            if (minValue != null) {
                if (minValue == maxValue) {
                    return new PropertySheetRow(rangeAttribute, minValue);
                }
                return new PropertySheetRow(rangeAttribute, QuantityRange.createWithEnd(minValue, maxValue));
            }
        }
        HashSet<Object> keys = new HashSet<Object>();
        while (iterables.hasNext()) {
            IItemIterable ii2 = iterables.next();
            IMemberAccessor accessor2 = attribute.getAccessor(ii2.getType());
            Iterator items2 = ii2.iterator();
            while (items2.hasNext()) {
                if (keys.size() > maxDistinct) {
                    return new PropertySheetRow(attribute, TOO_MANY_VALUES);
                }
                keys.add(accessor2.getMember((Object)((IItem)items2.next())));
            }
        }
        if (keys.size() == 0) {
            return null;
        }
        if (keys.size() == 1) {
            return new PropertySheetRow(attribute, keys.iterator().next());
        }
        return new PropertySheetRow(attribute, keys);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static class PropertySheetRow {
        final IAttribute<?> attribute;
        final Object value;

        PropertySheetRow(IAttribute<?> attribute, Object value) {
            this.attribute = attribute;
            this.value = value;
        }

        public IAttribute<?> getAttribute() {
            return this.attribute;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static class PropertySheetRowSelection
    extends FlavoredSelectionBase {
        private final PropertySheetRow row;

        PropertySheetRowSelection(PropertySheetRow row) {
            super(MessageFormat.format(Messages.JFR_PROPERTIES_PROPERTY_SELECTION, row.attribute.getName()));
            this.row = row;
        }

        @Override
        public Stream<IItemStreamFlavor> getFlavors(IItemFilter dstFilter, IItemCollection items, List<IAttribute<?>> dstAttributes) {
            IItemCollection filteredDstItems = ItemCollectionToolkit.filterIfNotNull(items, dstFilter);
            IPropertyFlavor relatedFilterFlavor = IPropertyFlavor.build(this.row.attribute, this.row.value, filteredDstItems);
            LinkedList<IPropertyFlavor> flavors = new LinkedList<IPropertyFlavor>();
            boolean anyRelatedOnDst = ((IItemCollection)relatedFilterFlavor.evaluate()).hasItems();
            IPropertyFlavor selectedPropertyFlavor = IPropertyFlavor.build(this.row.attribute, this.row.value, items);
            if (anyRelatedOnDst) {
                flavors.add(selectedPropertyFlavor);
                selectedPropertyFlavor = null;
            }
            IItemCollection itemsRelatedToSelection = items.apply(relatedFilterFlavor.getFilter());
            if (dstAttributes == null || dstAttributes.isEmpty()) {
                dstAttributes = JfrPropertySheet.commonAttributes(filteredDstItems.iterator()).collect(Collectors.toList());
            }
            Iterator<IAttribute<?>> commonDstAttr = dstAttributes.iterator();
            ArrayList<IPropertyFlavor> relatedProperties = new ArrayList<IPropertyFlavor>();
            while (commonDstAttr.hasNext()) {
                PropertySheetRow av;
                IAttribute<?> dstAttribute = commonDstAttr.next();
                if (dstAttribute.equals((Object)JfrAttributes.EVENT_TYPE) || dstAttribute.getContentType() instanceof KindOfQuantity && !dstAttribute.equals((Object)JfrAttributes.END_TIME)) continue;
                if (dstAttribute.equals(this.row.attribute)) {
                    if (!anyRelatedOnDst && selectedPropertyFlavor != null) {
                        flavors.push(selectedPropertyFlavor);
                        selectedPropertyFlavor = null;
                    }
                    relatedProperties = null;
                } else if (!dstAttribute.equals(this.row.attribute) && dstAttribute.getContentType().equals(this.row.attribute.getContentType())) {
                    flavors.add(IPropertyFlavor.build(dstAttribute, this.row.value, items));
                }
                if (relatedProperties == null || (av = JfrPropertySheet.buildProperty(dstAttribute, ItemCollectionToolkit.stream(itemsRelatedToSelection).filter(is -> dstAttribute.getAccessor(is.getType()) != null).iterator(), Integer.MAX_VALUE)) == null) continue;
                relatedProperties.add(IPropertyFlavor.build(av.attribute, av.value, items));
            }
            if (relatedProperties != null) {
                if (relatedProperties.size() > 1) {
                    flavors.add(IPropertyFlavor.combine(relatedProperties::stream, items));
                }
                flavors.addAll(relatedProperties);
            }
            if (selectedPropertyFlavor != null) {
                flavors.add(selectedPropertyFlavor);
            }
            return flavors.stream();
        }
    }
}

