/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.util.CompositeKey;

public class CompositeKeyAccessorFactory
implements IAccessorFactory<CompositeKey> {
    private final List<IAccessorFactory<?>> keyElementProviders = new ArrayList();

    public <T> IMemberAccessor<CompositeKey, T> getAccessor(IType<T> type) {
        final ArrayList<IMemberAccessor> functions = new ArrayList<IMemberAccessor>(this.keyElementProviders.size());
        for (IAccessorFactory<?> af : this.keyElementProviders) {
            functions.add(af.getAccessor(type));
        }
        return new IMemberAccessor<CompositeKey, T>(){

            public CompositeKey getMember(T item) {
                Object[] result = new Object[functions.size()];
                int i = 0;
                while (i < functions.size()) {
                    result[i] = ((IMemberAccessor)functions.get(i)).getMember(item);
                    ++i;
                }
                return new CompositeKey(result);
            }
        };
    }

    public <T> IMemberAccessor<T, CompositeKey> add(IAccessorFactory<T> keyElementProvider) {
        int keyElementIndex = this.keyElementProviders.size();
        this.keyElementProviders.add(keyElementProvider);
        return key -> key.getKeyElements()[keyElementIndex];
    }

    public static IAccessorFactory<IDisplayable> displayable(final String delimiter, IAccessorFactory<?> ... elements) {
        final CompositeKeyAccessorFactory compositeKeyFactory = new CompositeKeyAccessorFactory();
        IAccessorFactory<?>[] iAccessorFactoryArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAccessorFactory<?> e = iAccessorFactoryArray[n2];
            compositeKeyFactory.add(e);
            ++n2;
        }
        return new IAccessorFactory<IDisplayable>(){

            public <T> IMemberAccessor<? extends IDisplayable, T> getAccessor(IType<T> type) {
                IMemberAccessor accessor = compositeKeyFactory.getAccessor(type);
                return val -> new DisplayableCompositeKey((CompositeKey)accessor.getMember(val), delimiter);
            }
        };
    }

    private static class DisplayableCompositeKey
    implements IDisplayable {
        private final CompositeKey wrapped;
        private final String delimiter;

        DisplayableCompositeKey(CompositeKey wrapped, String delimiter) {
            this.wrapped = wrapped;
            this.delimiter = delimiter;
        }

        public String displayUsing(String formatHint) {
            Function<Object, String> formatter = o -> o instanceof IDisplayable ? ((IDisplayable)o).displayUsing(formatHint) : Objects.toString(o);
            return Stream.of(this.wrapped.getKeyElements()).map(formatter).collect(Collectors.joining(this.delimiter));
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof DisplayableCompositeKey && ((DisplayableCompositeKey)obj).wrapped.equals((Object)this.wrapped);
        }
    }
}

