/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.util.SortedHead;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.ItemIterableToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.ExtraRowTableViewer;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;

public class ItemList {
    private final int maxSize = (int)FlightRecorderUI.getDefault().getItemListSize().longValue();
    private final IItem[] maxSizeArray = new IItem[this.maxSize + 1];
    private final ColumnManager columnManager;
    private final SimpleArray<IItem> tail = new SimpleArray((Object[])new IItem[1000]);
    private ExtraRowTableViewer tableViewer;

    private ItemList(Composite container, List<IColumn> columns, TableSettings tableSettings, int style) {
        this.tableViewer = new ExtraRowTableViewer(container, 0x10010302 | style);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Consumer<ColumnManager.ColumnComparator> onSortChange = comparator -> {
            Object input = this.tableViewer.getInput();
            if (input instanceof IItem[] && comparator != null) {
                Object[] head = (IItem[])input;
                if (this.tail.size() > 0) {
                    Iterator oldTailIterator = this.tail.iterator();
                    this.tail.clear();
                    SortedHead.addSorted((Iterator)oldTailIterator, (Object[])head, this.tail, (Comparator)comparator);
                } else {
                    Arrays.sort(head, comparator);
                }
                this.tableViewer.refresh();
                this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        };
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            FocusTracker.enableFocusTracking((Composite)this.tableViewer.getTable());
        }
        this.columnManager = ColumnManager.build((TableViewer)this.tableViewer, columns, (TableSettings)tableSettings, onSortChange);
    }

    public ColumnManager getManager() {
        return this.columnManager;
    }

    public Supplier<Stream<? extends IItem>> getSelection() {
        List list = ((IStructuredSelection)this.columnManager.getViewer().getSelection()).toList();
        return () -> list.stream();
    }

    public void show(IItemCollection items) {
        this.show(ItemCollectionToolkit.stream(items).flatMap(ItemIterableToolkit::stream).iterator());
    }

    /*
     * Unable to fully structure code
     */
    public void show(Iterator<? extends IItem> it) {
        block6: {
            block5: {
                showEllipsisMessage = false;
                count = 0;
                while (it.hasNext() && count < this.maxSizeArray.length - 1) {
                    this.maxSizeArray[count++] = it.next();
                }
                head = count < this.maxSizeArray.length ? Arrays.copyOf(this.maxSizeArray, count) : this.maxSizeArray;
                columnComparator = this.columnManager.getColumnComparator();
                this.tail.clear();
                if (!it.hasNext()) break block5;
                showEllipsisMessage = true;
                if (columnComparator == null) ** GOTO lbl15
                SortedHead.addSorted(it, (Object[])head, this.tail, (Comparator)columnComparator);
                break block6;
lbl-1000:
                // 1 sources

                {
                    this.tail.add((Object)it.next());
lbl15:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl16:
                // 1 sources

                break block6;
            }
            if (columnComparator != null) {
                Arrays.sort(head, columnComparator);
            }
        }
        if (showEllipsisMessage) {
            this.setEllipsisMessage();
        } else {
            this.clearEllipsisMessage();
        }
        ((TableViewer)this.columnManager.getViewer()).getTable().deselectAll();
        this.columnManager.getViewer().setInput((Object)head);
    }

    private void setEllipsisMessage() {
        this.tableViewer.setExtraMessage(NLS.bind((String)Messages.ITEM_LIST_ELLIPSIS_TEXT, (Object)this.maxSize, (Object)(this.maxSize + this.tail.size())));
    }

    private void clearEllipsisMessage() {
        this.tableViewer.setExtraMessage(null);
    }

    public static String getColumnId(IAttribute<?> a) {
        return String.valueOf(a.getIdentifier()) + ':' + a.getContentType().getIdentifier();
    }

    /* synthetic */ ItemList(Composite composite, List list, TableSettings tableSettings, int n, ItemList itemList) {
        this(composite, list, tableSettings, n);
    }

    public static class ItemListBuilder {
        private final List<IColumn> columns = new ArrayList<IColumn>();

        public void addColumn(IAttribute<?> a) {
            IMemberAccessor accessor = ItemToolkit.accessor(a);
            this.addColumn(a.getIdentifier(), a.getName(), a.getDescription(), a.getContentType() instanceof LinearKindOfQuantity, accessor);
        }

        public void addColumn(String columnId, String name, String description, boolean right, IMemberAccessor<?, IItem> accessor) {
            this.columns.add(new ColumnBuilder(name, columnId, accessor).description(description).style(right ? 131072 : 0).build());
        }

        public ItemList buildWithoutBorder(Composite container, TableSettings tableSettings) {
            return new ItemList(container, this.columns, tableSettings, 0, null);
        }

        public ItemList build(Composite container, TableSettings tableSettings) {
            return new ItemList(container, this.columns, tableSettings, 2048, null);
        }
    }
}

