/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.EventTypeFolderNode;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.LaneEditor;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.ISpanSeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.QuantitySeries;
import org.openjdk.jmc.ui.charts.QuantitySpanRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.SpanRenderer;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;

public class ThreadGraphLanes {
    private static final String EDIT_LANES = "editLanes";
    private static final Color THREAD_BG_COLOR = new Color(Color.HSBtoRGB(Color.RGBtoHSB(200, 255, 200, null)[0], 0.6f, 0.5f));
    private static final String THREAD_LANE = "threadLane";
    private List<LaneEditor.LaneDefinition> laneDefs;
    private List<LaneEditor.LaneDefinition> naLanes;
    private Supplier<StreamModel> dataSourceSupplier;
    private Runnable buildChart;
    private List<IAction> actions;
    private List<String> chartActionIdentifiers = new ArrayList<String>();
    private List<String> legendActionIdentifiers = new ArrayList<String>();

    public ThreadGraphLanes(Supplier<StreamModel> dataSourceSupplier, Runnable buildChart) {
        this.dataSourceSupplier = dataSourceSupplier;
        this.buildChart = buildChart;
        this.actions = new ArrayList<IAction>();
    }

    public void openEditLanesDialog(MCContextMenuManager mm, boolean isLegendMenu) {
        EventTypeFolderNode typeTree = this.dataSourceSupplier.get().getTypeTree(ItemCollectionToolkit.stream(this.dataSourceSupplier.get().getItems()).filter(this::typeWithThreadAndDuration));
        this.laneDefs = LaneEditor.openDialog(typeTree, this.laneDefs.stream().collect(Collectors.toList()), Messages.JavaApplicationPage_EDIT_THREAD_LANES_DIALOG_TITLE, Messages.JavaApplicationPage_EDIT_THREAD_LANES_DIALOG_MESSAGE);
        this.updateContextMenu(mm, isLegendMenu);
        this.buildChart.run();
    }

    public List<LaneEditor.LaneDefinition> getLaneDefinitions() {
        return this.laneDefs;
    }

    private Boolean typeWithThreadAndDuration(IItemIterable itemStream) {
        return DataPageToolkit.isTypeWithThreadAndDuration(itemStream.getType());
    }

    public IItemFilter getEnabledLanesFilter() {
        List<IItemFilter> laneFilters = this.laneDefs.stream().filter(LaneEditor.LaneDefinition::isEnabled).map(ld -> ld.getFilter()).collect(Collectors.toList());
        return ItemFilters.or((IItemFilter[])laneFilters.toArray(new IItemFilter[laneFilters.size()]));
    }

    public IXDataRenderer buildThreadRenderer(Object thread, IItemCollection items) {
        String threadName = thread == null ? "" : ((IMCThread)thread).getThreadName();
        List<Object> laneFilters = this.laneDefs == null ? Collections.emptyList() : this.laneDefs;
        ArrayList lanes = new ArrayList(laneFilters.size());
        laneFilters.stream().filter(ld -> ld.isEnabled()).forEach(lane -> {
            IItemCollection laneItems = items.apply(lane.getFilter());
            if (laneItems.iterator().hasNext()) {
                ISpanSeries laneSeries = QuantitySeries.max((IItemCollection)laneItems, (IAttribute)JfrAttributes.START_TIME, (IAttribute)JfrAttributes.END_TIME);
                lanes.add(new ItemRow(SpanRenderer.withBoundaries((ISpanSeries)laneSeries, DataPageToolkit.ITEM_COLOR), laneItems));
            }
        });
        IXDataRenderer renderer = !lanes.isEmpty() ? RendererToolkit.uniformRows(lanes) : new ItemRow(RendererToolkit.empty(), ItemCollectionToolkit.EMPTY);
        IItemCollection itemsAndThreadLifespan = this.addThreadLifeSpanEvents(thread, items);
        return new QuantitySpanRenderer(this.threadRanges(threadName, itemsAndThreadLifespan), renderer, (Paint)THREAD_BG_COLOR, 10, threadName, null);
    }

    private IItemCollection addThreadLifeSpanEvents(Object thread, IItemCollection items) {
        IItemCollection threadLifeSpan = this.dataSourceSupplier.get().getItems().apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, (Object)((IMCThread)thread)), ItemFilters.type((String[])new String[]{"jdk.ThreadStart", "jdk.ThreadEnd"})}));
        IItemCollection itemsAndThreadLifespan = ItemCollectionToolkit.merge(() -> Stream.of(items, threadLifeSpan));
        return itemsAndThreadLifespan;
    }

    private IQuantitySeries<?> threadRanges(String threadName, IItemCollection items) {
        IQuantity eq;
        IItemCollection startEvents = items.apply(ItemFilters.type((String)"jdk.ThreadStart"));
        IItemCollection endEvents = items.apply(ItemFilters.type((String)"jdk.ThreadEnd"));
        Iterator start = ItemCollectionToolkit.values(startEvents, JfrAttributes.START_TIME).get().sorted().iterator();
        Iterator end = ItemCollectionToolkit.values(endEvents, JfrAttributes.END_TIME).get().sorted().iterator();
        ArrayList<IQuantity> startList = new ArrayList<IQuantity>();
        ArrayList<IQuantity> endList = new ArrayList<IQuantity>();
        IQuantity sq = start.hasNext() ? (IQuantity)start.next() : QuantitySpanRenderer.MISSING_START;
        IQuantity iQuantity = eq = end.hasNext() ? (IQuantity)end.next() : QuantitySpanRenderer.MISSING_END;
        if (sq.compareTo((Object)eq) >= 0) {
            startList.add(QuantitySpanRenderer.MISSING_START);
            endList.add(eq);
            eq = end.hasNext() ? (IQuantity)end.next() : QuantitySpanRenderer.MISSING_END;
        }
        while (start.hasNext()) {
            startList.add(sq);
            endList.add(eq);
            sq = start.hasNext() ? (IQuantity)start.next() : QuantitySpanRenderer.MISSING_START;
            IQuantity iQuantity2 = eq = end.hasNext() ? (IQuantity)end.next() : QuantitySpanRenderer.MISSING_END;
        }
        startList.add(sq);
        endList.add(eq);
        final String text = NLS.bind((String)Messages.JavaApplicationPage_THREAD_LIFESPAN, (Object)threadName);
        return QuantitySeries.all(startList, endList, (Object)new IDisplayable(){

            public String displayUsing(String formatHint) {
                return text;
            }
        });
    }

    public void saveTo(IWritableState writableState) {
        this.laneDefs.stream().forEach(f -> f.saveTo(writableState.createChild(THREAD_LANE)));
        this.naLanes.stream().forEach(f -> f.saveTo(writableState.createChild(THREAD_LANE)));
    }

    public List<IAction> initializeChartConfiguration(Stream<IState> laneStates) {
        this.laneDefs = new ArrayList<LaneEditor.LaneDefinition>();
        laneStates.map(LaneEditor.LaneDefinition::readFrom).forEach(this.laneDefs::add);
        if (this.laneDefs.isEmpty()) {
            this.laneDefs.add(new LaneEditor.LaneDefinition(Messages.JavaApplicationPage_THREAD_LANE_JAVA_LATENCIES, true, JdkFilters.THREAD_LATENCIES, false));
        }
        LaneEditor.ensureRestLane(this.laneDefs);
        Map<Boolean, List<LaneEditor.LaneDefinition>> lanesByApplicability = this.laneDefs.stream().collect(Collectors.partitioningBy(ld -> ld.isRestLane() || this.dataSourceSupplier.get().getItems().apply(ld.getFilter()).iterator().hasNext()));
        this.laneDefs = lanesByApplicability.get(true);
        this.naLanes = lanesByApplicability.get(false);
        return Collections.emptyList();
    }

    public void updateContextMenu(MCContextMenuManager mm, boolean isLegendMenu) {
        if (isLegendMenu) {
            for (String id : this.legendActionIdentifiers) {
                mm.remove(id);
            }
            this.legendActionIdentifiers.clear();
        } else {
            for (String id : this.chartActionIdentifiers) {
                mm.remove(id);
            }
            this.chartActionIdentifiers.clear();
        }
        if (mm.indexOf(EDIT_LANES) == -1) {
            IAction action = ActionToolkit.action(() -> this.openEditLanesDialog(mm, isLegendMenu), (String)Messages.JavaApplicationPage_EDIT_THREAD_LANES_ACTION, (ImageDescriptor)FlightRecorderUI.getDefault().getMCImageDescriptor("lanes_edit.gif"));
            action.setId(EDIT_LANES);
            mm.add(action);
            this.actions.add(action);
            mm.add((IContributionItem)new Separator());
        }
        this.laneDefs.stream().forEach(ld -> {
            Action checkAction = new Action(ld.getName(), 2, (LaneEditor.LaneDefinition)ld){
                int laneIndex;
                private final /* synthetic */ LaneEditor.LaneDefinition val$ld;
                {
                    this.val$ld = laneDefinition;
                    super($anonymous0, $anonymous1);
                    this.laneIndex = ThreadGraphLanes.this.laneDefs.indexOf(laneDefinition);
                }

                public void run() {
                    LaneEditor.LaneDefinition newLd = new LaneEditor.LaneDefinition(this.val$ld.getName(), this.isChecked(), this.val$ld.getFilter(), this.val$ld.isRestLane());
                    ThreadGraphLanes.this.laneDefs.set(this.laneIndex, newLd);
                    ThreadGraphLanes.this.buildChart.run();
                }
            };
            String identifier = String.valueOf(ld.getName()) + checkAction.hashCode();
            checkAction.setId(identifier);
            if (isLegendMenu) {
                this.legendActionIdentifiers.add(identifier);
            } else {
                this.chartActionIdentifiers.add(identifier);
            }
            checkAction.setChecked(ld.isEnabled());
            mm.add((IAction)checkAction);
            this.actions.add((IAction)checkAction);
        });
    }

    public List<IAction> getContextMenuActions() {
        return this.actions;
    }
}

