/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.RangeMatchPolicy;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogramWithInput;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ActionUiToolkit;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class ClassLoadingPage
extends AbstractDataPage {
    private static final IItemFilter TABLE_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkQueries.CLASS_LOAD.getFilter(), JdkQueries.CLASS_UNLOAD.getFilter()});
    private static final ItemHistogram.ItemHistogramBuilder CLASSLOADER_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemList.ItemListBuilder CLASS_LOADING_LIST = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder CLASS_UNLOADING_LIST = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder CLASS_DEFINE_LIST = new ItemList.ItemListBuilder();
    private static final ItemList.ItemListBuilder CLASS_LOADER_STATISTICS_LIST = new ItemList.ItemListBuilder();
    private static final Map<String, Boolean> LEGEND_ITEMS = new LinkedHashMap<String, Boolean>();
    private static final String LOADED_COUNT = "loadedCount";
    private static final String UNLOADED_COUNT = "unloadedCount";
    private static final String CLASS_LOAD = "classLoad";
    private static final String CLASS_UNLOAD = "classUnload";
    private static final String SASH = "sash";
    private static final String HISTOGRAM = "histogram";
    private static final String HISTOGRAM_FILTER = "histogramFilter";
    private static final String CLASS_LOADING_TABLE = "classLoadingTable";
    private static final String CLASS_UNLOADING_TABLE = "classUnloadingTable";
    private static final String CLASS_DEFINE_TABLE = "classDefineTable";
    private static final String CLASS_LOADER_STATISTICS_TABLE = "classLoaderStatisticsTable";
    private static final String CLASS_LOADING_FILTER = "classLoadingFilter";
    private static final String CLASS_UNLOADING_FILTER = "classUnloadingFilter";
    private static final String CLASS_DEFINE_FILTER = "classDefineFilter";
    private static final String CLASS_LOADER_STATISTICS_FILTER = "classLoaderStatisticsFilter";
    private static final String CHART = "chart";
    private ColumnManager.SelectionState histogramSelection;
    private ColumnManager.SelectionState classLoadingTableSelection;
    private ColumnManager.SelectionState classUnloadingTableSelection;
    private ColumnManager.SelectionState classDefineTableSelection;
    private ColumnManager.SelectionState classLoaderStatisticsTableSelection;
    private IItemFilter histogramFilter;
    private IItemFilter classLoadTableFilter;
    private IItemFilter classUnloadTableFilter;
    private IItemFilter classDefineTableFilter;
    private IItemFilter classLoaderStatisticsTableFilter;
    private int tabFolderIndex = 0;
    private IRange<IQuantity> timelineRange;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        CLASSLOADER_HISTOGRAM.addColumn(LOADED_COUNT, Aggregators.count((String)Messages.ClassLoadingPage_AGGR_CLASSES_LOADED_BY_CLASSLOADER, (String)Messages.ClassLoadingPage_AGGR_CLASSES_LOADED_BY_CLASSLOADER_DESC, (IItemFilter)ItemFilters.type((String)"jdk.ClassLoad")));
        CLASSLOADER_HISTOGRAM.addColumn(UNLOADED_COUNT, Aggregators.count((String)Messages.ClassLoadingPage_AGGR_CLASSES_UNLOADED_BY_CLASSLOADER, (String)Messages.ClassLoadingPage_AGGR_CLASSES_UNLOADED_BY_CLASSLOADER_DESC, (IItemFilter)ItemFilters.type((String)"jdk.ClassUnload")));
        CLASS_LOADING_LIST.addColumn(JdkAttributes.CLASS_LOADED);
        CLASS_LOADING_LIST.addColumn(JdkAttributes.CLASS_DEFINING_CLASSLOADER);
        CLASS_LOADING_LIST.addColumn(JdkAttributes.CLASS_INITIATING_CLASSLOADER);
        CLASS_LOADING_LIST.addColumn(JfrAttributes.START_TIME);
        CLASS_LOADING_LIST.addColumn(JfrAttributes.DURATION);
        CLASS_LOADING_LIST.addColumn(JfrAttributes.END_TIME);
        CLASS_LOADING_LIST.addColumn(JfrAttributes.EVENT_THREAD);
        CLASS_UNLOADING_LIST.addColumn(JfrAttributes.EVENT_TIMESTAMP);
        CLASS_UNLOADING_LIST.addColumn(JfrAttributes.EVENT_THREAD);
        CLASS_UNLOADING_LIST.addColumn(JdkAttributes.CLASS_UNLOADED);
        CLASS_UNLOADING_LIST.addColumn(JdkAttributes.CLASS_DEFINING_CLASSLOADER);
        CLASS_DEFINE_LIST.addColumn(JfrAttributes.START_TIME);
        CLASS_DEFINE_LIST.addColumn(JdkAttributes.CLASS_DEFINING_CLASSLOADER);
        CLASS_DEFINE_LIST.addColumn(JdkAttributes.CLASS_DEFINED);
        CLASS_DEFINE_LIST.addColumn(JfrAttributes.EVENT_THREAD);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.ANONYMOUS_BLOCK_SIZE);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.ANONYMOUS_CHUNK_SIZE);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.ANONYMOUS_CLASS_COUNT);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.BLOCK_SIZE);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.CHUNK_SIZE);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.CLASS_COUNT);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.CLASS_LOADER_DATA);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.PARENT_CLASSLOADER);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JdkAttributes.CLASSLOADER);
        CLASS_LOADER_STATISTICS_LIST.addColumn(JfrAttributes.START_TIME);
        LEGEND_ITEMS.put(JdkAttributes.CLASSLOADER_LOADED_COUNT.getIdentifier(), Boolean.TRUE);
        LEGEND_ITEMS.put(JdkAttributes.CLASSLOADER_UNLOADED_COUNT.getIdentifier(), Boolean.FALSE);
        LEGEND_ITEMS.put(CLASS_LOAD, Boolean.TRUE);
        LEGEND_ITEMS.put(CLASS_UNLOAD, Boolean.FALSE);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new ClassLoadingUi(parent, toolkit, pageContainer, state);
    }

    public ClassLoadingPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{TABLE_FILTER, JdkFilters.CLASS_LOAD_STATISTICS});
    }

    public static class ClassLoadingPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ClassLoadingPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/classloading.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"classloading"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ClassLoadingPage(dpd, items, editor);
        }
    }

    private class ClassLoadingUi
    implements IPageUI {
        private final ChartCanvas classLoadingChart;
        private final ItemList classLoadingTable;
        private final ItemList classUnloadingTable;
        private final ItemList classDefineTable;
        private final ItemList classLoaderStatisticsTable;
        private FilterComponent classLoadingFilter;
        private FilterComponent classUnloadingFilter;
        private FilterComponent classDefineFilter;
        private FilterComponent classLoaderStatisticsFilter;
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private IItemCollection selectionItems;
        private ItemHistogram classloaderHistogram;
        private FilterComponent classloaderHistogramFilter;
        private final IAction classLoadAction = DataPageToolkit.createTypeCheckAction("classLoad", "jdk.ClassLoad", Messages.ClassLoadingPage_CLASS_LOADING_ACTION, Messages.ClassLoadingPage_CLASS_LOADING_ACTION_DESC, b -> this.updateChart());
        private final IAction classUnloadAction = DataPageToolkit.createTypeCheckAction("classUnload", "jdk.ClassUnload", Messages.ClassLoadingPage_CLASS_UNLOADING_ACTION, Messages.ClassLoadingPage_CLASS_UNLOADING_ACTION_DESC, b -> this.updateChart());
        private final Stream<IAction> statsActions = Stream.of(JdkAttributes.CLASSLOADER_LOADED_COUNT, JdkAttributes.CLASSLOADER_UNLOADED_COUNT).map(a -> DataPageToolkit.createAttributeCheckAction(a, b -> this.updateChart()));
        private final List<IAction> allChartSeriesActions = Stream.concat(Stream.of(this.classLoadAction, this.classUnloadAction), this.statsActions).collect(Collectors.toList());
        private CTabFolder tabFolder;
        private CTabFolder classloaderFolder;
        private XYChart chart;
        private IRange<IQuantity> timeRange;
        private FlavorSelector flavorSelector;

        ClassLoadingUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, ClassLoadingPage.this.getName(), ClassLoadingPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            Composite chartComp = new Composite((Composite)this.sash, 0);
            chartComp.setLayout((Layout)new GridLayout());
            Control legend = ActionUiToolkit.buildCheckboxControl((Composite)chartComp, this.allChartSeriesActions.stream(), (boolean)false);
            legend.setLayoutData((Object)new GridData(4, 4, true, false));
            ActionToolkit.loadCheckState((IState)state.getChild(ClassLoadingPage.CHART), this.allChartSeriesActions.stream());
            this.chart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 180);
            this.chart.setVisibleRange((IQuantity)ClassLoadingPage.this.timelineRange.getStart(), (IQuantity)ClassLoadingPage.this.timelineRange.getEnd());
            this.chart.addVisibleRangeListener(r -> {
                IRange iRange = r;
                IRange iRange2 = iRange;
                ClassLoadingPage.this.timelineRange = iRange;
            });
            this.classLoadingChart = new ChartCanvas(chartComp);
            this.classLoadingChart.setLayoutData((Object)new GridData(4, 4, true, true));
            DataPageToolkit.createChartTimestampTooltip(this.classLoadingChart);
            DataPageToolkit.setChart(this.classLoadingChart, this.chart, pageContainer::showSelection, this::onChartSelection);
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(pageContainer.getSelectionStore(), this.chart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.ClassLoadingPage_CLASS_LOADING_TIMELINE_SELECTION, (IContributionManager)this.classLoadingChart.getContextMenu());
            this.classloaderFolder = new CTabFolder((Composite)this.sash, 0);
            this.classloaderHistogram = CLASSLOADER_HISTOGRAM.buildWithoutBorder((Composite)this.classloaderFolder, JdkAttributes.CLASS_DEFINING_CLASSLOADER, TableSettings.forState((IState)state.getChild(ClassLoadingPage.HISTOGRAM)));
            this.classloaderHistogramFilter = FilterComponent.createFilterComponent(this.classloaderHistogram, null, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_LOAD_OR_UNLOAD), pageContainer.getSelectionStore()::getSelections, this::onHistogramFilterChange);
            this.classloaderHistogram.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(this.classloaderHistogram.getSelection().getItems()));
            MCContextMenuManager classLoaderHistogramMm = MCContextMenuManager.create((Control)this.classloaderHistogram.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.classloaderHistogram.getManager(), (MCContextMenuManager)classLoaderHistogramMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.classloaderHistogram, Messages.ClassLoadingPage_CLASS_LOADING_HISTOGRAM_SELECTION, (IContributionManager)classLoaderHistogramMm);
            classLoaderHistogramMm.add(this.classloaderHistogramFilter.getShowFilterAction());
            classLoaderHistogramMm.add(this.classloaderHistogramFilter.getShowSearchAction());
            this.classloaderHistogramFilter.loadState(state.getChild(ClassLoadingPage.HISTOGRAM_FILTER));
            DataPageToolkit.addTabItem(this.classloaderFolder, (Control)this.classloaderHistogramFilter.getComponent(), Messages.ClassLoadingPage_CLASS_LOADER_TAB);
            ItemHistogramWithInput.chain(this.classloaderHistogram, this::updateTables, new ItemHistogram[0]);
            this.classLoaderStatisticsTable = CLASS_LOADER_STATISTICS_LIST.buildWithoutBorder((Composite)this.classloaderFolder, TableSettings.forState((IState)state.getChild(ClassLoadingPage.CLASS_LOADER_STATISTICS_TABLE)));
            this.classLoaderStatisticsTable.getManager().getViewer().addSelectionChangedListener(e -> {
                IItemCollection selection = ItemCollectionToolkit.build(this.classLoaderStatisticsTable.getSelection().get());
                Stream stream = ItemCollectionToolkit.values(selection, JdkAttributes.CLASSLOADER).get().distinct();
                Set selected = stream.collect(Collectors.toSet());
                IItemFilter selectionFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.CLASS_LOAD_OR_UNLOAD, JdkFilters.CLASS_DEFINE}), ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.CLASS_DEFINING_CLASSLOADER, selected)});
                IItemCollection filteredItems = ClassLoadingPage.this.getDataSource().getItems().apply(selectionFilter);
                pageContainer.showSelection(filteredItems);
                this.updateTables(filteredItems);
            });
            this.classLoaderStatisticsFilter = FilterComponent.createFilterComponent(this.classLoaderStatisticsTable, null, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_LOADER_STATISTICS), pageContainer.getSelectionStore()::getSelections, this::onClassLoaderStatisticsFilterChange);
            MCContextMenuManager classLoaderStatisticsTableMm = MCContextMenuManager.create((Control)this.classLoaderStatisticsTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.classLoaderStatisticsTable.getManager(), (MCContextMenuManager)classLoaderStatisticsTableMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.classLoaderStatisticsTable, Messages.ClassLoadingPage_CLASS_LOADER_STATISTICS_LIST_SELECTION, (IContributionManager)classLoaderStatisticsTableMm);
            classLoaderStatisticsTableMm.add(this.classLoaderStatisticsFilter.getShowFilterAction());
            classLoaderStatisticsTableMm.add(this.classLoaderStatisticsFilter.getShowSearchAction());
            this.classLoaderStatisticsFilter.loadState(state.getChild(ClassLoadingPage.CLASS_LOADER_STATISTICS_FILTER));
            DataPageToolkit.addTabItem(this.classloaderFolder, (Control)this.classLoaderStatisticsFilter.getComponent(), Messages.ClassLoadingPage_CLASS_LOADER_STATISTICS_TAB_TITLE);
            this.tabFolder = new CTabFolder((Composite)this.sash, 0);
            this.classLoadingTable = CLASS_LOADING_LIST.buildWithoutBorder((Composite)this.tabFolder, TableSettings.forState((IState)state.getChild(ClassLoadingPage.CLASS_LOADING_TABLE)));
            this.classLoadingTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.classLoadingTable.getSelection().get())));
            this.classLoadingFilter = FilterComponent.createFilterComponent(this.classLoadingTable, null, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_LOAD), pageContainer.getSelectionStore()::getSelections, this::onClassLoadFilterChange);
            MCContextMenuManager classLoadingTableMm = MCContextMenuManager.create((Control)this.classLoadingTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.classLoadingTable.getManager(), (MCContextMenuManager)classLoadingTableMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.classLoadingTable, Messages.ClassLoadingPage_CLASS_LOADING_LIST_SELECTION, (IContributionManager)classLoadingTableMm);
            classLoadingTableMm.add(this.classLoadingFilter.getShowFilterAction());
            classLoadingTableMm.add(this.classLoadingFilter.getShowSearchAction());
            this.classLoadingFilter.loadState(state.getChild(ClassLoadingPage.CLASS_LOADING_FILTER));
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.classLoadingFilter.getComponent(), Messages.ClassLoadingPage_CLASS_LOADING_TAB_TITLE);
            this.classDefineTable = CLASS_DEFINE_LIST.buildWithoutBorder((Composite)this.tabFolder, TableSettings.forState((IState)state.getChild(ClassLoadingPage.CLASS_DEFINE_TABLE)));
            this.classDefineTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.classDefineTable.getSelection().get())));
            this.classDefineFilter = FilterComponent.createFilterComponent(this.classDefineTable, null, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_DEFINE), pageContainer.getSelectionStore()::getSelections, this::onClassDefineFilterChange);
            MCContextMenuManager classDefineTableMm = MCContextMenuManager.create((Control)this.classDefineTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.classDefineTable.getManager(), (MCContextMenuManager)classDefineTableMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.classDefineTable, Messages.ClassLoadingPage_CLASS_DEFINE_LIST_SELECTION, (IContributionManager)classDefineTableMm);
            classDefineTableMm.add(this.classDefineFilter.getShowFilterAction());
            classDefineTableMm.add(this.classDefineFilter.getShowSearchAction());
            this.classDefineFilter.loadState(state.getChild(ClassLoadingPage.CLASS_DEFINE_FILTER));
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.classDefineFilter.getComponent(), Messages.ClassLoadingPage_CLASS_DEFINE_TAB_TITLE);
            this.classUnloadingTable = CLASS_UNLOADING_LIST.buildWithoutBorder((Composite)this.tabFolder, TableSettings.forState((IState)state.getChild(ClassLoadingPage.CLASS_UNLOADING_TABLE)));
            this.classUnloadingTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.classUnloadingTable.getSelection().get())));
            this.classUnloadingFilter = FilterComponent.createFilterComponent(this.classUnloadingTable, null, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_UNLOAD), pageContainer.getSelectionStore()::getSelections, this::onClassUnloadFilterChange);
            MCContextMenuManager classUnloadingTableMm = MCContextMenuManager.create((Control)this.classUnloadingTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.classUnloadingTable.getManager(), (MCContextMenuManager)classUnloadingTableMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.classUnloadingTable, Messages.ClassLoadingPage_CLASS_UNLOADING_LIST_SELECTION, (IContributionManager)classUnloadingTableMm);
            classUnloadingTableMm.add(this.classUnloadingFilter.getShowFilterAction());
            classUnloadingTableMm.add(this.classUnloadingFilter.getShowSearchAction());
            this.classUnloadingFilter.loadState(state.getChild(ClassLoadingPage.CLASS_UNLOADING_FILTER));
            DataPageToolkit.addTabItem(this.tabFolder, (Control)this.classUnloadingFilter.getComponent(), Messages.ClassLoadingPage_CLASS_UNLOADING_TAB_TITLE);
            this.tabFolder.setSelection(ClassLoadingPage.this.tabFolderIndex);
            this.classloaderFolder.setSelection(ClassLoadingPage.this.tabFolderIndex);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(ClassLoadingPage.SASH));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_FILTER, ClassLoadingPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, ClassLoadingPage.this.flavorSelectorState);
            ClassLoadingPage.this.addResultActions(form);
            this.onHistogramFilterChange(ClassLoadingPage.this.histogramFilter);
            this.onClassLoadFilterChange(ClassLoadingPage.this.classLoadTableFilter);
            this.onClassUnloadFilterChange(ClassLoadingPage.this.classUnloadTableFilter);
            this.onClassDefineFilterChange(ClassLoadingPage.this.classDefineTableFilter);
            this.onClassLoaderStatisticsFilterChange(ClassLoadingPage.this.classLoaderStatisticsTableFilter);
            this.classloaderHistogram.getManager().setSelectionState(ClassLoadingPage.this.histogramSelection);
            this.classLoadingTable.getManager().setSelectionState(ClassLoadingPage.this.classLoadingTableSelection);
            this.classUnloadingTable.getManager().setSelectionState(ClassLoadingPage.this.classUnloadingTableSelection);
            this.classDefineTable.getManager().setSelectionState(ClassLoadingPage.this.classDefineTableSelection);
            this.classLoaderStatisticsTable.getManager().setSelectionState(ClassLoadingPage.this.classLoaderStatisticsTableSelection);
        }

        private void onHistogramFilterChange(IItemFilter filter) {
            this.classloaderHistogramFilter.filterChangeHelper(filter, this.classloaderHistogram, ClassLoadingPage.this.getDataSource().getItems().apply(ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.CLASS_LOAD_OR_UNLOAD, JdkFilters.CLASS_DEFINE})));
            if (this.classLoadingFilter != null) {
                this.classLoadingFilter.notifyListener();
            }
            if (this.classUnloadingFilter != null) {
                this.classUnloadingFilter.notifyListener();
            }
            if (this.classDefineFilter != null) {
                this.classDefineFilter.notifyListener();
            }
            if (this.classLoaderStatisticsFilter != null) {
                this.classLoaderStatisticsFilter.notifyListener();
            }
            ClassLoadingPage.this.histogramFilter = filter;
        }

        private void onClassLoadFilterChange(IItemFilter filter) {
            this.classLoadingFilter.filterChangeHelper(filter, this.classLoadingTable, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_LOAD));
            ClassLoadingPage.this.classLoadTableFilter = filter;
        }

        private void onClassUnloadFilterChange(IItemFilter filter) {
            this.classUnloadingFilter.filterChangeHelper(filter, this.classUnloadingTable, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_UNLOAD));
            ClassLoadingPage.this.classUnloadTableFilter = filter;
        }

        private void onClassDefineFilterChange(IItemFilter filter) {
            this.classDefineFilter.filterChangeHelper(filter, this.classDefineTable, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_DEFINE));
            ClassLoadingPage.this.classDefineTableFilter = filter;
        }

        private void onClassLoaderStatisticsFilterChange(IItemFilter filter) {
            this.classLoaderStatisticsFilter.filterChangeHelper(filter, this.classLoaderStatisticsTable, ClassLoadingPage.this.getDataSource().getItems().apply(JdkFilters.CLASS_LOADER_STATISTICS));
            ClassLoadingPage.this.classLoaderStatisticsTableFilter = filter;
        }

        public void saveTo(IWritableState state) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)state.createChild(ClassLoadingPage.SASH));
            this.classloaderHistogram.getManager().getSettings().saveState(state.createChild(ClassLoadingPage.HISTOGRAM));
            this.classLoadingTable.getManager().getSettings().saveState(state.createChild(ClassLoadingPage.CLASS_LOADING_TABLE));
            this.classUnloadingTable.getManager().getSettings().saveState(state.createChild(ClassLoadingPage.CLASS_UNLOADING_TABLE));
            this.classDefineTable.getManager().getSettings().saveState(state.createChild(ClassLoadingPage.CLASS_DEFINE_TABLE));
            this.classLoaderStatisticsTable.getManager().getSettings().saveState(state.createChild(ClassLoadingPage.CLASS_LOADER_STATISTICS_TABLE));
            this.classloaderHistogramFilter.saveState(state.createChild(ClassLoadingPage.HISTOGRAM_FILTER));
            this.classLoadingFilter.saveState(state.createChild(ClassLoadingPage.CLASS_LOADING_FILTER));
            this.classUnloadingFilter.saveState(state.createChild(ClassLoadingPage.CLASS_UNLOADING_FILTER));
            this.classDefineFilter.saveState(state.createChild(ClassLoadingPage.CLASS_DEFINE_FILTER));
            this.classLoaderStatisticsFilter.saveState(state.createChild(ClassLoadingPage.CLASS_LOADER_STATISTICS_FILTER));
            ActionToolkit.saveCheckState((IWritableState)state.createChild(ClassLoadingPage.CHART), this.allChartSeriesActions.stream());
            this.saveToLocal();
        }

        private void saveToLocal() {
            ClassLoadingPage.this.histogramSelection = this.classloaderHistogram.getManager().getSelectionState();
            ClassLoadingPage.this.classLoadingTableSelection = this.classLoadingTable.getManager().getSelectionState();
            ClassLoadingPage.this.classUnloadingTableSelection = this.classUnloadingTable.getManager().getSelectionState();
            ClassLoadingPage.this.classDefineTableSelection = this.classDefineTable.getManager().getSelectionState();
            ClassLoadingPage.this.classLoaderStatisticsTableSelection = this.classLoaderStatisticsTable.getManager().getSelectionState();
            ClassLoadingPage.this.tabFolderIndex = this.tabFolder.getSelectionIndex();
            ClassLoadingPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.timeRange : this.pageContainer.getRecordingRange();
            this.chart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.updateChart();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items;
            this.timeRange = timeRange;
            this.updateHistogram(this.getItems());
            this.updateTables(this.getItems());
            this.updateChart();
        }

        private IItemCollection getItems() {
            return this.selectionItems != null ? this.selectionItems : ClassLoadingPage.this.getDataSource().getItems();
        }

        private void updateChart() {
            ArrayList<ItemRow> rows = new ArrayList<ItemRow>();
            DataPageToolkit.buildLinesRow(Messages.ClassLoadingPage_ROW_CLASS_LOADING_STATISTICS, JdkAttributes.CLASSLOADER_LOADED_COUNT.getDescription(), ClassLoadingPage.this.getDataSource().getItems(), false, JdkQueries.CLASS_LOAD_STATISTICS, this::isAttributeEnabled, (IQuantity)UnitLookup.NUMBER_UNITY.quantity(0L), null).ifPresent(rows::add);
            if (this.classLoadAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(Messages.ClassLoadingPage_ROW_CLASSES_LOADED, Messages.ClassLoadingPage_AGGR_CLASSES_LOADED_BY_CLASSLOADER_DESC, this.getItems().apply(JdkFilters.CLASS_LOAD), Aggregators.count((String)Messages.ClassLoadingPage_AGGR_CLASSES_LOADED, (String)Messages.ClassLoadingPage_AGGR_CLASSES_LOADED_DESC, (IItemFilter)JdkFilters.CLASS_LOAD), TypeLabelProvider.getColor("jdk.ClassLoad")));
            }
            if (this.classUnloadAction.isChecked()) {
                rows.add(DataPageToolkit.buildTimestampHistogram(Messages.ClassLoadingPage_ROW_CLASSES_UNLOADED, Messages.ClassLoadingPage_AGGR_CLASSES_UNLOADED_DESC, this.getItems().apply(JdkFilters.CLASS_UNLOAD), Aggregators.count((String)Messages.ClassLoadingPage_AGGR_CLASSES_UNLOADED, (String)Messages.ClassLoadingPage_AGGR_CLASSES_UNLOADED_DESC, (IItemFilter)JdkFilters.CLASS_UNLOAD), TypeLabelProvider.getColor("jdk.ClassUnload")));
            }
            this.classLoadingChart.replaceRenderer(RendererToolkit.uniformRows(rows));
        }

        private boolean isAttributeEnabled(IAttribute<IQuantity> attr) {
            return this.allChartSeriesActions.stream().filter(a -> attr.getIdentifier().equals(a.getId())).findAny().get().isChecked();
        }

        private void updateHistogram(IItemCollection items) {
            if (this.classloaderHistogram != null) {
                this.classloaderHistogram.show(items.apply(JdkFilters.CLASS_LOAD_OR_UNLOAD));
            }
        }

        private void updateTables(IItemCollection selectedItems) {
            if (this.classLoadingTable != null && this.classUnloadingTable != null && this.classDefineTable != null && this.classLoaderStatisticsTable != null) {
                this.classLoadingTable.show(selectedItems.apply(JdkQueries.CLASS_LOAD.getFilter()));
                this.classUnloadingTable.show(selectedItems.apply(JdkQueries.CLASS_UNLOAD.getFilter()));
                this.classDefineTable.show(selectedItems.apply(JdkQueries.CLASS_DEFINE.getFilter()));
            }
        }

        private void onChartSelection(IRange<IQuantity> range) {
            IItemCollection itemsInRange = range != null ? this.getItems().apply(ItemFilters.matchRange((RangeMatchPolicy)RangeMatchPolicy.CENTER_CONTAINED_IN_RIGHT_OPEN, (ICanonicalAccessorFactory)JfrAttributes.LIFETIME, range)) : this.getItems();
            this.updateTables(itemsInRange);
            this.updateHistogram(itemsInRange);
        }
    }
}

