/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.EventTypeFolderNode;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.PageManager;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.TypeFilterBuilder;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.ItemHandlerPage;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.OrientationAction;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class EventBrowserPage
extends AbstractDataPage {
    private static final ImageDescriptor NEW_PAGE_ICON = FlightRecorderUI.getDefault().getMCImageDescriptor("new_page.png");
    private ColumnManager.SelectionState tableSelection;
    private ISelection treeSelection;
    public TreePath[] treeExpansion;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new EventBrowserUI(parent, toolkit, state, editor);
    }

    public EventBrowserPage(IPageDefinition definition, StreamModel items, IPageContainer editor) {
        super(definition, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.all();
    }

    class EventBrowserUI
    implements IPageUI {
        private static final String TREE_SASH = "treeSash";
        private static final String ITEM_LIST = "itemList";
        private static final String SHOW_TYPES_WITHOUT_EVENTS = "showTypesWithoutEvents";
        private ItemList list;
        private final SashForm treeSash;
        private final IPageContainer container;
        private final List<TableSettings.ColumnSettings> listColumns = new ArrayList<TableSettings.ColumnSettings>();
        private String listOrderBy;
        private Set<IType<?>> selectedTypes = Collections.emptySet();
        private final TypeFilterBuilder typeFilterTree;
        private IItemCollection selectionItems;
        private FlavorSelector flavorSelector;
        private Boolean showTypesWithoutEvents;

        EventBrowserUI(Composite parent, FormToolkit toolkit, IState state, IPageContainer container) {
            this.container = container;
            Form form = DataPageToolkit.createForm(parent, toolkit, EventBrowserPage.this.getName(), EventBrowserPage.this.getIcon());
            this.treeSash = new SashForm(form.getBody(), 256);
            toolkit.adapt((Composite)this.treeSash);
            this.typeFilterTree = DataPageToolkit.buildEventTypeTree((Composite)this.treeSash, toolkit, this::onTypeChange, false);
            MCContextMenuManager mm = this.typeFilterTree.getMenuManager();
            IAction addPageAction = ActionToolkit.action(this::addPage, (String)Messages.EventBrowserPage_NEW_PAGE_USING_TYPES_ACTION, (ImageDescriptor)NEW_PAGE_ICON);
            mm.appendToGroup("group.new", addPageAction);
            IAction typesWithoutEventsAction = ActionToolkit.checkAction(this::setTypesWithoutEvents, (String)Messages.EventBrowserPage_DISPLAY_TYPES_WITHOUT_EVENTS, null);
            this.showTypesWithoutEvents = StateToolkit.readBoolean((IState)state, (String)SHOW_TYPES_WITHOUT_EVENTS, (Boolean)true);
            typesWithoutEventsAction.setChecked(this.showTypesWithoutEvents.booleanValue());
            mm.appendToGroup("group.open", typesWithoutEventsAction);
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.typeFilterTree.getViewer(), () -> this.selectedTypes, container.getSelectionStore(), Messages.EventBrowserPage_EVENT_TYPE_TREE_SELECTION, (IContributionManager)mm);
            Composite listParent = toolkit.createComposite((Composite)this.treeSash);
            listParent.setLayout((Layout)new FillLayout());
            PersistableSashForm.loadState((SashForm)this.treeSash, (IState)state.getChild(TREE_SASH));
            form.getToolBarManager().add(addPageAction);
            form.getToolBarManager().add((IContributionItem)new Separator());
            OrientationAction.installActions((Form)form, (SashForm)this.treeSash);
            IState itemListState = state.getChild(ITEM_LIST);
            if (itemListState != null) {
                TableSettings settings = new TableSettings(itemListState);
                this.listColumns.addAll(settings.getColumns());
                this.listOrderBy = settings.getOrderBy();
            }
            this.list = new ItemList.ItemListBuilder().build(listParent, null);
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, null, EventBrowserPage.this.getDataSource().getItems(), container, this::onInputSelected, EventBrowserPage.this.flavorSelectorState);
            EventBrowserPage.this.addResultActions(form);
            if (EventBrowserPage.this.treeExpansion != null) {
                this.typeFilterTree.getViewer().setExpandedTreePaths(EventBrowserPage.this.treeExpansion);
            } else {
                this.typeFilterTree.getViewer().expandAll();
            }
            this.typeFilterTree.getViewer().setSelection(EventBrowserPage.this.treeSelection);
            this.list.getManager().setSelectionState(EventBrowserPage.this.tableSelection);
        }

        private void addPage() {
            PageManager pm = FlightRecorderUI.getDefault().getPageManager();
            pm.makeRoot(pm.createPage(ItemHandlerPage.Factory.class, new ItemHandlerPage.ItemHandlerUiStandIn(this.selectedTypes)));
        }

        private void setTypesWithoutEvents(boolean checked) {
            this.showTypesWithoutEvents = checked;
            this.refreshTree();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items == null ? EventBrowserPage.this.getDataSource().getItems() : items;
            this.refreshTree();
        }

        private void refreshTree() {
            boolean noTypesWereSelected = this.selectedTypes.isEmpty();
            this.typeFilterTree.getViewer().getControl().setRedraw(false);
            TreePath[] expansion = this.typeFilterTree.getViewer().getExpandedTreePaths();
            ISelection selection = this.typeFilterTree.getViewer().getSelection();
            this.typeFilterTree.setInput(EventBrowserPage.this.getDataSource().getTypeTree(ItemCollectionToolkit.stream(this.selectionItems).filter(ii -> this.showTypesWithoutEvents != false || ii.hasItems())));
            this.typeFilterTree.getViewer().setExpandedTreePaths(expansion);
            this.typeFilterTree.getViewer().setSelection(selection);
            this.typeFilterTree.getViewer().getControl().setRedraw(true);
            this.typeFilterTree.getViewer().getControl().redraw();
            if (noTypesWereSelected) {
                this.rebuildItemList();
            }
        }

        private IItemCollection getFilteredItems() {
            if (!this.selectedTypes.isEmpty()) {
                Set types = this.selectedTypes.stream().map(t -> t.getIdentifier()).collect(Collectors.toSet());
                return this.selectionItems.apply(ItemFilters.type(types));
            }
            return this.selectionItems;
        }

        private void onTypeChange() {
            Set<IType<?>> oldSelectedTypes = this.selectedTypes;
            this.selectedTypes = this.typeFilterTree.getSelectedTypes().map(EventTypeFolderNode.EventTypeNode::getType).collect(Collectors.toSet());
            if (!Objects.equals(this.selectedTypes, oldSelectedTypes)) {
                this.container.showSelection(this.getFilteredItems());
                this.rebuildItemList();
            }
        }

        private void rebuildItemList() {
            this.mergeListSettings();
            Iterator<Object> types = this.selectedTypes.iterator();
            IItemCollection filteredItems = this.getFilteredItems();
            if (this.selectedTypes.isEmpty()) {
                types = ItemCollectionToolkit.stream(this.selectionItems).map(is -> is.getType()).distinct().iterator();
            }
            Stream<Object> commonAttributes = Stream.empty();
            if (types.hasNext()) {
                List attributes = types.next().getAttributes();
                if (types.hasNext()) {
                    while (types.hasNext()) {
                        attributes = ((IType)types.next()).getAttributes().stream().filter(attributes::contains).collect(Collectors.toList());
                    }
                    commonAttributes = attributes.stream();
                } else {
                    commonAttributes = attributes.stream().filter(a -> !a.equals(JfrAttributes.EVENT_TYPE));
                }
                commonAttributes = commonAttributes.filter(a -> !a.equals(JfrAttributes.EVENT_STACKTRACE));
            }
            String orderBy = this.listOrderBy;
            Set existingColumnIds = this.listColumns.stream().map(TableSettings.ColumnSettings::getId).collect(Collectors.toSet());
            ArrayList newColumns = new ArrayList();
            ItemList.ItemListBuilder itemListBuilder = new ItemList.ItemListBuilder();
            commonAttributes.forEach(a -> {
                String combinedId = ItemList.getColumnId(a);
                ContentType contentType = a.getContentType();
                IMemberAccessor accessor = ItemToolkit.accessor((IAttribute)a);
                itemListBuilder.addColumn(combinedId, a.getName(), String.valueOf(NLS.bind((String)Messages.ATTRIBUTE_ID_LABEL, (Object)a.getIdentifier())) + System.getProperty("line.separator") + NLS.bind((String)Messages.ATTRIBUTE_DESCRIPTION_LABEL, (Object)a.getDescription()), contentType instanceof LinearKindOfQuantity, accessor);
                if (combinedId.equals(this.listOrderBy)) {
                    this.listOrderBy = null;
                }
                if (!existingColumnIds.contains(combinedId)) {
                    newColumns.add(0, new TableSettings.ColumnSettings(combinedId, Boolean.valueOf(false), null, null));
                }
            });
            this.listColumns.addAll(0, newColumns);
            Control oldListControl = this.list.getManager().getViewer().getControl();
            Composite parent = oldListControl.getParent();
            oldListControl.dispose();
            this.list = DataPageToolkit.createSimpleItemList(parent, itemListBuilder, this.container, DataPageToolkit.createTableSettingsByOrderByAndColumnsWithDefaultOrdering(orderBy, this.listColumns), Messages.EventBrowserPage_EVENT_BROWSER_SELECTION);
            parent.layout();
            this.list.show(filteredItems);
        }

        private void mergeListSettings() {
            TableSettings settings = this.list.getManager().getSettings();
            Set columns = settings.getColumns().stream().map(TableSettings.ColumnSettings::getId).collect(Collectors.toSet());
            ArrayList<Integer> replaceIndexs = new ArrayList<Integer>(columns.size());
            int i = 0;
            while (i < this.listColumns.size()) {
                if (columns.contains(this.listColumns.get(i).getId())) {
                    replaceIndexs.add(i);
                }
                ++i;
            }
            Iterator replacements = settings.getColumns().iterator();
            Iterator indexs = replaceIndexs.iterator();
            while (indexs.hasNext() && replacements.hasNext()) {
                this.listColumns.set((Integer)indexs.next(), (TableSettings.ColumnSettings)replacements.next());
            }
            if (settings.getOrderBy() != null) {
                this.listOrderBy = settings.getOrderBy();
            }
        }

        public void saveTo(IWritableState state) {
            PersistableSashForm.saveState((SashForm)this.treeSash, (IWritableState)state.createChild(TREE_SASH));
            this.mergeListSettings();
            new TableSettings(this.listOrderBy, this.listColumns).saveState(state.createChild(ITEM_LIST));
            StateToolkit.writeBoolean((IWritableState)state, (String)SHOW_TYPES_WITHOUT_EVENTS, (Boolean)this.showTypesWithoutEvents);
            this.saveToLocal();
        }

        private void saveToLocal() {
            EventBrowserPage.this.treeSelection = this.typeFilterTree.getViewer().getSelection();
            EventBrowserPage.this.treeExpansion = this.typeFilterTree.getViewer().getExpandedTreePaths();
            EventBrowserPage.this.tableSelection = this.list.getManager().getSelectionState();
            EventBrowserPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }
    }

    public static class Factory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.EventBrowserPage_PAGE_NAME;
        }

        @Override
        public String getDescription(IState state) {
            return Messages.EventBrowserPage_PAGE_DESC;
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{""};
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("event-selector-16.png");
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new EventBrowserPage(dpd, items, editor);
        }
    }
}

