/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;
import org.openjdk.jmc.ui.misc.CompositeToolkit;

public class GCConfigurationPage
extends AbstractDataPage {
    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        Form form = DataPageToolkit.createForm(parent, toolkit, this.getName(), this.getIcon());
        SashForm container = new SashForm(form.getBody(), 256);
        container.setSashWidth(5);
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        Section gcConfigSection = CompositeToolkit.createSection((Composite)container, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_GC_CONFIG);
        ItemAggregateViewer gcConfig = new ItemAggregateViewer((Composite)gcConfigSection, toolkit);
        gcConfig.addAggregate(JdkAggregators.YOUNG_COLLECTOR);
        gcConfig.addAggregate(JdkAggregators.OLD_COLLECTOR);
        gcConfig.addAggregate(JdkAggregators.CONCURRENT_GC_THREAD_COUNT_MIN);
        gcConfig.addAggregate(JdkAggregators.PARALLEL_GC_THREAD_COUNT_MIN);
        gcConfig.addAggregate(JdkAggregators.EXPLICIT_GC_CONCURRENT);
        gcConfig.addAggregate(JdkAggregators.EXPLICIT_GC_DISABLED);
        gcConfig.addAggregate(JdkAggregators.USE_DYNAMIC_GC_THREADS);
        gcConfig.addAggregate(JdkAggregators.GC_TIME_RATIO_MIN);
        gcConfigSection.setClient(gcConfig.getControl());
        Section heapConfigSection = CompositeToolkit.createSection((Composite)container, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_HEAP_CONFIG);
        ItemAggregateViewer heapConfig = new ItemAggregateViewer((Composite)heapConfigSection, toolkit);
        heapConfig.addAggregate(JdkAggregators.HEAP_CONF_INITIAL_SIZE_MIN);
        heapConfig.addAggregate(JdkAggregators.HEAP_CONF_MIN_SIZE);
        heapConfig.addAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
        heapConfig.addAggregate(JdkAggregators.USE_COMPRESSED_OOPS);
        heapConfig.addAggregate(JdkAggregators.COMPRESSED_OOPS_MODE);
        heapConfig.addAggregate(JdkAggregators.HEAP_ADDRESS_SIZE_MIN);
        heapConfig.addAggregate(JdkAggregators.HEAP_OBJECT_ALIGNMENT_MIN);
        heapConfigSection.setClient(heapConfig.getControl());
        Section ycConfigSection = CompositeToolkit.createSection((Composite)container, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_YOUNG_CONFIG);
        ItemAggregateViewer ycConfig = new ItemAggregateViewer((Composite)ycConfigSection, toolkit);
        ycConfig.addAggregate(JdkAggregators.YOUNG_GENERATION_MIN_SIZE);
        ycConfig.addAggregate(JdkAggregators.YOUNG_GENERATION_MAX_SIZE);
        ycConfig.addAggregate(JdkAggregators.NEW_RATIO_MIN);
        ycConfig.addAggregate(JdkAggregators.TENURING_THRESHOLD_INITIAL_MIN);
        ycConfig.addAggregate(JdkAggregators.TENURING_THRESHOLD_MAX);
        ycConfig.addAggregate(JdkAggregators.USES_TLABS);
        ycConfig.addAggregate(JdkAggregators.TLAB_MIN_SIZE);
        ycConfig.addAggregate(JdkAggregators.TLAB_REFILL_WASTE_LIMIT_MIN);
        ycConfigSection.setClient(ycConfig.getControl());
        gcConfig.setValues(this.getDataSource().getItems());
        heapConfig.setValues(this.getDataSource().getItems());
        ycConfig.setValues(this.getDataSource().getItems());
        this.addResultActions(form);
        return null;
    }

    public GCConfigurationPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.GC_CONFIG;
    }

    public static class GCConfigurationPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.GCConfigurationPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/gcconfig.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"gc_configuration"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new GCConfigurationPage(dpd, items, editor);
        }
    }
}

