/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages.itemhandler;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.AttributeComponentConfiguration;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.AttributeMenuFactory;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.HistogramSettingsTree;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.TriConsumer;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStore;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;

class HistogramSequence {
    private static final ImageDescriptor IMAGE_DESCRIPTOR_GROUP_BY = FlightRecorderUI.getDefault().getMCImageDescriptor("group_by.png");
    private static final ImageDescriptor IMAGE_DESCRIPTOR_GROUP_BY_COMBINE = FlightRecorderUI.getDefault().getMCImageDescriptor("group_by_combine.png");
    private final Composite container;
    private final ItemHistogram.ItemHistogramBuilder histogramBuilder;
    private final TablePart topPart;
    private final Consumer<Boolean> groupingListener;
    private final Control pairControl;
    private final Consumer<IItemCollection> itemListener;
    private final SelectionStore selectionStore;
    private String pageName;

    public HistogramSequence(Control pairControl, List<IContributionManager> pairMenuManagers, List<TriConsumer<String, ImageDescriptor, IMenuListener>> pairMenuConsumers, String pageName, HistogramSettingsTree settings, ItemHistogram.ItemHistogramBuilder histogramBuilder, Consumer<IItemCollection> itemListener, Consumer<Boolean> groupingListener, AttributeComponentConfiguration acc, SelectionStore selectionStore) {
        this.pageName = pageName;
        this.itemListener = itemListener;
        this.pairControl = pairControl;
        this.selectionStore = selectionStore;
        this.container = pairControl.getParent();
        this.histogramBuilder = histogramBuilder;
        this.groupingListener = groupingListener;
        pairMenuManagers.forEach(cm -> {
            cm.remove(Messages.TABLECOMPONENT_GROUP_BY);
            cm.add((IContributionItem)AttributeMenuFactory.attributeMenu(false, this::addHistogram, () -> acc.getCommonAttributes().values().stream(), Messages.TABLECOMPONENT_GROUP_BY, IMAGE_DESCRIPTOR_GROUP_BY));
        });
        pairMenuConsumers.forEach(mc -> mc.accept(Messages.TABLECOMPONENT_GROUP_BY, IMAGE_DESCRIPTOR_GROUP_BY, AttributeMenuFactory.attributeMenuListener(false, this::addHistogram, () -> acc.getCommonAttributes().values().stream())));
        this.topPart = new TablePart(settings, acc);
        this.onGroup();
    }

    public HistogramSettingsTree getHistogramSettings() {
        this.topPart.storeSettings();
        return this.topPart.settings;
    }

    public LinkedList<ColumnManager.SelectionState> getSelectionStates() {
        LinkedList<ColumnManager.SelectionState> list = new LinkedList<ColumnManager.SelectionState>();
        this.topPart.storeSelectionState(list);
        return list;
    }

    public void setSelectionStates(LinkedList<ColumnManager.SelectionState> list) {
        this.topPart.setSelectionStates(list);
    }

    public void setItems(IItemCollection items) {
        this.topPart.setItems(items);
    }

    public void addHistogram(IAttribute<?> groupByAttribute, Boolean ignore) {
        this.topPart.storeSettings();
        this.topPart.addHistogram(groupByAttribute, ((TablePart)this.topPart).settings.tableSettings);
        this.onGroup();
    }

    private void onGroup() {
        this.groupingListener.accept(this.isGrouped());
    }

    private TablePart getLowestHistogram() {
        TablePart tp = this.topPart;
        while (tp.child != null && tp.child.histogram != null) {
            tp = tp.child;
        }
        return tp;
    }

    public ItemHistogram.HistogramSelection getSelection() {
        TablePart tp = this.getLowestHistogram();
        if (tp.histogram != null) {
            ItemHistogram.HistogramSelection selection = tp.histogram.getSelection();
            return selection != null && selection.getRowCount() > 0 ? selection : null;
        }
        return null;
    }

    public ItemHistogram.HistogramSelection getAllRows() {
        TablePart tp = this.getLowestHistogram();
        if (tp.histogram != null) {
            return tp.histogram.getAllRows();
        }
        return null;
    }

    public boolean isGrouped() {
        return this.topPart != null && this.topPart.histogram != null;
    }

    private static IAccessorFactory<String> accessorFactory(final IAttribute<?>[] attributes, final String delimiter) {
        return new IAccessorFactory<String>(){

            public <T> IMemberAccessor<String, T> getAccessor(IType<T> type) {
                final ArrayList<IMemberAccessor> accessors = new ArrayList<IMemberAccessor>();
                IAttribute[] iAttributeArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    IAttribute attribute = iAttributeArray[n2];
                    accessors.add(attribute.getAccessor(type));
                    ++n2;
                }
                return new IMemberAccessor<String, T>(){

                    public String getMember(T inObject) {
                        ArrayList<String> members = new ArrayList<String>();
                        for (IMemberAccessor accessor : accessors) {
                            members.add(TypeHandling.getValueString((Object)accessor.getMember(inObject)));
                        }
                        return StringToolkit.join(members, (String)delimiter);
                    }
                };
            }
        };
    }

    private class TablePart {
        private static final String GROUPED_ATTRIBUTE_DELIMITER = " / ";
        private static final String GROUPED_ATTRIBUTE_DELIMITER_PERSISTENCE = "GROUPED_ATTRIBUTE_DELIMITER_PERSISTENCE";
        private final HistogramSettingsTree settings;
        private ItemHistogram histogram;
        private TablePart child;
        private IItemCollection items;
        private final List<IAttribute<?>> groupAttributes;
        AttributeComponentConfiguration acc;

        private TablePart(HistogramSettingsTree settings, AttributeComponentConfiguration acc) {
            this.settings = settings;
            this.acc = acc;
            this.groupAttributes = new ArrayList();
            if (settings.groupBy != null) {
                acc.getCommonAttributes().values().stream().filter(a -> Stream.of(histogramSettingsTree.groupBy.split(GROUPED_ATTRIBUTE_DELIMITER_PERSISTENCE)).anyMatch(g -> g.equals(a.getIdentifier()))).forEach(a -> this.groupAttributes.add(0, (IAttribute<?>)a));
                if (this.groupAttributes.size() > 0) {
                    this.buildHistogram();
                }
            }
        }

        private void buildHistogram() {
            assert (this.child == null && this.histogram == null);
            if (this.groupAttributes.size() == 0) {
                return;
            }
            if (this.groupAttributes.size() == 1) {
                IAttribute<?> attribute = this.groupAttributes.get(0);
                this.settings.groupBy = attribute.getIdentifier();
                this.histogram = HistogramSequence.this.histogramBuilder.build(HistogramSequence.this.container, attribute, this.settings.tableSettings);
            } else {
                this.settings.groupBy = this.groupAttributes.stream().map(a -> a.getIdentifier()).collect(Collectors.joining(GROUPED_ATTRIBUTE_DELIMITER_PERSISTENCE));
                String columnTitle = this.groupAttributes.stream().map(a -> a.getName()).collect(Collectors.joining(GROUPED_ATTRIBUTE_DELIMITER));
                this.histogram = HistogramSequence.this.histogramBuilder.build(HistogramSequence.this.container, columnTitle, UnitLookup.PLAIN_TEXT, HistogramSequence.accessorFactory(this.groupAttributes.toArray(new IAttribute[this.groupAttributes.size()]), GROUPED_ATTRIBUTE_DELIMITER), this.settings.tableSettings);
            }
            ColumnViewer viewer = this.histogram.getManager().getViewer();
            viewer.getControl().moveAbove(HistogramSequence.this.pairControl);
            MCContextMenuManager mm = MCContextMenuManager.create((Control)viewer.getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.histogram.getManager(), (MCContextMenuManager)mm);
            mm.add((IContributionItem)AttributeMenuFactory.attributeMenu(true, this::setGroupByField, () -> this.acc.getCommonAttributes().values().stream(), Messages.TABLECOMPONENT_GROUP_BY, IMAGE_DESCRIPTOR_GROUP_BY));
            mm.add((IContributionItem)AttributeMenuFactory.attributeMenu(false, this::combinedGrouping, () -> this.acc.getCommonAttributes().values().stream(), Messages.TABLECOMPONENT_COMBINE_GROUP_BY, IMAGE_DESCRIPTOR_GROUP_BY_COMBINE));
            SelectionStoreActionToolkit.addSelectionStoreActions(HistogramSequence.this.selectionStore, this.histogram, NLS.bind((String)Messages.TABLECOMPONENT_HISTOGRAM_SELECTION, (Object)HistogramSequence.this.pageName), (IContributionManager)mm);
            viewer.addSelectionChangedListener(this::selectionChanged);
            this.child = new TablePart(this.settings.getSelectedChild(), this.acc);
        }

        private void setGroupByField(IAttribute<?> attribute, Boolean ignore) {
            if (attribute != null && attribute.getIdentifier().equals(this.settings.groupBy)) {
                return;
            }
            this.storeSettings();
            this.dispose();
            this.settings.groupBy = null;
            this.groupAttributes.clear();
            if (attribute != null) {
                this.groupAttributes.add(attribute);
                try {
                    this.buildHistogram();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.refreshViewer();
            HistogramSequence.this.onGroup();
        }

        private void combinedGrouping(IAttribute<?> attribute, Boolean ignore) {
            if (attribute == null || this.groupAttributes.contains(attribute)) {
                return;
            }
            this.storeSettings();
            this.dispose();
            this.groupAttributes.add(attribute);
            try {
                this.buildHistogram();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.refreshViewer();
            HistogramSequence.this.onGroup();
        }

        private void setItems(IItemCollection items) {
            this.items = items;
            this.refreshViewer();
        }

        private void selectionChanged(Object ignored) {
            this.child.setItems(this.getHistogramSelection());
            HistogramSequence.this.itemListener.accept(this.getHistogramSelection());
        }

        private IItemCollection getHistogramSelection() {
            ItemHistogram.HistogramSelection selection = this.histogram.getSelection();
            return selection.getRowCount() == 0 ? this.items : selection.getItems();
        }

        private void refreshViewer() {
            if (this.histogram != null) {
                this.histogram.show(this.items);
                this.child.setItems(this.getHistogramSelection());
            } else {
                HistogramSequence.this.itemListener.accept(this.items);
            }
            HistogramSequence.this.container.layout();
        }

        private void dispose() {
            if (this.histogram != null) {
                this.child.dispose();
                this.histogram.getManager().getViewer().getControl().dispose();
                this.histogram = null;
                this.child = null;
            }
        }

        private void storeSettings() {
            if (this.histogram != null) {
                this.settings.tableSettings = this.histogram.getManager().getSettings();
                this.child.storeSettings();
            }
        }

        private void storeSelectionState(LinkedList<ColumnManager.SelectionState> list) {
            if (this.histogram != null) {
                list.addLast(this.histogram.getManager().getSelectionState());
                this.child.storeSelectionState(list);
            }
        }

        private void setSelectionStates(LinkedList<ColumnManager.SelectionState> list) {
            if (this.histogram != null && list != null) {
                this.histogram.getManager().setSelectionState(list.poll());
                this.child.setSelectionStates(list);
            }
        }

        private void addHistogram(IAttribute<?> attribute, TableSettings parentSettings) {
            if (this.child == null) {
                if (this.settings.tableSettings == null) {
                    this.settings.tableSettings = parentSettings;
                }
                this.groupAttributes.add(attribute);
                this.buildHistogram();
                this.refreshViewer();
            } else {
                this.child.addHistogram(attribute, this.settings.tableSettings);
            }
            HistogramSequence.this.container.layout();
        }
    }
}

