/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.preferences;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.ui.AttributeConfiguration;
import org.openjdk.jmc.flightrecorder.ui.BasicConfig;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.RulesUiToolkit;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.xml.sax.SAXException;

public class RulesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String STATE = "state";
    public static final String RULE_ID = "id";
    public static final String IGNORED_RULES = "ignoredRules";
    private Tree topicTree;
    private Font topicFont;
    private BasicConfig config;
    private Set<String> ignoredRules;

    public RulesPage() {
        this.setPreferenceStore(FlightRecorderUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFERENCES_ENABLED_RULES);
        String configStateString = this.getPreferenceStore().getString("ruleConfiguration");
        IState configState = null;
        try {
            configState = configStateString.length() != 0 ? StateToolkit.fromXMLString((String)configStateString) : null;
            this.ignoredRules = RulesPage.loadIgnoredRules(this.getPreferenceStore());
        }
        catch (SAXException saxe) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Error reading configuration XML", saxe);
        }
        this.config = new BasicConfig(configState);
    }

    public void init(IWorkbench workbench) {
        FontData[] fontData = Display.getCurrent().getSystemFont().getFontData();
        FontData fd = new FontData(fontData[0].toString());
        fd.setStyle(2);
        this.topicFont = new Font((Device)Display.getCurrent(), fd);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.topicTree = new Tree(composite, 2082);
        this.topicTree.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button configure = new Button(composite, 8);
        configure.setText(Messages.PREFERENCES_RULES_CONFIGURE_SELECTED);
        configure.setEnabled(false);
        this.topicTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem item = (TreeItem)e.item;
                    TreeItem parentItem = item.getParentItem();
                    if (parentItem != null) {
                        Supplier<Stream> siblingItemSupplier = () -> Stream.of(parentItem.getItems());
                        boolean anyChecked = siblingItemSupplier.get().anyMatch(TreeItem::getChecked);
                        boolean allChecked = siblingItemSupplier.get().allMatch(TreeItem::getChecked);
                        if (!allChecked) {
                            parentItem.setGrayed(anyChecked);
                        } else {
                            parentItem.setGrayed(false);
                        }
                        item.getParentItem().setChecked(anyChecked);
                    } else {
                        if (item.getGrayed()) {
                            item.setGrayed(false);
                        }
                        Stream.of(item.getItems()).forEach(i -> i.setChecked(item.getChecked()));
                    }
                } else if (e.detail == 0) {
                    configure.setEnabled(RulesPage.this.getSelectedRules().stream().anyMatch(r -> r.getConfigurationAttributes().size() > 0));
                }
            }
        });
        Collection<String> topics = RulesUiToolkit.getTopics();
        for (String topic : topics) {
            Collection<IRule> rules = RulesUiToolkit.getRules(topic);
            TreeItem topicItem = new TreeItem(this.topicTree, 0);
            topicItem.setText(topic);
            topicItem.setFont(this.topicFont);
            int checkedRules = 0;
            for (IRule rule : rules) {
                TreeItem ruleItem = new TreeItem(topicItem, 0);
                ruleItem.setText(rule.getName());
                if (!this.ignoredRules.contains(rule.getId())) {
                    ruleItem.setChecked(true);
                    ++checkedRules;
                }
                ruleItem.setData(RULE_ID, (Object)rule.getId());
            }
            boolean anyChecked = checkedRules > 0 && checkedRules < rules.size();
            topicItem.setGrayed(anyChecked);
            topicItem.setChecked(checkedRules == rules.size() || anyChecked);
        }
        configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List filteredRules = RulesPage.this.getSelectedRules();
                AttributeConfiguration pageConfiguration = new AttributeConfiguration(filteredRules);
                IAction createOpenConfigAction = RulesPage.this.config.createOpenConfigAction(pageConfiguration, r -> RulesPage.this.getPreferenceStore().setValue("ruleConfiguration", StateToolkit.toXMLString((IStateful)RulesPage.this.config)));
                createOpenConfigAction.run();
            }
        });
        composite.addDisposeListener(e -> this.topicFont.dispose());
        return composite;
    }

    private List<IRule> getSelectedRules() {
        Stream<String> selectedTopics = Stream.of(this.topicTree.getSelection()).filter(ti -> ti.getParentItem() == null).map(ti -> ti.getText());
        Stream<String> selectedRuleTopics = Stream.of(this.topicTree.getSelection()).filter(ti -> ti.getParentItem() != null).map(ti -> ti.getParentItem().getText());
        String[] topics = (String[])Stream.concat(selectedRuleTopics, selectedTopics).distinct().toArray(String[]::new);
        Collection<IRule> rules = RulesUiToolkit.getRules(topics);
        List<IRule> filteredRules = rules.stream().filter(rule -> Stream.of(this.topicTree.getSelection()).anyMatch(selected -> {
            if (selected.getParentItem() == null) {
                return true;
            }
            return selected.getData(RULE_ID).equals(rule.getId());
        })).collect(Collectors.toList());
        return filteredRules;
    }

    protected void performApply() {
        Set<String> checkedRuleIDs = this.streamTopicTreeItems().filter(ti -> !ti.getChecked()).map(ti -> ti.getData(RULE_ID).toString()).collect(Collectors.toSet());
        try {
            IWritableState ignoredState = StateToolkit.createWriter((String)STATE);
            checkedRuleIDs.forEach(id -> ignoredState.createChild(IGNORED_RULES).putString(RULE_ID, id));
            this.getPreferenceStore().setValue(IGNORED_RULES, ignoredState.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.streamTopicTreeItems().forEach(ti -> {
            ti.setChecked(true);
            ti.getParentItem().setGrayed(false);
            ti.getParentItem().setChecked(true);
        });
    }

    private Stream<TreeItem> streamTopicTreeItems() {
        return Stream.of(this.topicTree.getItems()).flatMap(i -> Stream.of(i.getItems()));
    }

    public static Set<String> loadIgnoredRules(IPreferenceStore preferenceStore) {
        String ignoredStateString = preferenceStore.getString(IGNORED_RULES);
        try {
            IState ignoredState;
            IState iState = ignoredState = ignoredStateString.length() != 0 ? StateToolkit.fromXMLString((String)ignoredStateString) : null;
            if (ignoredState != null) {
                return Stream.of(ignoredState.getChildren(IGNORED_RULES)).map(iS -> iS.getAttribute(RULE_ID)).collect(Collectors.toCollection(HashSet::new));
            }
        }
        catch (SAXException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not read ignored rules from preferences.", e);
        }
        return Collections.emptySet();
    }
}

