/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.jfr.internal;

import java.io.IOException;
import java.text.MessageFormat;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.ConnectionToolkit;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.IRecordingDescriptor;
import org.openjdk.jmc.rjmx.services.jfr.internal.IFlightRecorderCommunicationHelper;

final class FlightRecorderCommunicationHelperV2
implements IFlightRecorderCommunicationHelper {
    private final MBeanServerConnection server;
    private final ObjectName jfr2MBeanObjectName;
    private static final String JFR2_MBEAN_OBJECT_NAME_OLD = "jdk.jfr.management:type=FlightRecorder";
    private static final String JFR2_MBEAN_OBJECT_NAME = "jdk.management.jfr:type=FlightRecorder";

    public FlightRecorderCommunicationHelperV2(MBeanServerConnection server) throws ServiceNotAvailableException {
        this.server = server;
        this.jfr2MBeanObjectName = FlightRecorderCommunicationHelperV2.getJfrMBeanObjectName(server);
    }

    @Override
    public Object getAttribute(String attribute) throws FlightRecorderException {
        try {
            return this.getJfrAttribute(attribute);
        }
        catch (IOException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + attribute + '!', e);
        }
        catch (JMException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + attribute + '!', e);
        }
    }

    private Object getJfrAttribute(String attribute) throws JMException, IOException {
        return this.server.getAttribute(this.jfr2MBeanObjectName, attribute);
    }

    @Override
    public Object invokeOperation(String name, Object ... parameters) throws IOException, FlightRecorderException {
        try {
            return this.invokeJfrOperation(name, parameters);
        }
        catch (JMException e) {
            IOException throwMe = new IOException(e.getMessage());
            throwMe.initCause(e);
            throw throwMe;
        }
    }

    private Object invokeJfrOperation(String operation, Object ... parameters) throws JMException, IOException {
        return ConnectionToolkit.invokeOperation((MBeanServerConnection)this.server, (ObjectName)this.jfr2MBeanObjectName, (String)operation, (Object[])parameters);
    }

    @Override
    public void closeRecording(IRecordingDescriptor descriptor) throws FlightRecorderException {
        try {
            this.invokeOperation("closeRecording", descriptor.getId());
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not close the recording!", e);
        }
    }

    public static boolean isAvailable(IConnectionHandle handle) {
        try {
            MBeanServerConnection connection = (MBeanServerConnection)handle.getServiceOrThrow(MBeanServerConnection.class);
            FlightRecorderCommunicationHelperV2.getJfrMBeanObjectName(connection);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static ObjectName getJfrMBeanObjectName(MBeanServerConnection server) throws ServiceNotAvailableException {
        try {
            ObjectName candidate2ObjectName = ConnectionToolkit.createObjectName((String)JFR2_MBEAN_OBJECT_NAME);
            server.getMBeanInfo(candidate2ObjectName);
            return candidate2ObjectName;
        }
        catch (Exception exception) {
            try {
                ObjectName candidate1ObjectName = ConnectionToolkit.createObjectName((String)JFR2_MBEAN_OBJECT_NAME_OLD);
                server.getMBeanInfo(candidate1ObjectName);
                return candidate1ObjectName;
            }
            catch (Exception exception2) {
                throw new ServiceNotAvailableException(MessageFormat.format("FlightRecorder MXBean not available, tried {0} and {1}", JFR2_MBEAN_OBJECT_NAME, JFR2_MBEAN_OBJECT_NAME_OLD));
            }
        }
    }
}

