/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.services.jfr.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.configuration.ConfigurationToolkit;
import org.openjdk.jmc.flightrecorder.configuration.OptionInfo;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.configuration.internal.DefaultValueMap;
import org.openjdk.jmc.flightrecorder.configuration.internal.EventTypeIDV2;
import org.openjdk.jmc.flightrecorder.configuration.internal.IMapper;
import org.openjdk.jmc.flightrecorder.configuration.internal.KnownEventOptions;
import org.openjdk.jmc.flightrecorder.configuration.internal.KnownRecordingOptions;
import org.openjdk.jmc.flightrecorder.configuration.internal.ValidationToolkit;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.ConnectionToolkit;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.JVMSupportToolkit;
import org.openjdk.jmc.rjmx.ServiceNotAvailableException;
import org.openjdk.jmc.rjmx.services.ICommercialFeaturesService;
import org.openjdk.jmc.rjmx.services.jfr.FlightRecorderException;
import org.openjdk.jmc.rjmx.services.jfr.IFlightRecorderService;
import org.openjdk.jmc.rjmx.services.jfr.IRecordingDescriptor;
import org.openjdk.jmc.rjmx.services.jfr.internal.EventTypeMetadataV2;
import org.openjdk.jmc.rjmx.services.jfr.internal.ExcludingEventOptionMapper;
import org.openjdk.jmc.rjmx.services.jfr.internal.FlightRecorderCommunicationHelperV2;
import org.openjdk.jmc.rjmx.services.jfr.internal.JfrRecordingInputStreamV2;
import org.openjdk.jmc.rjmx.services.jfr.internal.Messages;
import org.openjdk.jmc.rjmx.services.jfr.internal.RecordingDescriptorV2;
import org.openjdk.jmc.rjmx.services.jfr.internal.RecordingOptionsToolkitV2;
import org.openjdk.jmc.rjmx.services.jfr.internal.RecordingTemplateToolkit;
import org.openjdk.jmc.rjmx.subscription.IMBeanHelperService;

public class FlightRecorderServiceV2
implements IFlightRecorderService {
    static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.services.jfr");
    private final FlightRecorderCommunicationHelperV2 helper;
    private long eventTypeMetaNextUpdate;
    private List<EventTypeMetadataV2> eventTypeMetas;
    private Map<EventTypeIDV2, EventTypeMetadataV2> eventTypeInfoById;
    private Map<EventOptionID, OptionInfo<?>> optionInfoById;
    private boolean wasEnabled;
    private final ICommercialFeaturesService cfs;
    private final IMBeanHelperService mbhs;
    private final String serverId;
    private final IConnectionHandle connection;

    public String getVersion() {
        return "2.0";
    }

    private boolean isDynamicFlightRecorderSupported(IConnectionHandle handle) {
        return ConnectionToolkit.isHotSpot((IConnectionHandle)handle) && ConnectionToolkit.isJavaVersionAboveOrEqual((IConnectionHandle)handle, (JavaVersion)JavaVersionSupport.DYNAMIC_JFR_SUPPORTED);
    }

    private boolean isFlightRecorderCommercial() {
        return ConnectionToolkit.isHotSpot((IConnectionHandle)this.connection) && !ConnectionToolkit.isJavaVersionAboveOrEqual((IConnectionHandle)this.connection, (JavaVersion)JavaVersionSupport.JFR_NOT_COMMERCIAL);
    }

    private boolean isFlightRecorderDisabled(IConnectionHandle handle) {
        if (this.cfs != null && this.isFlightRecorderCommercial()) {
            return !this.cfs.isCommercialFeaturesEnabled() || JVMSupportToolkit.isFlightRecorderDisabled((IConnectionHandle)handle, (boolean)false);
        }
        return JVMSupportToolkit.isFlightRecorderDisabled((IConnectionHandle)handle, (boolean)false);
    }

    public static boolean isAvailable(IConnectionHandle handle) {
        return FlightRecorderCommunicationHelperV2.isAvailable(handle);
    }

    public FlightRecorderServiceV2(IConnectionHandle handle) throws ConnectionException, ServiceNotAvailableException {
        this.cfs = (ICommercialFeaturesService)handle.getServiceOrThrow(ICommercialFeaturesService.class);
        if (!this.isDynamicFlightRecorderSupported(handle) && this.isFlightRecorderDisabled(handle)) {
            throw new ServiceNotAvailableException("");
        }
        if (JVMSupportToolkit.isFlightRecorderDisabled((IConnectionHandle)handle, (boolean)true)) {
            throw new ServiceNotAvailableException("");
        }
        this.connection = handle;
        this.helper = new FlightRecorderCommunicationHelperV2((MBeanServerConnection)handle.getServiceOrThrow(MBeanServerConnection.class));
        this.mbhs = (IMBeanHelperService)handle.getServiceOrThrow(IMBeanHelperService.class);
        this.serverId = handle.getServerDescriptor().getGUID();
    }

    @Override
    public void stop(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.stop(descriptor.getId());
    }

    private void stop(Long id) throws FlightRecorderException {
        try {
            this.helper.invokeOperation("stopRecording", id);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not stop the recording!", e);
        }
    }

    @Override
    public void close(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.helper.closeRecording(descriptor);
    }

    @Override
    public IRecordingDescriptor start(IConstrainedMap<String> recordingOptions, IConstrainedMap<EventOptionID> eventOptions) throws FlightRecorderException {
        Long id;
        try {
            this.validateOptions(recordingOptions);
            id = (Long)this.helper.invokeOperation("newRecording", new Object[0]);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not create a recording!", e);
        }
        try {
            this.updateRecordingOptions(id, recordingOptions);
            if (eventOptions != null) {
                this.updateEventOptions(id, eventOptions);
            }
            this.helper.invokeOperation("startRecording", id);
            return this.getUpdatedRecordingDescriptor(id);
        }
        catch (Exception e) {
            try {
                this.helper.invokeOperation("closeRecording", id);
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
                throw new FlightRecorderException("Could not start the recording! Could not remove the unstarted recording.", e);
            }
            throw new FlightRecorderException("Could not start the recording! Removed the unstarted recording.", e);
        }
    }

    private IMutableConstrainedMap<String> getEmptyRecordingOptions() {
        return ConfigurationToolkit.getRecordingOptions((JavaVersion)JavaVersionSupport.JDK_9).emptyWithSameConstraints();
    }

    public IDescribedMap<String> getDefaultRecordingOptions() {
        return KnownRecordingOptions.OPTION_DEFAULTS_V2;
    }

    @Override
    public IConstrainedMap<String> getRecordingOptions(IRecordingDescriptor recording) throws FlightRecorderException {
        try {
            return this.getRecordingOptions(recording.getId());
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not retrieve recording options.", e);
        }
    }

    private IConstrainedMap<String> getRecordingOptions(Long id) throws FlightRecorderException, IOException {
        IMutableConstrainedMap<String> options = this.getEmptyRecordingOptions();
        for (Object o : ((TabularData)this.helper.invokeOperation("getRecordingOptions", id)).values()) {
            CompositeData row = (CompositeData)o;
            String key = (String)row.get("key");
            String value = (String)row.get("value");
            IConstraint<?> constraint = RecordingOptionsToolkitV2.getRecordingOptionConstraint(key);
            if (constraint == null) continue;
            try {
                options.putPersistedString((Object)key, constraint, value);
            }
            catch (QuantityConversionException e) {
                LOGGER.log(Level.FINE, "Recording option conversion problem", e);
            }
        }
        return options;
    }

    @Override
    public IConstrainedMap<EventOptionID> getEventSettings(IRecordingDescriptor recording) throws FlightRecorderException {
        try {
            TabularData tabularData = (TabularData)this.helper.invokeOperation("getRecordingSettings", recording.getId());
            IMutableConstrainedMap settings = this.getDefaultEventOptions().emptyWithSameConstraints();
            for (Object row : tabularData.values()) {
                CompositeData data = (CompositeData)row;
                String key = (String)data.get("key");
                String value = (String)data.get("value");
                int hashPos = key.lastIndexOf(35);
                if (hashPos <= 0) continue;
                EventTypeIDV2 type = new EventTypeIDV2(key.substring(0, hashPos));
                EventOptionID option = new EventOptionID((IEventTypeID)type, key.substring(hashPos + 1));
                settings.putPersistedString((Object)option, value);
            }
            return settings;
        }
        catch (Exception e) {
            FlightRecorderException flr = new FlightRecorderException("Could not retrieve recording options for recording " + recording.getName() + '.');
            flr.initCause(e);
            throw flr;
        }
    }

    @Override
    public Map<String, IOptionDescriptor<?>> getAvailableRecordingOptions() throws FlightRecorderException {
        return RecordingOptionsToolkitV2.getAvailableRecordingOptions();
    }

    public String toString() {
        return this.helper.toString();
    }

    @Override
    public InputStream openStream(IRecordingDescriptor descriptor, boolean removeOnClose) throws FlightRecorderException {
        IRecordingDescriptor streamDescriptor = descriptor;
        boolean clone = this.isStillRunning(descriptor);
        if (clone) {
            streamDescriptor = this.clone(descriptor);
        }
        return new JfrRecordingInputStreamV2(this.helper, streamDescriptor, clone | removeOnClose);
    }

    @Override
    public InputStream openStream(IRecordingDescriptor descriptor, IQuantity startTime, IQuantity endTime, boolean removeOnClose) throws FlightRecorderException {
        IRecordingDescriptor streamDescriptor = descriptor;
        boolean clone = this.isStillRunning(descriptor);
        if (clone) {
            streamDescriptor = this.clone(descriptor);
        }
        return new JfrRecordingInputStreamV2(this.helper, streamDescriptor, UnitLookup.toDate((IQuantity)startTime), UnitLookup.toDate((IQuantity)endTime), clone | removeOnClose);
    }

    public Collection<EventTypeMetadataV2> getAvailableEventTypes() throws FlightRecorderException {
        return this.updateEventTypeMetadataMaps(true);
    }

    @Override
    public List<IRecordingDescriptor> getAvailableRecordings() throws FlightRecorderException {
        CompositeData[] attribute = (CompositeData[])this.helper.getAttribute("Recordings");
        ArrayList<RecordingDescriptorV2> recordings = new ArrayList<RecordingDescriptorV2>();
        CompositeData[] compositeDataArray = attribute;
        int n = attribute.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeData data = compositeDataArray[n2];
            recordings.add(new RecordingDescriptorV2(this.serverId, data));
            ++n2;
        }
        return Collections.unmodifiableList(recordings);
    }

    @Override
    public IRecordingDescriptor getSnapshotRecording() throws FlightRecorderException {
        try {
            Long id = (Long)this.helper.invokeOperation("takeSnapshot", new Object[0]);
            return this.getUpdatedRecordingDescriptor(id);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not take a snapshot of the flight recorder", e);
        }
    }

    public IDescribedMap<EventOptionID> getCurrentEventTypeSettings() throws FlightRecorderException {
        this.updateEventTypeMetadataMaps(true);
        return new DefaultValueMap(this.optionInfoById, (IMapper)new ExcludingEventOptionMapper(this.eventTypeInfoById.keySet(), EventTypeIDV2.class, KnownEventOptions.EVENT_OPTIONS_BY_KEY_V2));
    }

    public IDescribedMap<EventOptionID> getDefaultEventOptions() {
        try {
            return this.getCurrentEventTypeSettings();
        }
        catch (FlightRecorderException e) {
            LOGGER.log(Level.WARNING, "Couldn't get event settings", e);
            return ConfigurationToolkit.getEventOptions((SchemaVersion)SchemaVersion.V2);
        }
    }

    @Override
    public IRecordingDescriptor getUpdatedRecordingDescription(IRecordingDescriptor descriptor) throws FlightRecorderException {
        return this.getUpdatedRecordingDescriptor(descriptor.getId());
    }

    @Override
    public List<String> getServerTemplates() throws FlightRecorderException {
        CompositeData[] compositeData = (CompositeData[])this.helper.getAttribute("Configurations");
        return RecordingTemplateToolkit.getServerTemplatesV2(compositeData);
    }

    @Override
    public void updateEventOptions(IRecordingDescriptor descriptor, IConstrainedMap<EventOptionID> options) throws FlightRecorderException {
        try {
            this.updateEventOptions(descriptor.getId(), options);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed updating the event options for " + descriptor.getName(), e);
        }
    }

    private IRecordingDescriptor getUpdatedRecordingDescriptor(Long id) throws FlightRecorderException {
        for (IRecordingDescriptor recording : this.getAvailableRecordings()) {
            if (!id.equals(recording.getId())) continue;
            return recording;
        }
        return null;
    }

    private void validateOptions(IConstrainedMap<String> recordingOptions) throws FlightRecorderException {
        try {
            ValidationToolkit.validate(recordingOptions);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not validate options!\n" + e.getMessage());
        }
    }

    public Map<EventTypeIDV2, EventTypeMetadataV2> getEventTypeInfoMapByID() throws FlightRecorderException {
        this.updateEventTypeMetadataMaps(false);
        return this.eventTypeInfoById;
    }

    private Collection<EventTypeMetadataV2> updateEventTypeMetadataMaps(boolean force) throws FlightRecorderException {
        long timestamp = System.currentTimeMillis();
        if (force || timestamp > this.eventTypeMetaNextUpdate) {
            CompositeData[] compositeList = (CompositeData[])this.helper.getAttribute("EventTypes");
            ArrayList<EventTypeMetadataV2> metadataList = new ArrayList<EventTypeMetadataV2>(compositeList.length);
            HashMap<EventTypeIDV2, EventTypeMetadataV2> byId = new HashMap<EventTypeIDV2, EventTypeMetadataV2>();
            HashMap optionById = new HashMap();
            CompositeData[] compositeDataArray = compositeList;
            int n = compositeList.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeData data = compositeDataArray[n2];
                EventTypeMetadataV2 typeInfo = EventTypeMetadataV2.from(data);
                metadataList.add(typeInfo);
                EventTypeIDV2 typeID = typeInfo.getEventTypeID();
                byId.put(typeID, typeInfo);
                for (Map.Entry<String, OptionInfo<?>> entry : typeInfo.getOptionDescriptors().entrySet()) {
                    optionById.put(new EventOptionID((IEventTypeID)typeID, entry.getKey()), entry.getValue());
                }
                ++n2;
            }
            this.eventTypeMetaNextUpdate = timestamp + 60000L;
            this.eventTypeMetas = Collections.unmodifiableList(metadataList);
            this.eventTypeInfoById = Collections.unmodifiableMap(byId);
            this.optionInfoById = Collections.unmodifiableMap(optionById);
        }
        return this.eventTypeMetas;
    }

    private boolean isStillRunning(IRecordingDescriptor descriptor) throws FlightRecorderException {
        IRecordingDescriptor updatedDescriptor = this.getUpdatedRecordingDescription(descriptor);
        return updatedDescriptor != null && IRecordingDescriptor.RecordingState.RUNNING.equals((Object)updatedDescriptor.getState());
    }

    private IRecordingDescriptor clone(IRecordingDescriptor descriptor) throws FlightRecorderException {
        try {
            Long id = (Long)this.helper.invokeOperation("cloneRecording", descriptor.getId(), Boolean.TRUE);
            IMutableConstrainedMap<String> options = this.getEmptyRecordingOptions();
            options.put((Object)"name", (Object)NLS.bind((String)Messages.FlightRecorderServiceV2_CLONE_OF_RECORDING_NAME, (Object)descriptor.getName()));
            this.helper.invokeOperation("setRecordingOptions", id, RecordingOptionsToolkitV2.toTabularData(options));
            return this.getUpdatedRecordingDescriptor(id);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not clone the " + descriptor.getName() + " recording ", e);
        }
    }

    private void updateEventOptions(Long id, IConstrainedMap<EventOptionID> options) throws OpenDataException, IOException, FlightRecorderException {
        this.helper.invokeOperation("setRecordingSettings", id, RecordingOptionsToolkitV2.toTabularData(options));
    }

    @Override
    public void updateRecordingOptions(IRecordingDescriptor descriptor, IConstrainedMap<String> options) throws FlightRecorderException {
        this.validateOptions(options);
        IConstrainedMap<String> current = this.getRecordingOptions(descriptor);
        IConstrainedMap deltaOptions = ConfigurationToolkit.extractDelta(options, current);
        try {
            this.updateRecordingOptions(descriptor.getId(), (IConstrainedMap<String>)deltaOptions);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed updating the recording options for " + descriptor.getName(), e);
        }
    }

    private void updateRecordingOptions(Long id, IConstrainedMap<String> options) throws OpenDataException, IOException, FlightRecorderException {
        this.helper.invokeOperation("setRecordingOptions", id, RecordingOptionsToolkitV2.toTabularData(options));
    }

    @Override
    public InputStream openStream(IRecordingDescriptor descriptor, IQuantity lastPartDuration, boolean removeOnClose) throws FlightRecorderException {
        long serverTime = this.mbhs.getApproximateServerTime(System.currentTimeMillis());
        ITypedQuantity endDate = UnitLookup.EPOCH_MS.quantity(serverTime);
        IQuantity startDate = endDate.subtract(lastPartDuration);
        return this.openStream(descriptor, startDate, (IQuantity)endDate, removeOnClose);
    }

    @Override
    public boolean isEnabled() {
        if (!this.wasEnabled) {
            boolean isEnabled;
            boolean bl = isEnabled = this.isFlightRecorderCommercial() ? this.cfs.isCommercialFeaturesEnabled() : FlightRecorderServiceV2.isAvailable(this.connection);
            if (isEnabled) {
                this.wasEnabled = true;
            }
            return isEnabled;
        }
        return this.wasEnabled;
    }

    @Override
    public void enable() throws FlightRecorderException {
        try {
            this.cfs.enableCommercialFeatures();
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed to enable commercial features", e);
        }
    }
}

