/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.cpu;

import java.text.MessageFormat;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanLimit;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class CompareCpuRule
extends AbstractRule {
    public static final TypedPreference<IQuantity> OTHER_CPU_WARNING_LIMIT = new TypedPreference("other.cpu.warning.limit", Messages.getString("CompareCpuRule_WARNING_LIMIT"), Messages.getString("CompareCpuRule_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(40L));
    public static final TypedPreference<IQuantity> OTHER_CPU_INFO_LIMIT = new TypedPreference("other.cpu.info.limit", Messages.getString("CompareCpuRule_INFO_LIMIT"), Messages.getString("CompareCpuRule_INFO_LIMIT_LONG"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(20L));

    public CompareCpuRule() {
        super("CompareCpu", Messages.getString("CompareCpuRule_RULE_NAME"), "processes", new TypedPreference[]{OTHER_CPU_INFO_LIMIT, OTHER_CPU_WARNING_LIMIT});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.CPULoad"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.CPULoad"});
        }
        double warningLimit = ((IQuantity)vp.getPreferenceValue(OTHER_CPU_WARNING_LIMIT)).doubleValue() / 100.0;
        double infoLimit = ((IQuantity)vp.getPreferenceValue(OTHER_CPU_INFO_LIMIT)).doubleValue() / 100.0;
        IItemCollection cpuItems = items.apply(JdkFilters.CPU_LOAD);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_TOTAL)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_TOTAL);
        }
        SpanLimit max = SpanToolkit.getMaxSpanLimit(cpuItems, (IAttribute<IQuantity>)JdkAttributes.OTHER_CPU, (IAttribute<IQuantity>)JfrAttributes.END_TIME, warningLimit);
        if (max == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("CompareCpuRule_TEXT_TOO_FEW_SAMPLES"));
        }
        double score = RulesToolkit.mapExp100((double)max.value, (double)infoLimit, (double)warningLimit);
        String startTime = KindOfQuantity.format((Number)max.start, (IUnit)UnitLookup.EPOCH_NS);
        String duration = KindOfQuantity.format((Number)(max.end - max.start), (IUnit)UnitLookup.NANOSECOND);
        String otherCpuMaxValueString = UnitLookup.PERCENT.quantity(Math.round(max.value * 100.0)).displayUsing("auto");
        String message = MessageFormat.format(Messages.getString("CompareCpuRule_TEXT_MESSAGE"), duration, startTime, otherCpuMaxValueString);
        String longMessage = null;
        if (score >= 25.0) {
            longMessage = message + "<p>" + Messages.getString("CompareCpuRule_TEXT_INFO_LONG");
        }
        return new Result((IRule)this, score, message, longMessage, null);
    }
}

