/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.exceptions;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FatalErrorRule
implements IRule {
    private static final String RESULT_ID = "Fatal Errors";
    private static final String ERROR_REASON = "VM Error";
    private static final String INFO_REASON = "No remaining non-daemon Java threads";
    private FutureTask<Result> evaluationTask;

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        this.evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return FatalErrorRule.this.getResult(items, valueProvider);
            }
        });
        return this.evaluationTask;
    }

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.Shutdown"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.Shutdown"});
        }
        IItemFilter shutdownFilter = ItemFilters.type((String)"jdk.Shutdown");
        IItemCollection shutdownItems = items.apply(shutdownFilter);
        if (shutdownItems.hasItems()) {
            if (shutdownItems.apply(ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.SHUTDOWN_REASON, (String)ERROR_REASON)).hasItems()) {
                String message = Messages.getString("FatalErrorRule_TEXT_WARN");
                return new Result((IRule)this, 100.0, message);
            }
            if (shutdownItems.apply(ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.SHUTDOWN_REASON, (String)INFO_REASON)).hasItems()) {
                String message = Messages.getString("FatalErrorRule_TEXT_INFO");
                return new Result((IRule)this, 25.0, message);
            }
        }
        return new Result((IRule)this, 0.0, Messages.getString("FatalErrorRule_TEXT_OK"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FatalErrorRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

