/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class BufferLostRule
implements IRule {
    private static final String BUFFER_LOST_RESULT_ID = "BufferLost";
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("bufferlost.warning.limit", Messages.getString("BufferLostRuleFactory_CONFIG_WARN_LIMIT"), Messages.getString("BufferLostRuleFactory_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        IQuantity limit = (IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT);
        IItemCollection filtered = items.apply(JdkFilters.JFR_DATA_LOST);
        IQuantity startTime = (IQuantity)filtered.getAggregate(JdkAggregators.first((IAttribute)JfrAttributes.START_TIME));
        if (startTime != null) {
            IQuantity droppedCount = (IQuantity)filtered.getAggregate(JdkAggregators.JFR_DATA_LOST_COUNT);
            IQuantity droppedSize = (IQuantity)filtered.getAggregate(JdkAggregators.FLR_DATA_LOST_SIZE);
            String shortDescription = MessageFormat.format("BufferLostRuleFactory_TEXT_INFO", droppedCount.displayUsing("auto"), droppedSize.displayUsing("auto"));
            String longDescription = MessageFormat.format(Messages.getString("BufferLostRuleFactory_TEXT_INFO_LONG"), droppedCount.displayUsing("auto"), droppedSize.displayUsing("auto"), startTime.displayUsing("auto"));
            return new Result((IRule)this, this.calculateScore(limit, droppedCount), shortDescription, longDescription, JdkQueries.JFR_DATA_LOST);
        }
        return new Result((IRule)this, 0.0, Messages.getString("BufferLostRuleFactory_RULE_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return BufferLostRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private double calculateScore(IQuantity limit, IQuantity droppedCount) {
        return RulesToolkit.mapExp100((double)limit.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY), (double)droppedCount.longValue());
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return BUFFER_LOST_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("BufferLostRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "recording";
    }
}

