/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DMSIncidentRule
implements IRule {
    private static final String RESULT_ID = "DMSIncident";
    private static final String DMS_PATH = "http://www.oracle.com/dms/dfw/dms/dfw/DFW_Incident/DFW_Incident_state";
    private static final IItemFilter FILTER = ItemFilters.type((String)"http://www.oracle.com/dms/dfw/dms/dfw/DFW_Incident/DFW_Incident_state");
    public static final IAggregator<IQuantity, ?> INCIDENTS_COUNT = Aggregators.count((String)Messages.getString("DMSIncidentRule_AGGR_INCIDENTS_COUNT"), (String)Messages.getString("DMSIncidentRule_AGGR_INCIDENTS_COUNT_DESC"), (IItemFilter)FILTER);
    private static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("dmsincident.warning.limit", Messages.getString("DMSIncidentRule_CONFIG_WARNING_LIMIT"), Messages.getString("DMSIncidentRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{DMS_PATH});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{DMS_PATH});
        }
        IQuantity limit = (IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT);
        IQuantity incidents = (IQuantity)items.getAggregate(INCIDENTS_COUNT);
        if (incidents != null && incidents.compareTo((Object)limit) >= 0) {
            double score = RulesToolkit.mapExp100((double)incidents.doubleValue(), (double)limit.doubleValueIn(incidents.getUnit()));
            IItemQuery query = ItemQueryBuilder.fromWhere((IItemFilter)FILTER).build();
            return new Result((IRule)this, score, Messages.getString("DMSIncidentRuleFactory_TEXT_WARN"), MessageFormat.format(Messages.getString("DMSIncidentRuleFactory_TEXT_WARN_LONG"), incidents), query);
        }
        return new Result((IRule)this, 0.0, Messages.getString("DMSIncidentRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DMSIncidentRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DMSIncidentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "DMS";
    }
}

