/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.concurrent.FutureTask;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumerFactory;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.RulePreferences;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class FewSampledThreadsRule
extends AbstractRule {
    private static final String NEW_PARAGRAPH = "<p>";
    private static final IAggregator<Iterable<? extends GroupingAggregator.GroupEntry<IMCThread, Aggregators.CountConsumer>>, ?> SAMPLES_PER_THREAD = GroupingAggregator.build((String)Messages.getString("FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD"), (String)Messages.getString("FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD_DESC"), (IAccessorFactory)JfrAttributes.EVENT_THREAD, (IItemConsumerFactory)Aggregators.count(), (IPredicate)new IPredicate<IType<IItem>>(){

        public boolean evaluate(IType<IItem> type) {
            return type.getIdentifier().equals("jdk.ExecutionSample");
        }
    });
    public static final TypedPreference<IQuantity> SAMPLED_THREADS_RATIO_LIMIT = new TypedPreference("sampled.threads.ratio.limit", Messages.getString("FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT"), Messages.getString("FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.25));
    public static final TypedPreference<IQuantity> MIN_CPU_RATIO_LIMIT = new TypedPreference("min.cpu.per.core.limit", Messages.getString("FewSampledThreadsRule_MIN_CPU_RATIO"), Messages.getString("FewSampledThreadsRule_MIN_CPU_RATIO_LONG"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(10L));
    public static final TypedPreference<IQuantity> CPU_WINDOW_SIZE = new TypedPreference("cpu.window.size", Messages.getString("FewSampledThreadsRule_CPU_WINDOW_SIZE"), Messages.getString("FewSampledThreadsRule_CPU_WINDOW_SIZE_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(10L));
    public static final TypedPreference<IQuantity> MIN_SAMPLE_COUNT = new TypedPreference("min.sample.count", Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT"), Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(20L));
    public static final TypedPreference<IQuantity> MIN_SAMPLE_COUNT_PER_THREAD = new TypedPreference("min.sample.count.per.thread", Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD"), Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(4L));

    public FewSampledThreadsRule() {
        super("FewSampledThreads", Messages.getString("FewSampledThreadsRule_RULE_NAME"), "java_application", new TypedPreference[]{SAMPLED_THREADS_RATIO_LIMIT, MIN_CPU_RATIO_LIMIT, RulePreferences.SHORT_RECORDING_LIMIT, CPU_WINDOW_SIZE, MIN_SAMPLE_COUNT, MIN_SAMPLE_COUNT_PER_THREAD});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        String extraTypesInfo;
        Result availabilityResult = this.checkAvailability(items);
        if (availabilityResult != null) {
            return availabilityResult;
        }
        Result ruleResult = this.calculateResult(items, vp);
        String longDescription = ruleResult.getLongDescription();
        longDescription = longDescription != null ? longDescription : "";
        double score = ruleResult.getScore();
        String shortRecordingInfo = RulesToolkit.getShortRecordingInfo((IItemCollection)items, (IQuantity)((IQuantity)vp.getPreferenceValue(RulePreferences.SHORT_RECORDING_LIMIT)));
        if (shortRecordingInfo != null) {
            longDescription = longDescription + NEW_PARAGRAPH + shortRecordingInfo;
            double d = score = score > 0.0 ? score / 2.0 : score;
        }
        if ((extraTypesInfo = FewSampledThreadsRule.getExtraTypesInfo(items)) != null) {
            longDescription = longDescription + NEW_PARAGRAPH + extraTypesInfo;
        }
        return new Result((IRule)this, score, ruleResult.getShortDescription(), longDescription, ruleResult.getItemQuery());
    }

    private Result calculateResult(IItemCollection items, IPreferenceValueProvider vp) {
        double sampledThreadRatioLimit = ((IQuantity)vp.getPreferenceValue(SAMPLED_THREADS_RATIO_LIMIT)).doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        IQuantity minCpuRatio = (IQuantity)vp.getPreferenceValue(MIN_CPU_RATIO_LIMIT);
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(CPU_WINDOW_SIZE);
        IQuantity minSampleCountPerThread = (IQuantity)vp.getPreferenceValue(MIN_SAMPLE_COUNT_PER_THREAD);
        IQuantity minSampleCount = (IQuantity)vp.getPreferenceValue(MIN_SAMPLE_COUNT);
        Iterable samplesPerThread = (Iterable)items.getAggregate(SAMPLES_PER_THREAD);
        int threadsWithEnoughSamples = 0;
        int sampledThreads = 0;
        for (GroupingAggregator.GroupEntry ge : samplesPerThread) {
            ++sampledThreads;
            if (!((double)((Aggregators.CountConsumer)ge.getConsumer()).getCount() >= minSampleCountPerThread.doubleValue())) continue;
            ++threadsWithEnoughSamples;
        }
        Result idleResult = this.getIdleResult(items, minCpuRatio, windowSize, sampledThreads);
        if (idleResult != null) {
            return idleResult;
        }
        IQuantity totalNumberOfSamples = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"jdk.ExecutionSample")));
        if (totalNumberOfSamples.compareTo((Object)minSampleCount) < 0) {
            return new Result((IRule)this, -1.0, MessageFormat.format(Messages.getString("FewSampledThreadsRule_TEXT_NOT_ENOUGH_SAMPLES"), totalNumberOfSamples.displayUsing("auto"), minSampleCount.displayUsing("auto")));
        }
        long hwThreads = FewSampledThreadsRule.getHardwareThreads(items).longValue();
        if ((long)threadsWithEnoughSamples >= hwThreads) {
            String shortDescription = Messages.getString("FewSampledThreadsRule_TEXT_OK");
            String longDescription = shortDescription + NEW_PARAGRAPH + Messages.getString("FewSampledThreadsRule_TEXT_OK_LONG");
            return new Result((IRule)this, 0.0, shortDescription, longDescription);
        }
        double sampledThreadRatio = (double)threadsWithEnoughSamples / (double)hwThreads;
        double score = RulesToolkit.mapExp74((double)(1.0 - sampledThreadRatio), (double)sampledThreadRatioLimit);
        String shortDescription = Messages.getString("FewSampledThreadsRule_TEXT_INFO");
        String longDescription = shortDescription + NEW_PARAGRAPH + MessageFormat.format(Messages.getString("FewSampledThreadsRule_TEXT_INFO_LONG"), minSampleCountPerThread, threadsWithEnoughSamples, hwThreads);
        return new Result((IRule)this, score, shortDescription, longDescription, JdkQueries.EXECUTION_SAMPLE);
    }

    private Result getIdleResult(IItemCollection items, IQuantity minCpuRatio, IQuantity windowSize, int sampledThreads) {
        IQuantity cores;
        ITypedQuantity maxSingleThreadedCpu;
        ITypedQuantity maxCpuForSampledThreads;
        IQuantity jvmUsage;
        ITypedQuantity cpuRatio;
        IItemCollection cpuItems = FewSampledThreadsRule.getCpuItems(items);
        Pair jvmUsageMaxWindow = SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue((IItemCollection)cpuItems, (IQuantity)windowSize, (FutureTask)this.evaluationTask, (SlidingWindowToolkit.IUnorderedWindowValueFunction)new SlidingWindowToolkit.IUnorderedWindowValueFunction<IQuantity>(){

            public IQuantity getValue(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                return (IQuantity)items.getAggregate(JdkAggregators.AVG_JVM_TOTAL_CPU);
            }
        }, (boolean)true, (boolean)false);
        if (jvmUsageMaxWindow != null && (cpuRatio = UnitLookup.PERCENT.quantity((jvmUsage = (IQuantity)jvmUsageMaxWindow.left).ratioTo((IQuantity)(maxCpuForSampledThreads = UnitLookup.PERCENT.quantity(Math.min(100.0, (maxSingleThreadedCpu = UnitLookup.PERCENT.quantity(100.0 / (cores = (IQuantity)items.apply(ItemFilters.type((String)"jdk.CPUInformation")).getAggregate(Aggregators.max((IAttribute)JdkAttributes.NUMBER_OF_CORES))).doubleValue())).multiply((long)sampledThreads).doubleValue())))) * 100.0)).compareTo((Object)minCpuRatio) < 0) {
            String shortDescription = MessageFormat.format(Messages.getString("FewSampledThreadsRule_APPLICATION_IDLE"), jvmUsage, ((IQuantity)((IRange)jvmUsageMaxWindow.right).getExtent()).displayUsing("auto"), ((IQuantity)((IRange)jvmUsageMaxWindow.right).getStart()).displayUsing("auto"));
            String longDescription = shortDescription + NEW_PARAGRAPH + Messages.getString("FewSampledThreadsRule_APPLICATION_IDLE_LONG");
            return new Result((IRule)this, 0.0, shortDescription, longDescription);
        }
        return null;
    }

    private Result checkAvailability(IItemCollection items) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ActiveSetting", "jdk.ExecutionSample", "jdk.CPUInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ActiveSetting", "jdk.ExecutionSample", "jdk.CPUInformation"});
        }
        IItemCollection cpuItems = FewSampledThreadsRule.getCpuItems(items);
        IType cpuLoadType = RulesToolkit.getType((IItemCollection)cpuItems, (String)"jdk.CPULoad");
        if (!cpuLoadType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.JVM_USER)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)cpuLoadType, (IAttribute)JdkAttributes.JVM_USER);
        }
        IQuantity hwThreadsQ = FewSampledThreadsRule.getHardwareThreads(items);
        if (hwThreadsQ == null) {
            return RulesToolkit.getTooFewEventsResult((IRule)this);
        }
        return null;
    }

    private static String getExtraTypesInfo(IItemCollection items) {
        Object[] extraTypes = new String[]{"jdk.CPULoad"};
        RulesToolkit.EventAvailability extraEventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])extraTypes);
        if (extraEventAvailability != RulesToolkit.EventAvailability.AVAILABLE && extraEventAvailability != RulesToolkit.EventAvailability.ENABLED) {
            return MessageFormat.format(Messages.getString("ApplicationHaltsRule_EXTRA_EVENT_TYPES"), StringToolkit.join((Object[])extraTypes, (String)", "));
        }
        return null;
    }

    private static IItemCollection getCpuItems(IItemCollection items) {
        return items.apply(JdkFilters.CPU_LOAD);
    }

    private static IQuantity getHardwareThreads(IItemCollection items) {
        return (IQuantity)items.apply(ItemFilters.type((String)"jdk.CPUInformation")).getAggregate(Aggregators.max((IAttribute)JdkAttributes.HW_THREADS));
    }
}

