/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ManagementAgentRule
implements IRule {
    private static final String RESULT_ID = "ManagementAgent";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.InitialSystemProperty"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.InitialSystemProperty"});
        }
        IItemCollection properties = items.apply(JdkFilters.SYSTEM_PROPERTIES);
        Set portStr = (Set)properties.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"com.sun.management.jmxremote.port")).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        Set authStr = (Set)properties.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"com.sun.management.jmxremote.authenticate")).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        Set sslStr = (Set)properties.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"com.sun.management.jmxremote.ssl")).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        if (ManagementAgentRule.size(portStr) > 1 || ManagementAgentRule.size(authStr) > 1 || ManagementAgentRule.size(sslStr) > 1) {
            return new Result((IRule)this, 50.0, Messages.getString("ManagementAgentRule_TEXT_INFO"), Messages.getString("ManagementAgentRule_TEXT_INFO_LONG"));
        }
        if (ManagementAgentRule.size(portStr) > 0) {
            boolean ssl;
            boolean auth = ManagementAgentRule.size(authStr) > 0 ? Boolean.parseBoolean((String)authStr.iterator().next()) : true;
            boolean bl = ssl = ManagementAgentRule.size(sslStr) > 0 ? Boolean.parseBoolean((String)sslStr.iterator().next()) : true;
            if (!auth && !ssl) {
                String shortMessage = Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED");
                String longMessage = Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED_LONG") + "<p>" + Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_CONFIGURE_GUIDE");
                return new Result((IRule)this, 100.0, shortMessage, longMessage);
            }
            if (!auth) {
                String shortMessage = Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED");
                String longMessage = Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED_LONG") + "<p>" + Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_CONFIGURE_GUIDE");
                return new Result((IRule)this, 100.0, shortMessage, longMessage);
            }
            if (!ssl) {
                String shortMessage = Messages.getString("ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED");
                String longMessage = Messages.getString("ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED_LONG") + "<p>" + Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_CONFIGURE_GUIDE");
                return new Result((IRule)this, 50.0, shortMessage, longMessage);
            }
        }
        return new Result((IRule)this, 0.0, Messages.getString("ManagmentAgentRuleFactory_TEXT_OK"));
    }

    private static int size(Collection<?> set) {
        return set == null ? 0 : set.size();
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ManagementAgentRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ManagmentAgentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

