/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ClassEntry;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ColumnInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.IItemResultSet;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetException;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetFactory;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public final class BiasedLockingRevocationRule
implements IRule {
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("biasedRevocation.warning.limit", Messages.getString("BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT"), Messages.getString("BiasedLockingRevocationRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(15L));
    public static final TypedPreference<IQuantity> MAX_NUMBER_OF_CLASSES_TO_REPORT = new TypedPreference("biasedRevocation.classesToReport.limit", Messages.getString("General_CONFIG_CLASS_LIMIT"), Messages.getString("General_CONFIG_CLASS_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(5L));
    private static final TypedPreference<String> FILTERED_CLASSES = new TypedPreference("biasedRevocation.filtered.classes", Messages.getString("BiasedLockingRevocationRule_CONFIG_FILTERED_CLASSES"), Messages.getString("BiasedLockingRevocationRule_CONFIG_FILTERED_CLASSES_LONG"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"java.lang.ref.ReferenceQueue$Lock");
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT, MAX_NUMBER_OF_CLASSES_TO_REPORT, FILTERED_CLASSES);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.BiasedLockClassRevocation"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.BiasedLockClassRevocation"});
        }
        IItemCollection revokationEvents = items.apply(JdkFilters.BIASED_LOCKING_REVOCATIONS);
        if (!revokationEvents.hasItems()) {
            return new Result((IRule)this, 0.0, Messages.getString("BiasedLockingRevocationPauseRule_TEXT_OK"));
        }
        Set<String> filteredTypes = BiasedLockingRevocationRule.getFilteredTypes((String)valueProvider.getPreferenceValue(FILTERED_CLASSES));
        IItemCollection revokedClassesEvents = revokationEvents.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.BIASED_REVOCATION_CLASS), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.BIASED_REVOCATION_DISABLE_BIASING, (Object)Boolean.TRUE)}));
        Set<IMCType> revokedTypes = this.filter(filteredTypes, (Set)revokedClassesEvents.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.BIASED_REVOCATION_CLASS)));
        StringBuilder shortMessage = new StringBuilder();
        StringBuilder longMessage = new StringBuilder();
        float totalScore = 0.0f;
        if (!revokedTypes.isEmpty()) {
            totalScore = 25.0f;
            totalScore = (float)((double)totalScore + RulesToolkit.mapExp((double)revokedTypes.size(), (double)25.0, (double)7.0, (double)20.0));
            shortMessage.append(Messages.getString("BiasedLockingRevocationRule_TEXT_REVOKED_CLASSES_FOUND"));
            shortMessage.append(" ");
            longMessage.append(Messages.getString("BiasedLockingRevocationRule_TEXT_REVOKED_CLASSES_FOUND_LONG"));
            longMessage.append("<p><ul>");
            for (IMCType offender : revokedTypes) {
                longMessage.append("<li>");
                longMessage.append(offender.toString());
                longMessage.append("</li>");
            }
            longMessage.append("</ul></p>");
        }
        int warningLimit = (int)((IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT)).longValue();
        Map<IMCType, ClassEntry> revocationMap = this.extractRevocations(revokationEvents, ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.BiasedLockRevocation"), ItemFilters.type((String)"jdk.BiasedLockSelfRevocation")}), (IAttribute<IMCType>)JdkAttributes.BIASED_REVOCATION_LOCK_CLASS);
        Map<IMCType, ClassEntry> classRevocationMap = this.extractRevocations(revokationEvents, ItemFilters.type((String)"jdk.BiasedLockClassRevocation"), (IAttribute<IMCType>)JdkAttributes.BIASED_REVOCATION_CLASS);
        List<ClassEntry> revocationClasses = this.filteredMerge(filteredTypes, revokedTypes, classRevocationMap, revocationMap);
        totalScore += (float)this.calculateRevocationCountScore(revocationClasses);
        Collections.sort(revocationClasses);
        if (revocationClasses.size() > 0) {
            ClassEntry classEntry;
            int maxClasses = (int)((IQuantity)valueProvider.getPreferenceValue(MAX_NUMBER_OF_CLASSES_TO_REPORT)).longValue();
            shortMessage.append(Messages.getString("BiasedLockingRevocationRule_TEXT_REVOKE_LIMIT_CLASSES_FOUND"));
            longMessage.append(MessageFormat.format(Messages.getString("BiasedLockingRevocationRule_TEXT_REVOKE_LIMIT_CLASSES_FOUND_LONG"), warningLimit));
            longMessage.append("<p><ul>");
            int classLimit = Math.min(revocationClasses.size(), maxClasses);
            for (int i = 0; i < classLimit && (classEntry = revocationClasses.get(i)).getCount() >= warningLimit; ++i) {
                longMessage.append("<li>");
                longMessage.append(classEntry);
                longMessage.append("</li>");
            }
            longMessage.append("</ul></p>");
        }
        if (totalScore == 0.0f) {
            return new Result((IRule)this, 0.0, Messages.getString("BiasedLockingRevocationRule_TEXT_OK"));
        }
        longMessage.append(MessageFormat.format(Messages.getString("BiasedLockingRevocationRule_TEXT_EPILOGUE"), String.valueOf(filteredTypes)));
        return new Result((IRule)this, (double)totalScore, shortMessage.toString(), longMessage.toString());
    }

    private int calculateRevocationCountScore(List<ClassEntry> offendingClasses) {
        int score = 0;
        for (ClassEntry entry : offendingClasses) {
            score = Math.max(Math.min(entry.getCount() / 2, 25), score);
        }
        return score;
    }

    private List<ClassEntry> filteredMerge(Set<String> filteredTypes, Set<IMCType> revokedTypes, Map<IMCType, ClassEntry> offendingClassRevocations, Map<IMCType, ClassEntry> offendingRevocations) {
        HashMap<IMCType, ClassEntry> merged = new HashMap<IMCType, ClassEntry>();
        for (Map.Entry<IMCType, ClassEntry> entry : offendingRevocations.entrySet()) {
            BiasedLockingRevocationRule.putIfNotInFiltered(filteredTypes, revokedTypes, merged, entry);
        }
        for (Map.Entry<IMCType, ClassEntry> entry : offendingClassRevocations.entrySet()) {
            ClassEntry mergedEntry = (ClassEntry)merged.get(entry.getKey());
            if (mergedEntry != null) {
                merged.put(entry.getKey(), new ClassEntry(entry.getKey(), entry.getValue().getCount() + mergedEntry.getCount()));
                continue;
            }
            BiasedLockingRevocationRule.putIfNotInFiltered(filteredTypes, revokedTypes, merged, entry);
        }
        return new ArrayList<ClassEntry>(merged.values());
    }

    private static void putIfNotInFiltered(Set<String> filteredTypes, Set<IMCType> revokedTypes, Map<IMCType, ClassEntry> merged, Map.Entry<IMCType, ClassEntry> entry) {
        IMCType type = entry.getKey();
        if (type != null && !filteredTypes.contains(type.getFullName()) && !revokedTypes.contains(type)) {
            merged.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<IMCType, ClassEntry> extractRevocations(IItemCollection revokationEvents, IItemFilter filter, IAttribute<IMCType> classAttribute) {
        ItemQueryBuilder itemQueryBuilder = ItemQueryBuilder.fromWhere((IItemFilter)filter);
        itemQueryBuilder.groupBy(classAttribute);
        itemQueryBuilder.select(classAttribute);
        itemQueryBuilder.select(Aggregators.count());
        IItemQuery query = itemQueryBuilder.build();
        IItemResultSet resultSet = new ItemResultSetFactory().createResultSet(revokationEvents, query);
        ColumnInfo countColumn = resultSet.getColumnMetadata().get(Aggregators.count().getName());
        ColumnInfo classColumn = resultSet.getColumnMetadata().get(classAttribute.getIdentifier());
        HashMap<IMCType, ClassEntry> offendingClasses = new HashMap<IMCType, ClassEntry>();
        while (resultSet.next()) {
            try {
                IQuantity countObject = (IQuantity)resultSet.getValue(countColumn.getColumn());
                IMCType type = (IMCType)resultSet.getValue(classColumn.getColumn());
                if (countObject == null || type == null) continue;
                offendingClasses.put(type, new ClassEntry(type, (int)countObject.longValue()));
            }
            catch (ItemResultSetException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected problem looking at biased revocation events.", e);
            }
        }
        return offendingClasses;
    }

    private Set<IMCType> filter(Set<String> filteredTypes, Set<IMCType> types) {
        HashSet<IMCType> result = new HashSet<IMCType>();
        for (IMCType type : types) {
            if (filteredTypes.contains(type.getFullName())) continue;
            result.add(type);
        }
        return result;
    }

    private static Set<String> getFilteredTypes(String preferenceValue) {
        HashSet<String> acceptedOptionNames = new HashSet<String>();
        if (preferenceValue != null) {
            String[] optionNames;
            for (String optionName : optionNames = preferenceValue.split("[, ]+")) {
                acceptedOptionNames.add(optionName);
            }
        }
        return acceptedOptionNames;
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return BiasedLockingRevocationRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return "biasedLockingRevocation";
    }

    public String getName() {
        return Messages.getString("BiasedLockingRevocationRule_NAME");
    }

    public String getTopic() {
        return "biased_locking";
    }
}

