/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Set;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class AutoBoxingRule
extends AbstractRule {
    private static final IItemFilter BOXED_TYPES_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Boolean"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Byte"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Character"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Double"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Float"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Integer"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Long"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (String)"java.lang.Short")});
    private static final IItemFilter AUTOBOXING_TOP_FRAME_FILTER = ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Boolean.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Byte.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Character.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Double.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Float.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Integer.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Long.valueOf"), ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, (String)"java.lang.Short.valueOf")});
    private static final TypedPreference<IQuantity> AUTOBOXING_RATIO_INFO_LIMIT = new TypedPreference("autoboxing.ratio.info.limit", Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT"), Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(20L));
    private static final TypedPreference<IQuantity> AUTOBOXING_RATIO_WARNING_LIMIT = new TypedPreference("autoboxing.ratio.warning.limit", Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT"), Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(80L));

    public AutoBoxingRule() {
        super("PrimitiveToObjectConversion", Messages.getString("AutoboxingRule_RULE_NAME"), "heap", new TypedPreference[]{AUTOBOXING_RATIO_INFO_LIMIT, AUTOBOXING_RATIO_WARNING_LIMIT});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability allocAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        if (allocAvail != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)allocAvail, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        }
        double autoboxingRatioInfoLimit = ((IQuantity)vp.getPreferenceValue(AUTOBOXING_RATIO_INFO_LIMIT)).doubleValue();
        double autoboxingRatioWarningLimit = ((IQuantity)vp.getPreferenceValue(AUTOBOXING_RATIO_WARNING_LIMIT)).doubleValue();
        IItemCollection allocationItems = items.apply(JdkFilters.ALLOC_ALL);
        IItemCollection boxedTypesItems = allocationItems.apply(BOXED_TYPES_FILTER);
        IItemCollection autoboxingStacktraceItems = boxedTypesItems.apply(AUTOBOXING_TOP_FRAME_FILTER);
        IQuantity possibleAutoboxingSize = (IQuantity)autoboxingStacktraceItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        if (possibleAutoboxingSize == null) {
            return new Result((IRule)this, 0.0, Messages.getString("AutoboxingRule_RESULT_NO_AUTOBOXING"));
        }
        IQuantity totalAllocationSize = (IQuantity)allocationItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        double possibleAutoboxingRatio = possibleAutoboxingSize.ratioTo(totalAllocationSize) * 100.0;
        double score = RulesToolkit.mapExp100((double)possibleAutoboxingRatio, (double)autoboxingRatioInfoLimit, (double)autoboxingRatioWarningLimit);
        String mostAllocatedTypeInfo = "";
        String mostAllocatedTypeInfoLong = "";
        Set autoboxedTypes = (Set)autoboxingStacktraceItems.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.OBJECT_CLASS_FULLNAME));
        String mostAllocatedType = null;
        IItemCollection mostAutoboxedTypeItems = null;
        ITypedQuantity mostAllocated = UnitLookup.BYTE.quantity(0L);
        for (String type : autoboxedTypes) {
            IItemCollection autoboxedTypeItems = autoboxingStacktraceItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (Object)type));
            IQuantity allocated = (IQuantity)autoboxedTypeItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
            if (allocated.compareTo((Object)mostAllocated) <= 0) continue;
            mostAllocatedType = type;
            mostAllocated = allocated;
            mostAutoboxedTypeItems = autoboxedTypeItems;
        }
        if (mostAllocatedType != null) {
            String secondFrame = RulesToolkit.getSecondFrameInMostCommonTrace(mostAutoboxedTypeItems);
            mostAllocatedTypeInfo = " " + MessageFormat.format(Messages.getString("AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE"), mostAllocatedType);
            mostAllocatedTypeInfoLong = "<p>" + MessageFormat.format(Messages.getString("AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE_LONG"), mostAllocatedType, mostAllocated.displayUsing("auto"), secondFrame);
        }
        String shortIntro = MessageFormat.format(Messages.getString("AutoboxingRule_RESULT_AUTOBOXING_RATIO"), Math.round(possibleAutoboxingRatio), possibleAutoboxingSize.displayUsing("auto"));
        String shortMessage = shortIntro + mostAllocatedTypeInfo;
        String longMessage = shortIntro + mostAllocatedTypeInfoLong + "<p>" + Messages.getString("AutoboxingRule_RESULT_LONG");
        return new Result((IRule)this, score, shortMessage, longMessage);
    }
}

