/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.RulePreferences;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class GcFreedRatioRule
extends AbstractRule {
    private static final String NEW_PARAGRAPH = "<p>";
    private static final String SPACE = " ";
    private static final TypedPreference<IQuantity> GC_FREED_PER_SECOND_TO_LIVESET_RATIO_INFO_LIMIT = new TypedPreference("gc.freed.per.second.to.liveset.ratio.info.limit", Messages.getString("GcFreedRatioRule_GC_FREED_RATIO_INFO_LIMIT"), Messages.getString("GcFreedRatioRule_GC_FREED_RATIO_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT_UNITY.quantity(10L));
    public static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("gc.freed.per.second.to.liveset.ratio.window.size", Messages.getString("GcFreedRatioRule_WINDOW_SIZE"), Messages.getString("GcFreedRatioRule_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(10L));
    public static final TypedPreference<IQuantity> FEW_GCS_LIMIT = new TypedPreference("few.gcs.limit", Messages.getString("GcFreedRatioRule_FEW_GCS_LIMIT"), Messages.getString("GcFreedRatioRule_FEW_GCS_LIMIT_DESC"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(10L));

    public GcFreedRatioRule() {
        super("GcFreedRatio", Messages.getString("GcFreedRatioRule_RULE_NAME"), "heap", new TypedPreference[]{GC_FREED_PER_SECOND_TO_LIVESET_RATIO_INFO_LIMIT, WINDOW_SIZE, FEW_GCS_LIMIT, RulePreferences.SHORT_RECORDING_LIMIT});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability heapSummaryAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GCHeapSummary"});
        if (heapSummaryAvailability != RulesToolkit.EventAvailability.ENABLED && heapSummaryAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)heapSummaryAvailability, (String[])new String[]{"jdk.GCHeapSummary"});
        }
        String recommendedEventTypesInfo = null;
        RulesToolkit.EventAvailability allocAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        if (allocAvailability != RulesToolkit.EventAvailability.ENABLED && allocAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            recommendedEventTypesInfo = RulesToolkit.getEnabledEventTypesRecommendation((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        }
        double infoLimit = ((IQuantity)vp.getPreferenceValue(GC_FREED_PER_SECOND_TO_LIVESET_RATIO_INFO_LIMIT)).doubleValue();
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(WINDOW_SIZE);
        IQuantity slideSize = windowSize.getUnit().quantity(windowSize.ratioTo(windowSize.getUnit().quantity(2L)));
        IQuantity shortRecordingLimit = (IQuantity)vp.getPreferenceValue(RulePreferences.SHORT_RECORDING_LIMIT);
        IQuantity fewGcsLimit = (IQuantity)vp.getPreferenceValue(FEW_GCS_LIMIT);
        IQuantity heapSummaryCount = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"jdk.GCHeapSummary")));
        if (heapSummaryCount.compareTo((Object)fewGcsLimit) < 0) {
            return new Result((IRule)this, 0.0, MessageFormat.format(Messages.getString("GcFreedRatioRule_RESULT_FEW_GCS"), heapSummaryCount.displayUsing("auto"), fewGcsLimit.displayUsing("auto")));
        }
        GcInfoHolder maxFreedGcInfo = this.getMaxFreedWindow(items, windowSize, slideSize);
        double freedRatio = maxFreedGcInfo.freedPerSecondToLivesetRatio.doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY);
        double score = RulesToolkit.mapExp74((double)freedRatio, (double)infoLimit);
        String longDescription = MessageFormat.format(Messages.getString("GcFreedRatioRule_RESULT_LONG_DESCRIPTION"), maxFreedGcInfo.freedPerSecond.displayUsing("auto"), ((IQuantity)maxFreedGcInfo.range.getExtent()).displayUsing("auto"), ((IQuantity)maxFreedGcInfo.range.getStart()).displayUsing("auto"), freedRatio, maxFreedGcInfo.averageLiveset.displayUsing("auto"));
        String shortDescription = MessageFormat.format(Messages.getString("GcFreedRatioRule_RESULT_SHORT_DESCRIPTION"), Float.valueOf((float)Math.round(freedRatio * 10.0) / 10.0f));
        if (score < Severity.INFO.getLimit()) {
            shortDescription = shortDescription + SPACE + Messages.getString("GcFreedRatioRule_RESULT_OK");
            longDescription = longDescription + SPACE + Messages.getString("GcFreedRatioRule_RESULT_OK");
        } else {
            shortDescription = shortDescription + SPACE + Messages.getString("GcFreedRatioRule_RESULT_NOT_OK");
            longDescription = longDescription + SPACE + Messages.getString("GcFreedRatioRule_RESULT_NOT_OK");
            longDescription = longDescription + NEW_PARAGRAPH + Messages.getString("GcFreedRatioRule_RESULT_MORE_INFO");
        }
        String shortRecordingInfo = RulesToolkit.getShortRecordingInfo((IItemCollection)items, (IQuantity)shortRecordingLimit);
        if (shortRecordingInfo != null) {
            longDescription = longDescription + NEW_PARAGRAPH + shortRecordingInfo;
            double d = score = score > 0.0 ? score / 2.0 : score;
        }
        if (recommendedEventTypesInfo != null) {
            longDescription = longDescription + NEW_PARAGRAPH + recommendedEventTypesInfo;
        }
        return new Result((IRule)this, score, shortDescription, longDescription, JdkQueries.HEAP_SUMMARY);
    }

    private GcInfoHolder getMaxFreedWindow(final IItemCollection allItems, IQuantity windowSize, IQuantity slideSize) {
        final GcInfoHolder maxFreedGcInfo = new GcInfoHolder();
        maxFreedGcInfo.freedPerSecondToLivesetRatio = UnitLookup.PERCENT.quantity(0L);
        maxFreedGcInfo.freedPerSecond = UnitLookup.BYTE.quantity(0L);
        maxFreedGcInfo.averageLiveset = UnitLookup.BYTE.quantity(0L);
        maxFreedGcInfo.range = QuantityRange.createWithEnd((IQuantity)UnitLookup.EPOCH_MS.quantity(0L), (IQuantity)UnitLookup.EPOCH_MS.quantity(0L));
        SlidingWindowToolkit.slidingWindowUnordered((SlidingWindowToolkit.IUnorderedWindowVisitor)new SlidingWindowToolkit.IUnorderedWindowVisitor(){

            public void visitWindow(IItemCollection windowItems, IQuantity startTime, IQuantity endTime) {
                IRange range;
                double recordingLengthInSeconds;
                Pair<IItemCollection, IRange<IQuantity>> windowRangePair = this.getWindowWithPairedHeapSummaryEvents(windowItems, startTime, endTime);
                windowItems = (IItemCollection)windowRangePair.left;
                IQuantity beforeGc = (IQuantity)windowItems.getAggregate(JdkAggregators.SUM_HEAP_USED_BEFORE_GC);
                IQuantity afterGc = (IQuantity)windowItems.getAggregate(JdkAggregators.SUM_HEAP_USED_AFTER_GC);
                IQuantity averageLiveset = (IQuantity)windowItems.getAggregate(JdkAggregators.AVG_HEAP_USED_AFTER_GC);
                if (beforeGc == null || afterGc == null || averageLiveset == null) {
                    return;
                }
                IQuantity totalFreed = beforeGc.subtract(afterGc);
                IQuantity freedPerSecond = totalFreed.multiply(1.0 / (recordingLengthInSeconds = ((IQuantity)(range = (IRange)windowRangePair.right).getExtent()).in((IUnit)UnitLookup.SECOND).doubleValue()));
                ITypedQuantity freedPerSecondToLivesetRatio = UnitLookup.PERCENT_UNITY.quantity(freedPerSecond.ratioTo(averageLiveset));
                if (freedPerSecondToLivesetRatio.compareTo((Object)maxFreedGcInfo.freedPerSecondToLivesetRatio) > 0) {
                    maxFreedGcInfo.freedPerSecondToLivesetRatio = freedPerSecondToLivesetRatio;
                    maxFreedGcInfo.freedPerSecond = freedPerSecond;
                    maxFreedGcInfo.averageLiveset = averageLiveset;
                    maxFreedGcInfo.range = range;
                }
            }

            private Pair<IItemCollection, IRange<IQuantity>> getWindowWithPairedHeapSummaryEvents(IItemCollection windowItems, IQuantity startTime, IQuantity endTime) {
                IQuantity newStartTime = null;
                IQuantity newEndTime = null;
                IItemCollection heapSummaryWindowItems = windowItems.apply(JdkFilters.HEAP_SUMMARY);
                IItemCollection heapSummaryAllItems = allItems.apply(JdkFilters.HEAP_SUMMARY);
                IQuantity lowestGcId = (IQuantity)heapSummaryWindowItems.getAggregate(Aggregators.min((IAttribute)JdkAttributes.GC_ID));
                IItemCollection lowestGcIdWindowItems = heapSummaryWindowItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)lowestGcId));
                IItemCollection lowestGcIdAllItems = heapSummaryAllItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)lowestGcId));
                IItemCollection lowestGcIdBeforeWindowItems = lowestGcIdWindowItems.apply(JdkFilters.HEAP_SUMMARY_BEFORE_GC);
                IItemCollection lowestGcIdAfterWindowItems = lowestGcIdWindowItems.apply(JdkFilters.HEAP_SUMMARY_AFTER_GC);
                IItemCollection lowestGcIdBeforeAllItems = lowestGcIdAllItems.apply(JdkFilters.HEAP_SUMMARY_BEFORE_GC);
                if (lowestGcIdAfterWindowItems.hasItems() && !lowestGcIdBeforeWindowItems.hasItems() && lowestGcIdBeforeAllItems.hasItems()) {
                    newStartTime = (IQuantity)lowestGcIdBeforeAllItems.getAggregate(JdkAggregators.FIRST_ITEM_END);
                }
                IQuantity highestGcId = (IQuantity)heapSummaryWindowItems.getAggregate(Aggregators.max((IAttribute)JdkAttributes.GC_ID));
                IItemCollection highestGcIdWindowItems = heapSummaryWindowItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)highestGcId));
                IItemCollection highestGcIdAllItems = heapSummaryAllItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)highestGcId));
                IItemCollection highestGcIdBeforeWindowItems = highestGcIdWindowItems.apply(JdkFilters.HEAP_SUMMARY_BEFORE_GC);
                IItemCollection highestGcIdAfterWindowItems = lowestGcIdWindowItems.apply(JdkFilters.HEAP_SUMMARY_AFTER_GC);
                IItemCollection highestGcIdAfterAllItems = highestGcIdAllItems.apply(JdkFilters.HEAP_SUMMARY_BEFORE_GC);
                if (highestGcIdBeforeWindowItems.hasItems() && !highestGcIdAfterWindowItems.hasItems() && highestGcIdAfterAllItems.hasItems()) {
                    newEndTime = (IQuantity)highestGcIdAfterAllItems.getAggregate(JdkAggregators.FIRST_ITEM_START);
                }
                if (newStartTime != null || newEndTime != null) {
                    if (newStartTime != null) {
                        startTime = newStartTime;
                    }
                    if (newEndTime != null) {
                        endTime = newEndTime;
                    }
                    windowItems = allItems.apply(ItemFilters.interval((ICanonicalAccessorFactory)JfrAttributes.END_TIME, (Comparable)startTime, (boolean)false, (Comparable)endTime, (boolean)false));
                }
                Set gcIds = (Set)windowItems.apply(JdkFilters.HEAP_SUMMARY).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.GC_ID));
                Iterator iterator = gcIds.iterator();
                while (iterator.hasNext()) {
                    IQuantity gcId = (IQuantity)iterator.next();
                    IItemCollection gcItems = windowItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)gcId));
                    if (gcItems.apply(JdkFilters.AFTER_GC).hasItems() && gcItems.apply(JdkFilters.BEFORE_GC).hasItems()) continue;
                    iterator.remove();
                }
                return new Pair((Object)windowItems.apply(ItemFilters.memberOf((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Set)gcIds)), (Object)QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime));
            }

            public boolean shouldContinue() {
                return !GcFreedRatioRule.this.evaluationTask.isCancelled();
            }
        }, (IItemCollection)allItems, (IQuantity)windowSize, (IQuantity)slideSize);
        return maxFreedGcInfo;
    }

    private static class GcInfoHolder {
        protected IRange<IQuantity> range;
        protected IQuantity freedPerSecond;
        protected IQuantity averageLiveset;
        protected IQuantity freedPerSecondToLivesetRatio;

        private GcInfoHolder() {
        }
    }
}

