/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class HeapInspectionRule
implements IRule {
    private static final String HEAP_INSPECTION_RESULT_ID = "HeapInspectionGc";
    public static final TypedPreference<IQuantity> HEAP_INSPECTION_LIMIT = new TypedPreference("heap.inspection.info.limit", Messages.getString("HeapInspectionRule_CONFIG_WARNING_LIMIT"), Messages.getString("HeapInspectionRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(HEAP_INSPECTION_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GarbageCollection"});
                if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
                    return RulesToolkit.getEventAvailabilityResult((IRule)HeapInspectionRule.this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.GarbageCollection"});
                }
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
                return HeapInspectionRule.this.getHeapInspectionResult(aggregate.getObjectCountGCs(), items, (IQuantity)valueProvider.getPreferenceValue(HEAP_INSPECTION_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result getHeapInspectionResult(int objectCountGCs, IItemCollection items, IQuantity limit) {
        if (objectCountGCs > 0) {
            double score = RulesToolkit.mapExp74((double)objectCountGCs, (double)limit.longValue());
            String message = MessageFormat.format(Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO"), objectCountGCs);
            String longMessage = message + " " + Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO_LONG");
            if (RulesToolkit.isEventsEnabled((IItemCollection)items, (String[])new String[]{"jdk.ObjectCount"})) {
                longMessage = longMessage + "<p>" + Messages.getString("HeapInspectionGcRuleFactory_TEXT_INFO_LONG_JFR");
            }
            return new Result((IRule)this, score, message, longMessage, JdkQueries.GARBAGE_COLLECTION);
        }
        return new Result((IRule)this, 0.0, Messages.getString("HeapInspectionGcRuleFactory_TEXT_OK"), Messages.getString("HeapInspectionGcRuleFactory_TEXT_OK_LONG"));
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return HEAP_INSPECTION_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HeapInspectionGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

