/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class IncreasingMetaspaceLiveSetRule
implements IRule {
    private static final String RESULT_ID = "IncreasingMetaSpaceLiveSet";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.MetaspaceSummary"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.MetaspaceSummary"});
        }
        IItemFilter afterFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.METASPACE_SUMMARY_AFTER_GC, JdkFilters.AFTER_GC});
        Iterator allAfterItems = items.apply(afterFilter).iterator();
        if (allAfterItems.hasNext()) {
            IItemIterable afterItems = (IItemIterable)allAfterItems.next();
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(afterItems.getType());
            IMemberAccessor memAccessor = JdkAttributes.GC_METASPACE_USED.getAccessor(afterItems.getType());
            double leastSquare = RulesToolkit.leastSquareMemory((Iterator)afterItems.iterator(), (IMemberAccessor)timeAccessor, (IMemberAccessor)memAccessor);
            double score = RulesToolkit.mapExp100((double)leastSquare, (double)0.75);
            if (score >= 25.0) {
                String shortMessage = Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO");
                String longMessage = shortMessage + " " + Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_INFO_LONG");
                return new Result((IRule)this, score, shortMessage, longMessage, JdkQueries.METASPACE_SUMMARY_AFTER_GC);
            }
            return new Result((IRule)this, score, Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK"), null, JdkQueries.METASPACE_SUMMARY_AFTER_GC);
        }
        return new Result((IRule)this, 0.0, Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_TEXT_OK"), null, JdkQueries.METASPACE_SUMMARY_AFTER_GC);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return IncreasingMetaspaceLiveSetRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("IncreasingMetaspaceLiveSetRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

