/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class MetaspaceOomRule
implements IRule {
    private static final String RESULT_ID = "MetaspaceOom";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.MetaspaceOOM"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.MetaspaceOOM"});
        }
        IQuantity oomCount = (IQuantity)items.getAggregate(JdkAggregators.METASPACE_OOM_COUNT);
        if (oomCount != null && oomCount.doubleValue() > 0.0) {
            double score = RulesToolkit.mapExp100((double)oomCount.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY), (double)1.0);
            String message = MessageFormat.format(Messages.getString("MetaspaceOomRuleFactory_TEXT_WARN"), oomCount.displayUsing("auto"));
            String longMessage = message + " " + Messages.getString("MetaspaceOomRuleFactory_TEXT_WARN_LONG");
            return new Result((IRule)this, score, message, longMessage);
        }
        return new Result((IRule)this, 0.0, Messages.getString("MetaspaceOomRuleFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return MetaspaceOomRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("MetaspaceOomRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

