/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.util;

import org.openjdk.jmc.common.IMCType;

public final class ClassEntry
implements Comparable<ClassEntry> {
    private final IMCType type;
    private final int count;

    public ClassEntry(IMCType type, int count) {
        this.type = type;
        this.count = count;
    }

    @Override
    public int compareTo(ClassEntry o) {
        return o.getCount() - this.getCount();
    }

    public String toString() {
        return this.getType().getFullName() + " (" + this.getCount() + ")";
    }

    public IMCType getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassEntry other = (ClassEntry)obj;
        if (this.count != other.count) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

