/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.views.stacktrace;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.common.AttributeSelection;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.IFlavoredSelection;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStore;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.flightrecorder.ui.selection.StacktraceFrameSelection;
import org.openjdk.jmc.flightrecorder.ui.views.stacktrace.FrameSeparatorManager;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.CopySelectionAction;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.handlers.MethodFormatter;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.CopySettings;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.FormatToolkit;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class StacktraceView
extends ViewPart
implements ISelectionListener {
    private static final String HELP_CONTEXT_ID = "org.openjdk.jmc.flightrecorder.ui.StacktraceView";
    private static final Color ALTERNATE_COLOR;
    private static final String COUNT_IMG_KEY = "countColor";
    private static final Color COUNT_COLOR;
    private static final String SIBLINGS_IMG_KEY = "siblingsColor";
    private static final Color SIBLINGS_COUNT_COLOR;
    private static final int[] DEFAULT_COLUMN_WIDTHS;
    private static final String THREAD_ROOT_KEY = "threadRootAtTop";
    private static final String FRAME_OPTIMIZATION_KEY = "distinguishFramesByOptimization";
    private static final String FRAME_CATEGORIZATION_KEY = "distinguishFramesCategorization";
    private static final String TREE_LAYOUT_KEY = "treeLayout";
    private static final String PERCENTAGE_DURATION_KEY = "perDuration";
    private static final String REDUCED_TREE_KEY = "reducedTreeLayout";
    private static final String METHOD_FORMAT_KEY = "metodFormat";
    private static final String COLUMNS_KEY = "columns";
    private static final String COLUMNS_SEPARATOR = " ";
    private ColumnViewer viewer;
    private boolean treeLayout;
    private boolean perDuration;
    private boolean reducedTree;
    private IAction reducedTreeAction;
    private boolean threadRootAtTop;
    private IItemCollection itemsToShow;
    private MethodFormatter methodFormatter;
    private FrameSeparatorManager frameSeparatorManager;
    private GroupByAction[] groupByActions;
    private IAction[] layoutActions;
    private ViewerAction[] viewerActions;
    private int[] columnWidths;
    private Map<IItemCollection, Object[]> treeViewerExpandedItems = new WeakHashMap<IItemCollection, Object[]>();
    private AttributeSelection attributeSelection;
    private IAttribute<IQuantity> currentAttribute;
    private IToolBarManager toolBar;
    private ViewerColumn valueColumn;
    private static final Listener PERCENTAGE_BACKGROUND_DRAWER;
    private static final Listener PERCENTAGE_BY_DURATION_BACKGROUND_DRAWER;
    private final ColumnLabelProvider percentageLabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            long aggregValue = frame.getAttributeAggregate();
            long totalCount = StacktraceView.getRootFork(frame.getBranch().getParentFork()).getAggregateItemsInFork();
            return UnitLookup.PERCENT_UNITY.quantity((double)aggregValue / (double)totalCount).displayUsing("auto");
        }

        public String getToolTipText(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            StacktraceModel.Fork rootFork = StacktraceView.getRootFork(frame.getBranch().getParentFork());
            int itemCount = frame.getItemCount();
            int totalCount = rootFork.getItemsInFork();
            StacktraceModel.Fork parentFork = frame.getBranch().getParentFork();
            int itemsInSiblings = parentFork.getItemsInFork() - frame.getBranch().getFirstFrame().getItemCount();
            String frameFraction = UnitLookup.PERCENT_UNITY.quantity((double)itemCount / (double)totalCount).displayUsing("auto");
            StringBuilder sb = new StringBuilder("<form>");
            sb.append("<li style='image' value='countColor'><span nowrap='true'>");
            sb.append(Messages.stackTraceMessage(itemCount, totalCount, frameFraction));
            sb.append("</span></li>");
            sb.append("<li style='image' value='siblingsColor'><span nowrap='true'>");
            sb.append(Messages.siblingMessage(itemsInSiblings, parentFork.getBranchCount() - 1));
            sb.append("</span></li>");
            sb.append("</form>");
            return sb.toString();
        }
    };
    private final ColumnLabelProvider percentageByDurationLabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            IQuantity duration = StacktraceView.this.getDurationCount((SimpleArray<IItem>)frame.getItems());
            IQuantity totalDuration = StacktraceView.this.getDurationCount((SimpleArray<IItem>)StacktraceView.getRootFork(frame.getBranch().getParentFork()).getAllItemsInFork());
            return UnitLookup.PERCENT_UNITY.quantity(duration.doubleValue() / totalDuration.doubleValue()).displayUsing("auto");
        }

        public String getToolTipText(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            StacktraceModel.Fork rootFork = StacktraceView.getRootFork(frame.getBranch().getParentFork());
            IQuantity duration = StacktraceView.this.getDurationCount((SimpleArray<IItem>)frame.getItems());
            IQuantity totalDuration = StacktraceView.this.getDurationCount((SimpleArray<IItem>)rootFork.getAllItemsInFork());
            StacktraceModel.Fork parentFork = frame.getBranch().getParentFork();
            int itemsInSiblings = parentFork.getItemsInFork() - frame.getBranch().getFirstFrame().getItemCount();
            String frameFraction = UnitLookup.PERCENT_UNITY.quantity(duration.doubleValue() / totalDuration.doubleValue()).displayUsing("auto");
            StringBuilder sb = new StringBuilder("<form>");
            sb.append("<li style='image' value='countColor'><span nowrap='true'>");
            sb.append(Messages.stackTraceMessage(duration.doubleValue(), totalDuration.doubleValue(), frameFraction));
            sb.append("</span></li>");
            sb.append("<li style='image' value='siblingsColor'><span nowrap='true'>");
            sb.append(Messages.siblingMessage(itemsInSiblings, parentFork.getBranchCount() - 1));
            sb.append("</span></li>");
            sb.append("</form>");
            return sb.toString();
        }
    };
    private final ColumnLabelProvider countLabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            return Long.toString(((StacktraceFrame)element).getAttributeAggregate());
        }
    };
    private final ColumnLabelProvider stackTraceLabelProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            IMCFrame frame = ((StacktraceFrame)element).getFrame();
            FrameSeparator frameSeparator = StacktraceView.this.frameSeparatorManager.getFrameSeparator();
            return this.getText(frame, frameSeparator);
        }

        private String getText(IMCFrame frame, FrameSeparator frameSeparator) {
            return StacktraceFormatToolkit.formatFrame((IMCFrame)frame, (FrameSeparator)frameSeparator, (boolean)StacktraceView.this.methodFormatter.showReturnValue(), (boolean)StacktraceView.this.methodFormatter.showReturnValuePackage(), (boolean)StacktraceView.this.methodFormatter.showClassName(), (boolean)StacktraceView.this.methodFormatter.showClassPackageName(), (boolean)StacktraceView.this.methodFormatter.showArguments(), (boolean)StacktraceView.this.methodFormatter.showArgumentsPackage());
        }

        public Image getImage(Object element) {
            boolean firstInOpenFork;
            StacktraceFrame frame = (StacktraceFrame)element;
            FlightRecorderUI plugin = FlightRecorderUI.getDefault();
            boolean isFirstInBranch = StacktraceView.isFirstInBranchWithSiblings(frame);
            boolean bl = firstInOpenFork = isFirstInBranch && StacktraceView.isInOpenFork(frame);
            if (firstInOpenFork || StacktraceView.this.treeLayout && (!StacktraceView.this.reducedTree || isFirstInBranch)) {
                return plugin.getImage(StacktraceView.this.threadRootAtTop ? "arrow-curved-down.png" : "arrow-curved-up.png");
            }
            if (StacktraceView.isFirstInBranchWithSiblings(frame)) {
                return plugin.getImage(StacktraceView.this.threadRootAtTop ? "arrow-fork3-down.png" : "arrow-fork3-up.png");
            }
            if (StacktraceView.isLastFrame(frame)) {
                return plugin.getImage(StacktraceView.this.threadRootAtTop ? "arrow-down-end.png" : "arrow-up-end.png");
            }
            return plugin.getImage(StacktraceView.this.threadRootAtTop ? "arrow-down.png" : "arrow-up.png");
        }

        public Color getBackground(Object element) {
            if (StacktraceView.this.treeLayout) {
                return null;
            }
            int parentCount = 0;
            StacktraceModel.Branch e = ((StacktraceFrame)element).getBranch();
            while (e != null) {
                e = e.getParentFork().getParentBranch();
                ++parentCount;
            }
            return parentCount % 2 == 0 ? null : ALTERNATE_COLOR;
        }
    };

    static {
        Platform.getAdapterManager().registerAdapters(new IAdapterFactory(){

            public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
                if (adaptableObject instanceof StacktraceFrame && adapterType == IMCFrame.class) {
                    return adapterType.cast(((StacktraceFrame)adaptableObject).getFrame());
                }
                return null;
            }

            public Class<?>[] getAdapterList() {
                return new Class[]{IMCFrame.class};
            }
        }, StacktraceFrame.class);
        ALTERNATE_COLOR = SWTColorToolkit.getColor((RGB)new RGB(255, 255, 240));
        COUNT_COLOR = SWTColorToolkit.getColor((RGB)new RGB(100, 200, 100));
        SIBLINGS_COUNT_COLOR = SWTColorToolkit.getColor((RGB)new RGB(170, 250, 170));
        DEFAULT_COLUMN_WIDTHS = new int[]{650, 80, 120};
        PERCENTAGE_BACKGROUND_DRAWER = new Listener(){

            public void handleEvent(Event event) {
                StacktraceFrame frame = (StacktraceFrame)event.item.getData();
                StacktraceModel.Fork rootFork = StacktraceView.getRootFork(frame.getBranch().getParentFork());
                if (event.index == 2) {
                    double d;
                    double total = rootFork.getAggregateItemsInFork();
                    if (d > 0.0) {
                        StacktraceModel.Fork parentFork = frame.getBranch().getParentFork();
                        long forkOffset = parentFork.getItemOffset();
                        int siblingsStart = (int)Math.floor((double)((long)event.width * forkOffset) / total);
                        int siblingsWidth = (int)Math.round((double)((long)event.width * parentFork.getAggregateItemsInFork()) / total);
                        event.gc.setBackground(SIBLINGS_COUNT_COLOR);
                        event.gc.fillRectangle(event.x + siblingsStart, event.y, siblingsWidth, event.height);
                        double offset = (double)(forkOffset + frame.getBranch().getItemOffsetInFork()) / total;
                        double fraction = (double)frame.getAttributeAggregate() / total;
                        event.gc.setBackground(COUNT_COLOR);
                        int startPixel = (int)Math.floor((double)event.width * offset);
                        int widthPixel = (int)Math.round((double)event.width * fraction);
                        event.gc.fillRectangle(event.x + startPixel, event.y, Math.max(widthPixel, 1), event.height);
                        event.detail &= 0xFFFFFFF7;
                    }
                }
            }
        };
        PERCENTAGE_BY_DURATION_BACKGROUND_DRAWER = new Listener(){

            public void handleEvent(Event event) {
                StacktraceFrame frame = (StacktraceFrame)event.item.getData();
                StacktraceModel.Fork rootFork = StacktraceView.getRootFork(frame.getBranch().getParentFork());
                if (event.index == 3) {
                    double d;
                    double total = rootFork.getAggregateItemsInFork();
                    if (d > 0.0) {
                        StacktraceModel.Fork parentFork = frame.getBranch().getParentFork();
                        long forkOffset = parentFork.getItemOffset();
                        int siblingsStart = (int)Math.floor((double)((long)event.width * forkOffset) / total);
                        int siblingsWidth = (int)Math.round((double)((long)event.width * parentFork.getAggregateItemsInFork()) / total);
                        event.gc.setBackground(SIBLINGS_COUNT_COLOR);
                        event.gc.fillRectangle(event.x + siblingsStart, event.y, siblingsWidth, event.height);
                        double offset = (double)(forkOffset + frame.getBranch().getItemOffsetInFork()) / total;
                        double fraction = (double)frame.getAttributeAggregate() / total;
                        event.gc.setBackground(COUNT_COLOR);
                        int startPixel = (int)Math.floor((double)event.width * offset);
                        int widthPixel = (int)Math.round((double)event.width * fraction);
                        event.gc.fillRectangle(event.x + startPixel, event.y, Math.max(widthPixel, 1), event.height);
                        event.detail &= 0xFFFFFFF7;
                    }
                }
            }
        };
    }

    private void updateReducedTreeOption() {
        this.reducedTreeAction.setEnabled(this.treeLayout);
        this.reducedTreeAction.setChecked(this.reducedTree);
    }

    private void createAttributeSelection(String attrName, Collection<Pair<String, IAttribute<IQuantity>>> items) {
        if (this.attributeSelection != null) {
            this.toolBar.remove(this.attributeSelection.getId());
        }
        this.attributeSelection = new AttributeSelection(items, attrName, this::getCurrentAttribute, this::setCurrentAttribute, this::rebuildModel);
        this.toolBar.insertAfter("AttrSelectionSep", (IAction)this.attributeSelection);
        this.toolBar.update(true);
        if (attrName == null) {
            attrName = "Samples";
        }
        if (this.valueColumn != null) {
            if (this.treeLayout) {
                ((TreeViewerColumn)this.valueColumn).getColumn().setText(attrName);
            } else {
                ((TableViewerColumn)this.valueColumn).getColumn().setText(attrName);
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IState state = MementoToolkit.asState((IMemento)memento);
        this.threadRootAtTop = StateToolkit.readBoolean((IState)state, (String)THREAD_ROOT_KEY, (Boolean)false);
        this.groupByActions = new GroupByAction[]{new GroupByAction(false), new GroupByAction(true)};
        this.treeLayout = StateToolkit.readBoolean((IState)state, (String)TREE_LAYOUT_KEY, (Boolean)false);
        this.perDuration = StateToolkit.readBoolean((IState)state, (String)PERCENTAGE_DURATION_KEY, (Boolean)false);
        this.reducedTree = StateToolkit.readBoolean((IState)state, (String)REDUCED_TREE_KEY, (Boolean)true);
        this.reducedTreeAction = ActionToolkit.checkAction(this::setReducedTree, (String)Messages.STACKTRACE_VIEW_REDUCE_TREE_DEPTH, null);
        this.updateReducedTreeOption();
        IAction treeAction = ActionToolkit.checkAction(this::setTreeLayout, (String)Messages.STACKTRACE_VIEW_TREE_VIEW, (ImageDescriptor)CoreImages.TREE_MODE);
        treeAction.setChecked(this.treeLayout);
        this.layoutActions = new IAction[]{treeAction, this.reducedTreeAction};
        IAction perByDurationAction = ActionToolkit.checkAction(this::setPerDuration, (String)Messages.STACKTRACE_VIEW_PERCENTAGE_BY_DURATION, (ImageDescriptor)CoreImages.TIMESPAN);
        treeAction.setChecked(this.perDuration);
        NavigateAction forwardAction = new NavigateAction(true);
        NavigateAction backwardAction = new NavigateAction(false);
        SelectFrameGroupAction selectGroupAction = new SelectFrameGroupAction();
        this.viewerActions = new ViewerAction[]{selectGroupAction, forwardAction, backwardAction};
        try {
            this.columnWidths = Optional.ofNullable(state).map(s -> Stream.of(s.getAttribute(COLUMNS_KEY).split(COLUMNS_SEPARATOR)).mapToInt(Integer::parseInt).toArray()).filter(widths -> ((int[])widths).length == DEFAULT_COLUMN_WIDTHS.length && Arrays.stream(widths).allMatch(w -> w >= 0)).orElse(DEFAULT_COLUMN_WIDTHS);
        }
        catch (RuntimeException runtimeException) {
            this.columnWidths = DEFAULT_COLUMN_WIDTHS;
        }
        FrameSeparator.FrameCategorization categorization = (FrameSeparator.FrameCategorization)StateToolkit.readEnum((IState)state, (String)FRAME_CATEGORIZATION_KEY, (Enum)FrameSeparator.FrameCategorization.METHOD, FrameSeparator.FrameCategorization.class);
        boolean byOptimization = StateToolkit.readBoolean((IState)state, (String)FRAME_OPTIMIZATION_KEY, (Boolean)false);
        this.frameSeparatorManager = new FrameSeparatorManager(this::rebuildModel, new FrameSeparator(categorization, byOptimization));
        this.methodFormatter = new MethodFormatter(memento == null ? null : memento.getChild(METHOD_FORMAT_KEY), () -> this.viewer.refresh());
        IMenuManager siteMenu = site.getActionBars().getMenuManager();
        siteMenu.add((IContributionItem)new Separator("group.top"));
        siteMenu.add((IContributionItem)new Separator("group.viewerSetup"));
        this.addOptions(siteMenu);
        this.toolBar = site.getActionBars().getToolBarManager();
        this.toolBar.add((IAction)selectGroupAction);
        this.toolBar.add((IAction)backwardAction);
        this.toolBar.add((IAction)forwardAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.add(treeAction);
        this.toolBar.add((IContributionItem)new Separator());
        this.toolBar.add(perByDurationAction);
        Stream.of(this.groupByActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator("AttrSelectionSep"));
        this.createAttributeSelection(null, Collections.emptyList());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private IAttribute<IQuantity> getCurrentAttribute() {
        return this.currentAttribute;
    }

    private void setCurrentAttribute(IAttribute<IQuantity> attr) {
        this.currentAttribute = attr;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.buildViewer(parent);
    }

    private void setTreeLayout(boolean treeLayout) {
        this.treeLayout = treeLayout;
        this.rebuildViewer();
        this.updateReducedTreeOption();
    }

    private void setPerDuration(boolean perDuration) {
        this.perDuration = perDuration;
        this.rebuildModel();
        this.rebuildViewer();
    }

    private void setReducedTree(boolean reducedTree) {
        this.reducedTree = reducedTree;
        if (this.viewer instanceof TreeViewer) {
            this.viewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        }
        this.updateReducedTreeOption();
    }

    private void rebuildViewer() {
        boolean hasFocus = this.viewer.getControl().isFocusControl();
        ISelection oldSelection = this.viewer.getSelection();
        StacktraceModel.Fork oldInput = (StacktraceModel.Fork)this.viewer.getInput();
        Composite parent = this.viewer.getControl().getParent();
        this.viewer.getControl().dispose();
        this.buildViewer(parent);
        if (hasFocus) {
            this.viewer.getControl().setFocus();
        }
        parent.layout();
        if (this.viewer instanceof TreeViewer) {
            Display.getCurrent().asyncExec(() -> {
                if (!this.viewer.getControl().isDisposed()) {
                    StacktraceModel.Branch selectedBranch;
                    this.setViewerInput(oldInput);
                    if (this.reducedTree && oldInput != null && (selectedBranch = StacktraceView.getLastSelectedBranch(oldInput)) != null) {
                        this.viewer.getControl().setRedraw(false);
                        ((TreeViewer)this.viewer).expandToLevel((Object)selectedBranch.getLastFrame(), -1);
                        this.viewer.getControl().setRedraw(true);
                    }
                    this.viewer.setSelection(oldSelection, true);
                }
            });
        } else {
            StacktraceModel.Branch branch = null;
            for (Object o : ((IStructuredSelection)oldSelection).toList()) {
                if (branch == null) {
                    branch = ((StacktraceFrame)o).getBranch();
                    continue;
                }
                if (branch == ((StacktraceFrame)o).getBranch()) continue;
                branch = null;
                break;
            }
            if (branch != null) {
                branch.selectSibling(Integer.valueOf(0));
            }
            this.setViewerInput(oldInput);
            this.viewer.setSelection(oldSelection, true);
        }
    }

    private void buildViewer(Composite parent) {
        CopySelectionAction copyAction;
        this.viewer = this.treeLayout ? this.buildTree(parent) : StacktraceView.buildTable(parent);
        new StacktraceViewToolTipSupport(this.viewer);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.viewer.getControl());
        if (this.perDuration) {
            List<String> headers = Arrays.asList(Messages.STACKTRACE_VIEW_STACK_TRACE, Messages.STACKTRACE_VIEW_COUNT_COLUMN_NAME, Messages.STACKTRACE_VIEW_PERCENTAGE_COLUMN_NAME, Messages.STACKTRACE_VIEW_PERCENTAGE_BY_DURATION_COLUMN_NAME);
            copyAction = new CopySelectionAction((StructuredViewer)this.viewer, FormatToolkit.selectionFormatter(headers, (ILabelProvider[])new ILabelProvider[]{this.stackTraceLabelProvider, this.countLabelProvider, this.percentageLabelProvider, this.percentageByDurationLabelProvider}));
        } else {
            List<String> headers = Arrays.asList(Messages.STACKTRACE_VIEW_STACK_TRACE, Messages.STACKTRACE_VIEW_COUNT_COLUMN_NAME, Messages.STACKTRACE_VIEW_PERCENTAGE_COLUMN_NAME);
            copyAction = new CopySelectionAction((StructuredViewer)this.viewer, FormatToolkit.selectionFormatter(headers, (ILabelProvider[])new ILabelProvider[]{this.stackTraceLabelProvider, this.countLabelProvider, this.percentageLabelProvider}));
        }
        InFocusHandlerActivator.install((Control)this.viewer.getControl(), (IAction)copyAction);
        mm.appendToGroup("group.edit", (IAction)copyAction);
        mm.appendToGroup("group.edit", CopySettings.getInstance().createContributionItem());
        this.addOptions((IMenuManager)mm);
        this.getSite().registerContextMenu((MenuManager)mm, (ISelectionProvider)this.viewer);
        if (!this.treeLayout) {
            String navigateGroupName = "NAVIGATE";
            mm.insert(0, (IContributionItem)new Separator(navigateGroupName));
            Stream.of(this.viewerActions).forEach(a -> {
                a.setViewer((StructuredViewer)this.viewer);
                mm.appendToGroup(navigateGroupName, (IAction)a);
            });
        } else {
            Stream.of(this.viewerActions).forEach(a -> a.setViewer(null));
        }
        this.viewer.getControl().addListener(40, PERCENTAGE_BACKGROUND_DRAWER);
        if (this.perDuration) {
            this.viewer.getControl().addListener(40, PERCENTAGE_BY_DURATION_BACKGROUND_DRAWER);
        }
        this.viewer.getControl().addDisposeListener(e -> {
            this.columnWidths = this.getColumnWidths();
            int[] nArray = this.columnWidths;
        });
        StacktraceView.buildColumn(this.viewer, Messages.STACKTRACE_VIEW_STACK_TRACE, 0, this.columnWidths[0]).setLabelProvider((CellLabelProvider)this.stackTraceLabelProvider);
        this.valueColumn = StacktraceView.buildColumn(this.viewer, "Samples", 131072, this.columnWidths[1]);
        this.valueColumn.setLabelProvider((CellLabelProvider)this.countLabelProvider);
        StacktraceView.buildColumn(this.viewer, Messages.STACKTRACE_VIEW_PERCENTAGE_COLUMN_NAME, 131072, this.columnWidths[2]).setLabelProvider((CellLabelProvider)this.percentageLabelProvider);
        if (this.perDuration) {
            StacktraceView.buildColumn(this.viewer, Messages.STACKTRACE_VIEW_PERCENTAGE_BY_DURATION_COLUMN_NAME, 131072, 300).setLabelProvider((CellLabelProvider)this.percentageByDurationLabelProvider);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), HELP_CONTEXT_ID);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            if (this.treeLayout) {
                FocusTracker.enableFocusTracking((Composite)((TreeViewer)this.viewer).getTree());
            } else {
                FocusTracker.enableFocusTracking((Composite)((TableViewer)this.viewer).getTable());
            }
        }
    }

    private static TableViewer buildTable(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 68354);
        tableViewer.setContentProvider((IContentProvider)new AbstractStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                SimpleArray trace = new SimpleArray((Object[])new StacktraceFrame[100]);
                StacktraceView.addSelectedBranches((StacktraceModel.Fork)inputElement, (SimpleArray<StacktraceFrame>)trace, false);
                return trace.elements();
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        return tableViewer;
    }

    private TreeViewer buildTree(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 68354);
        treeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        return treeViewer;
    }

    private static ViewerColumn buildColumn(ColumnViewer viewer, String text, int style, int width) {
        if (viewer instanceof TableViewer) {
            TableViewerColumn vc = new TableViewerColumn((TableViewer)viewer, style);
            vc.getColumn().setWidth(width);
            vc.getColumn().setText(text);
            return vc;
        }
        TreeViewerColumn vc = new TreeViewerColumn((TreeViewer)viewer, style);
        vc.getColumn().setWidth(width);
        vc.getColumn().setText(text);
        return vc;
    }

    private int[] getColumnWidths() {
        if (!this.viewer.getControl().isDisposed()) {
            if (this.viewer instanceof TableViewer) {
                return Stream.of(((TableViewer)this.viewer).getTable().getColumns()).mapToInt(TableColumn::getWidth).toArray();
            }
            return Stream.of(((TreeViewer)this.viewer).getTree().getColumns()).mapToInt(TreeColumn::getWidth).toArray();
        }
        return this.columnWidths;
    }

    private void addOptions(IMenuManager menu) {
        MenuManager groupMenu = new MenuManager(Messages.STACKTRACE_VIEW_GROUP_FROM);
        Stream.of(this.groupByActions).forEach(arg_0 -> ((MenuManager)groupMenu).add(arg_0));
        menu.appendToGroup("group.top", (IContributionItem)groupMenu);
        menu.appendToGroup("group.top", (IContributionItem)this.frameSeparatorManager.createMenu());
        MenuManager layoutMenu = new MenuManager(Messages.STACKTRACE_VIEW_LAYOUT_OPTIONS);
        Stream.of(this.layoutActions).forEach(arg_0 -> ((MenuManager)layoutMenu).add(arg_0));
        menu.appendToGroup("group.viewerSetup", (IContributionItem)layoutMenu);
        menu.appendToGroup("group.viewerSetup", (IContributionItem)this.methodFormatter.createMenu());
        SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.viewer, this::getSelectionStore, this::getFlavoredSelection, (IContributionManager)menu);
    }

    private IFlavoredSelection getFlavoredSelection() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            List selected = ((StructuredSelection)selection).toList();
            StacktraceFrame frame = (StacktraceFrame)selected.get(0);
            return new StacktraceFrameSelection(frame.getFrame(), ItemCollectionToolkit.build(Stream.of((IItem[])frame.getItems().elements())), Messages.STACKTRACE_VIEW_SELECTION);
        }
        return null;
    }

    private SelectionStore getSelectionStore() {
        IEditorPart editorPart = null;
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            editorPart = this.getSite().getPage().getActiveEditor();
        }
        catch (Exception e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Got exception while trying to get the active editor", e);
        }
        if (editorPart instanceof IPageContainer) {
            return ((IPageContainer)editorPart).getSelectionStore();
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void saveState(IMemento memento) {
        memento.putString(COLUMNS_KEY, IntStream.of(this.getColumnWidths()).mapToObj(Integer::toString).collect(Collectors.joining(COLUMNS_SEPARATOR)));
        this.methodFormatter.saveState(memento.createChild(METHOD_FORMAT_KEY));
        memento.putBoolean(THREAD_ROOT_KEY, this.threadRootAtTop);
        memento.putBoolean(TREE_LAYOUT_KEY, this.treeLayout);
        memento.putBoolean(PERCENTAGE_DURATION_KEY, this.perDuration);
        memento.putBoolean(REDUCED_TREE_KEY, this.reducedTree);
        FrameSeparator frameSeparator = this.frameSeparatorManager.getFrameSeparator();
        memento.putBoolean(FRAME_OPTIMIZATION_KEY, frameSeparator.isDistinguishFramesByOptimization());
        memento.putString(FRAME_CATEGORIZATION_KEY, frameSeparator.getCategorization().name());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IItemCollection items = (IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class);
            if (items == null) {
                this.setItems(ItemCollectionToolkit.build(Stream.empty()));
            } else if (!items.equals(this.itemsToShow)) {
                this.setItems(items);
            }
        }
    }

    private void setItems(IItemCollection items) {
        Object[] expandedElements;
        if (this.viewer.getInput() != null && this.viewer instanceof TreeViewer && this.itemsToShow.hasItems() && (expandedElements = ((TreeViewer)this.viewer).getExpandedElements()).length > 0) {
            this.treeViewerExpandedItems.put(this.itemsToShow, expandedElements);
        }
        this.itemsToShow = items;
        this.rebuildModel();
    }

    private StacktraceModel createStacktraceModel() {
        IItemCollection filteredItems = this.itemsToShow;
        if (this.currentAttribute != null) {
            filteredItems = filteredItems.apply(ItemFilters.hasAttribute(this.currentAttribute));
        }
        return new StacktraceModel(this.threadRootAtTop, this.frameSeparatorManager.getFrameSeparator(), filteredItems, this.currentAttribute);
    }

    private void rebuildModel() {
        this.setViewerInput(null);
        CompletableFuture<StacktraceModel> modelPreparer = StacktraceView.getModelPreparer(this.createStacktraceModel(), !this.treeLayout);
        ((CompletableFuture)modelPreparer.thenAcceptAsync(this::setModel, DisplayToolkit.inDisplayThread())).exceptionally(StacktraceView::handleModelBuildException);
    }

    private static CompletableFuture<StacktraceModel> getModelPreparer(StacktraceModel model, boolean materializeSelectedBranches) {
        return CompletableFuture.supplyAsync(() -> {
            StacktraceModel.Branch selectedBranch;
            StacktraceModel.Fork root = model.getRootFork();
            if (materializeSelectedBranches && (selectedBranch = StacktraceView.getLastSelectedBranch(root)) != null) {
                selectedBranch.getEndFork();
            }
            return model;
        });
    }

    private static Void handleModelBuildException(Throwable ex) {
        FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to build stacktrace view model", ex);
        return null;
    }

    private void setModel(StacktraceModel model) {
        if (!this.viewer.getControl().isDisposed()) {
            this.setViewerInput(model.getRootFork());
        }
        List<Pair<String, IAttribute<IQuantity>>> attrList = AttributeSelection.extractAttributes(this.itemsToShow);
        String attrName = this.currentAttribute != null ? this.currentAttribute.getName() : null;
        this.createAttributeSelection(attrName, attrList);
    }

    private void setViewerInput(StacktraceModel.Fork rootFork) {
        if (rootFork != null && this.viewer instanceof TreeViewer && this.treeViewerExpandedItems.containsKey(this.itemsToShow)) {
            Object[] expandedElements = this.treeViewerExpandedItems.get(this.itemsToShow);
            this.viewer.setInput((Object)rootFork);
            ((TreeViewer)this.viewer).setExpandedElements(expandedElements);
        } else {
            this.viewer.setInput((Object)rootFork);
        }
    }

    private ITreeContentProvider createTreeContentProvider() {
        return this.reducedTree ? new StacktraceReducedTreeContentProvider() : new StacktraceTreeContentProvider();
    }

    private IQuantity getDurationCount(SimpleArray<IItem> simpleArray) {
        IQuantity q = null;
        IItem[] iItemArray = (IItem[])simpleArray.elements();
        int n = iItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItem item = iItemArray[n2];
            IType type = item.getType();
            IMemberAccessor durationAccessor = JfrAttributes.DURATION.getAccessor(type);
            if (durationAccessor != null) {
                q = q != null ? q.add((IQuantity)durationAccessor.getMember((Object)item)) : (IQuantity)durationAccessor.getMember((Object)item);
            }
            ++n2;
        }
        return q;
    }

    private static boolean isNavigationFrame(StacktraceFrame frame) {
        return StacktraceView.isFirstInBranchWithSiblings(frame) && !StacktraceView.isInOpenFork(frame);
    }

    private static boolean isInOpenFork(StacktraceFrame frame) {
        return frame.getBranch().getParentFork().getSelectedBranch() == null;
    }

    private static boolean isFirstInBranchWithSiblings(StacktraceFrame frame) {
        return frame.getBranch().getFirstFrame() == frame && frame.getBranch().getParentFork().getBranchCount() > 1;
    }

    private static boolean isLastFrame(StacktraceFrame frame) {
        return frame.getBranch().getLastFrame() == frame && frame.getBranch().getEndFork().getBranchCount() == 0;
    }

    private static void addSelectedBranches(StacktraceModel.Fork fork, SimpleArray<StacktraceFrame> input, boolean backwards) {
        StacktraceModel.Branch selectedBranch = fork.getSelectedBranch();
        if (selectedBranch == null) {
            Stream.of(fork.getFirstFrames()).forEach(arg_0 -> input.add(arg_0));
        } else if (backwards) {
            StacktraceView.addSelectedBranches(selectedBranch.getEndFork(), input, backwards);
            StacktraceFrame[] tail = selectedBranch.getTailFrames();
            int i = tail.length;
            while (i > 0) {
                input.add((Object)tail[i - 1]);
                --i;
            }
            input.add((Object)selectedBranch.getFirstFrame());
        } else {
            input.add((Object)selectedBranch.getFirstFrame());
            input.addAll((Object[])selectedBranch.getTailFrames());
            StacktraceView.addSelectedBranches(selectedBranch.getEndFork(), input, backwards);
        }
    }

    private static StacktraceModel.Branch getLastSelectedBranch(StacktraceModel.Fork fromFork) {
        StacktraceModel.Branch lastSelectedBranch = null;
        StacktraceModel.Branch branch = fromFork.getSelectedBranch();
        while (branch != null) {
            lastSelectedBranch = branch;
            branch = branch.getEndFork().getSelectedBranch();
        }
        return lastSelectedBranch;
    }

    private static StacktraceModel.Fork getRootFork(StacktraceModel.Fork fork) {
        while (fork.getParentBranch() != null) {
            fork = fork.getParentBranch().getParentFork();
        }
        return fork;
    }

    private class GroupByAction
    extends Action {
        private final boolean fromThreadRootAction;

        GroupByAction(boolean fromRoot) {
            super(fromRoot ? Messages.STACKTRACE_VIEW_THREAD_ROOT : Messages.STACKTRACE_VIEW_LAST_FRAME, 8);
            this.fromThreadRootAction = fromRoot;
            this.setToolTipText(fromRoot ? Messages.STACKTRACE_VIEW_GROUP_TRACES_FROM_ROOT : Messages.STACKTRACE_VIEW_GROUP_TRACES_FROM_LAST_FRAME);
            this.setImageDescriptor(fromRoot ? CoreImages.THREAD : CoreImages.METHOD_NON_OPTIMIZED);
            this.setChecked(fromRoot == StacktraceView.this.threadRootAtTop);
        }

        public void run() {
            boolean newValue;
            boolean bl = newValue = this.isChecked() == this.fromThreadRootAction;
            if (newValue != StacktraceView.this.threadRootAtTop) {
                StacktraceView.this.threadRootAtTop = newValue;
                StacktraceView.this.rebuildModel();
            }
        }
    }

    static class NavigateAction
    extends ViewerAction
    implements TraverseListener {
        private final int offset;

        NavigateAction(boolean forward) {
            super(forward ? Messages.STACKTRACE_VIEW_FRAME_GROUP_NEXT : Messages.STACKTRACE_VIEW_FRAME_GROUP_PREVIOUS);
            this.setImageDescriptor(forward ? FlightRecorderUI.getDefault().getMCImageDescriptor("arrow-fork3-right.png") : FlightRecorderUI.getDefault().getMCImageDescriptor("arrow-fork3-left.png"));
            this.offset = forward ? 1 : -1;
            this.setAccelerator(forward ? 0x1000004 : 0x1000003);
        }

        @Override
        public void setViewer(StructuredViewer provider) {
            super.setViewer(provider);
            if (provider != null) {
                provider.getControl().addTraverseListener((TraverseListener)this);
            }
        }

        public void run() {
            StacktraceModel.Branch branch = ((StacktraceFrame)this.getStructuredSelection().getFirstElement()).getBranch();
            StacktraceModel.Branch selectedSibling = branch.selectSibling(Integer.valueOf(this.offset));
            this.provider.refresh();
            this.provider.setSelection((ISelection)new StructuredSelection((Object)selectedSibling.getFirstFrame()));
        }

        @Override
        protected void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(selection.size() == 1 && StacktraceView.isNavigationFrame((StacktraceFrame)selection.getFirstElement()));
        }

        public void keyTraversed(TraverseEvent e) {
            if (this.isEnabled() && e.keyCode == this.getAccelerator()) {
                this.run();
                e.detail = 0;
                e.doit = true;
            }
        }
    }

    static class SelectFrameGroupAction
    extends ViewerAction {
        SelectFrameGroupAction() {
            super(Messages.STACKTRACE_VIEW_FRAME_GROUP_CHOOSE);
            this.setImageDescriptor(FlightRecorderUI.getDefault().getMCImageDescriptor("arrow-fork3-star.png"));
            this.setAccelerator(13);
        }

        @Override
        public void setViewer(StructuredViewer provider) {
            super.setViewer(provider);
            if (provider != null) {
                provider.addDoubleClickListener(e -> {
                    if (this.isEnabled()) {
                        this.run();
                    }
                });
            }
        }

        public void run() {
            StacktraceFrame frame = (StacktraceFrame)this.getStructuredSelection().getFirstElement();
            if (StacktraceView.isInOpenFork(frame)) {
                frame.getBranch().selectSibling(Integer.valueOf(0));
            } else {
                frame.getBranch().selectSibling(null);
            }
            this.provider.getControl().setRedraw(false);
            try {
                this.provider.refresh();
            }
            finally {
                this.provider.getControl().setRedraw(true);
            }
            this.provider.setSelection((ISelection)new StructuredSelection((Object)frame));
        }

        @Override
        public void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(selection.size() == 1 && StacktraceView.isFirstInBranchWithSiblings((StacktraceFrame)selection.getFirstElement()));
        }
    }

    private static class StacktraceReducedTreeContentProvider
    extends AbstractStructuredContentProvider
    implements ITreeContentProvider {
        private StacktraceReducedTreeContentProvider() {
        }

        public StacktraceFrame[] getElements(Object inputElement) {
            StacktraceModel.Fork rootFork = (StacktraceModel.Fork)inputElement;
            if (rootFork.getBranchCount() == 1) {
                StacktraceModel.Branch branch = rootFork.getBranch(0);
                return (StacktraceFrame[])Stream.concat(Stream.concat(Stream.of(branch.getFirstFrame()), Stream.of(branch.getTailFrames())), Stream.of(branch.getEndFork().getFirstFrames())).toArray(StacktraceFrame[]::new);
            }
            return rootFork.getFirstFrames();
        }

        public boolean hasChildren(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            return StacktraceView.isFirstInBranchWithSiblings(frame) && frame.getBranch().hasTail();
        }

        public StacktraceFrame[] getChildren(Object parentElement) {
            Stream<Object> children = Stream.empty();
            StacktraceFrame frame = (StacktraceFrame)parentElement;
            if (StacktraceView.isFirstInBranchWithSiblings(frame)) {
                children = Stream.concat(Stream.of(frame.getBranch().getTailFrames()), Stream.of(frame.getBranch().getEndFork().getFirstFrames()));
            }
            return (StacktraceFrame[])children.toArray(StacktraceFrame[]::new);
        }

        public StacktraceFrame getParent(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            if (StacktraceView.isFirstInBranchWithSiblings(frame) || frame.getBranch().getParentFork().getBranchCount() == 1) {
                StacktraceModel.Branch parentBranch = frame.getBranch().getParentFork().getParentBranch();
                return parentBranch == null ? null : parentBranch.getFirstFrame();
            }
            return frame.getBranch().getFirstFrame();
        }
    }

    private static class StacktraceTreeContentProvider
    extends AbstractStructuredContentProvider
    implements ITreeContentProvider {
        private StacktraceTreeContentProvider() {
        }

        public StacktraceFrame[] getElements(Object inputElement) {
            return ((StacktraceModel.Fork)inputElement).getFirstFrames();
        }

        public boolean hasChildren(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            return !StacktraceView.isLastFrame(frame);
        }

        public StacktraceFrame[] getChildren(Object parentElement) {
            StacktraceFrame frame = (StacktraceFrame)parentElement;
            StacktraceFrame[] tailFrames = frame.getBranch().getTailFrames();
            if (frame.getIndexInBranch() == tailFrames.length) {
                return frame.getBranch().getEndFork().getFirstFrames();
            }
            return new StacktraceFrame[]{tailFrames[frame.getIndexInBranch()]};
        }

        public StacktraceFrame getParent(Object element) {
            StacktraceFrame frame = (StacktraceFrame)element;
            int parentIndexInBranch = frame.getIndexInBranch() - 1;
            if (parentIndexInBranch > 0) {
                return frame.getBranch().getTailFrames()[parentIndexInBranch - 1];
            }
            if (parentIndexInBranch == 0) {
                return frame.getBranch().getFirstFrame();
            }
            StacktraceModel.Branch parentBranch = frame.getBranch().getParentFork().getParentBranch();
            return parentBranch == null ? null : parentBranch.getLastFrame();
        }
    }

    private static class StacktraceViewToolTipSupport
    extends ColumnViewerToolTipSupport {
        StacktraceViewToolTipSupport(ColumnViewer viewer) {
            super(viewer, 2, false);
        }

        protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
            FormText formText = CompositeToolkit.createInfoFormText((Composite)parent);
            formText.setImage(StacktraceView.COUNT_IMG_KEY, SWTColorToolkit.getColorThumbnail((RGB)COUNT_COLOR.getRGB()));
            formText.setImage(StacktraceView.SIBLINGS_IMG_KEY, SWTColorToolkit.getColorThumbnail((RGB)SIBLINGS_COUNT_COLOR.getRGB()));
            formText.setText(this.getText(event), true, false);
            return formText;
        }
    }

    private static class ViewerAction
    extends Action
    implements ISelectionChangedListener {
        protected StructuredViewer provider = null;

        public ViewerAction(String text) {
            super(text);
            this.setViewer(null);
            this.setEnabled(false);
        }

        public void setViewer(StructuredViewer provider) {
            this.provider = provider;
            if (provider != null) {
                provider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionChanged(this.getStructuredSelection());
            } else {
                this.setEnabled(false);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.selectionChanged((IStructuredSelection)selection);
            }
        }

        protected void selectionChanged(IStructuredSelection selection) {
        }

        protected IStructuredSelection getStructuredSelection() {
            ISelection selection;
            if (this.provider != null && (selection = this.provider.getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            return new StructuredSelection();
        }
    }
}

