/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.flameview.views;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.flameview.MessagesUtils;
import org.openjdk.jmc.flightrecorder.serializers.json.FlameGraphJsonSerializer;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.common.AttributeSelection;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class FlameGraphView
extends ViewPart
implements ISelectionListener {
    private static final String DIR_ICONS = "icons/";
    private static final String PLUGIN_ID = "org.openjdk.jmc.flightrecorder.flameview";
    private static final String TABLE_COLUMN_COUNT = MessagesUtils.getFlameviewMessage("FLAMEVIEW_SELECT_HTML_TABLE_COUNT", new Object[0]);
    private static final String TABLE_COLUMN_EVENT_TYPE = MessagesUtils.getFlameviewMessage("FLAMEVIEW_SELECT_HTML_TABLE_EVENT_TYPE", new Object[0]);
    private static final String TOOLTIP_PACKAGE = MessagesUtils.getFlameviewMessage("FLAMEVIEW_SELECT_HTML_TOOLTIP_PACKAGE", new Object[0]);
    private static final String TOOLTIP_SAMPLES = MessagesUtils.getFlameviewMessage("FLAMEVIEW_SELECT_HTML_TOOLTIP_SAMPLES", new Object[0]);
    private static final String TOOLTIP_DESCRIPTION = MessagesUtils.getFlameviewMessage("FLAMEVIEW_SELECT_HTML_TOOLTIP_DESCRIPTION", new Object[0]);
    private static final String ATTRIBUTE_SELECTION_ID = "AttributeSelection";
    private static final String ATTRIBUTE_SELECTION_SEP_ID = "AttrSelectionSep";
    private static final String HTML_PAGE;
    private static final int MODEL_EXECUTOR_THREADS_NUMBER = 3;
    private static final ExecutorService MODEL_EXECUTOR;
    private FrameSeparator frameSeparator;
    private Browser browser;
    private SashForm container;
    private GroupByAction[] groupByActions;
    private GroupByFlameviewAction[] groupByFlameviewActions;
    private ExportAction[] exportActions;
    private boolean threadRootAtTop = true;
    private boolean icicleViewActive = true;
    private IItemCollection currentItems;
    private volatile ModelState modelState = ModelState.NONE;
    private ModelRebuildRunnable modelRebuildRunnable;
    private IAttribute<IQuantity> currentAttribute;
    private AttributeSelection attributeSelection;
    private IToolBarManager toolBar;

    static {
        String cssD3Flamegraph = "jslibs/d3-flamegraph.css";
        String jsD3V6 = "jslibs/d3.v6.min.js";
        String jsD3Tip = "jslibs/d3-flamegraph-tooltip.js";
        String jsD3FlameGraph = "jslibs/d3-flamegraph.js";
        String jsFlameviewName = "flameview.js";
        String cssFlameview = "flameview.css";
        String jsD3 = FlameGraphView.loadLibraries(jsD3V6, jsD3FlameGraph, jsD3Tip);
        String styleheets = FlameGraphView.loadLibraries(cssD3Flamegraph, cssFlameview);
        String jsFlameviewColoring = FlameGraphView.fileContent(jsFlameviewName);
        String magnifierIcon = FlameGraphView.getIconBase64("magnifier.png");
        HTML_PAGE = String.format(FlameGraphView.fileContent("page.template"), styleheets, magnifierIcon, jsD3, jsFlameviewColoring);
        MODEL_EXECUTOR = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private ThreadGroup group = new ThreadGroup("FlameGraphModelCalculationGroup");
            private AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, "FlameGraphModelCalculation-" + this.counter.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    private void createAttributeSelection(String attrName, Collection<Pair<String, IAttribute<IQuantity>>> items) {
        if (this.attributeSelection != null) {
            this.toolBar.remove(this.attributeSelection.getId());
        }
        this.attributeSelection = new AttributeSelection(items, attrName, this::getCurrentAttribute, this::setCurrentAttribute, () -> this.triggerRebuildTask(this.currentItems));
        this.toolBar.insertAfter(ATTRIBUTE_SELECTION_SEP_ID, (IAction)this.attributeSelection);
        this.toolBar.update(true);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        this.groupByActions = new GroupByAction[]{new GroupByAction(GroupActionType.LAST_FRAME), new GroupByAction(GroupActionType.THREAD_ROOT)};
        this.groupByFlameviewActions = new GroupByFlameviewAction[]{new GroupByFlameviewAction(GroupActionType.FLAME_GRAPH), new GroupByFlameviewAction(GroupActionType.ICICLE_GRAPH)};
        this.exportActions = new ExportAction[]{new ExportAction(ExportActionType.SAVE_AS), new ExportAction(ExportActionType.PRINT)};
        Stream.of(this.exportActions).forEach(action -> action.setEnabled(false));
        IMenuManager siteMenu = site.getActionBars().getMenuManager();
        siteMenu.add((IContributionItem)new Separator("group.top"));
        siteMenu.add((IContributionItem)new Separator("group.viewerSetup"));
        this.toolBar = site.getActionBars().getToolBarManager();
        Stream.of(this.groupByFlameviewActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator());
        Stream.of(this.groupByActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator());
        Stream.of(this.exportActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator(ATTRIBUTE_SELECTION_SEP_ID));
        this.createAttributeSelection(null, Collections.emptyList());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private IAttribute<IQuantity> getCurrentAttribute() {
        return this.currentAttribute;
    }

    private void setCurrentAttribute(IAttribute<IQuantity> attr) {
        this.currentAttribute = attr;
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.container = new SashForm(parent, 256);
        this.browser = new Browser((Composite)this.container, 0);
        this.container.setMaximizedControl((Control)this.browser);
        this.browser.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                e.doit = false;
            }
        });
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void saveState(IMemento memento) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IItemCollection items = (IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class);
            if (items == null) {
                this.triggerRebuildTask(ItemCollectionToolkit.build(Stream.empty()));
            } else if (!items.equals(this.currentItems)) {
                this.triggerRebuildTask(items);
            }
        }
    }

    private void triggerRebuildTask(IItemCollection items) {
        if (this.modelRebuildRunnable != null) {
            this.modelRebuildRunnable.setInvalid();
        }
        this.currentItems = items;
        this.modelState = ModelState.NOT_STARTED;
        this.modelRebuildRunnable = new ModelRebuildRunnable(this, items, this.currentAttribute);
        if (!this.modelRebuildRunnable.isInvalid) {
            MODEL_EXECUTOR.execute(this.modelRebuildRunnable);
        }
    }

    private void setModel(IItemCollection items, String json) {
        if (ModelState.FINISHED.equals((Object)this.modelState) && items.equals(this.currentItems) && !this.browser.isDisposed()) {
            this.setViewerInput(json);
        }
    }

    private void setViewerInput(final String json) {
        Stream.of(this.exportActions).forEach(action -> action.setEnabled(false));
        this.browser.setText(HTML_PAGE);
        this.browser.addListener(11, event -> this.browser.execute("resizeFlameGraph();"));
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){
            private boolean loaded = false;

            public void changed(ProgressEvent event) {
                if (this.loaded) {
                    FlameGraphView.this.browser.removeProgressListener((ProgressListener)this);
                }
            }

            public void completed(ProgressEvent event) {
                FlameGraphView.this.browser.execute(String.format("configureTooltipText('%s', '%s', '%s', '%s', '%s');", TABLE_COLUMN_COUNT, TABLE_COLUMN_EVENT_TYPE, TOOLTIP_PACKAGE, TOOLTIP_SAMPLES, TOOLTIP_DESCRIPTION));
                FlameGraphView.this.browser.execute(String.format("processGraph(%s, %s);", json, FlameGraphView.this.icicleViewActive));
                Stream.of(FlameGraphView.this.exportActions).forEach(action -> action.setEnabled(true));
                this.loaded = true;
            }
        });
    }

    private void saveFlameGraph() {
        final CompletableFuture future = new CompletableFuture();
        String[] destination = new String[2];
        DisplayToolkit.inDisplayThread().execute(() -> {
            String type;
            FileDialog fd = new FileDialog(this.browser.getShell(), 8192);
            fd.setText(MessagesUtils.getFlameviewMessage("FLAMEVIEW_SAVE_FLAME_GRAPH_AS", new Object[0]));
            fd.setFilterNames(new String[]{MessagesUtils.getFlameviewMessage("FLAMEVIEW_JPEG_IMAGE", new Object[0]), MessagesUtils.getFlameviewMessage("FLAMEVIEW_PNG_IMAGE", new Object[0])});
            fd.setFilterExtensions(new String[]{"*.jpg", "*.png"});
            fd.setFileName("flame_graph");
            fd.setOverwrite(true);
            if (fd.open() == null) {
                future.cancel(true);
                return;
            }
            String fileName = fd.getFileName().toLowerCase();
            if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
                type = "image/jpeg";
            } else if (fileName.endsWith(".png")) {
                type = "image/png";
            } else {
                future.completeExceptionally(new UnsupportedOperationException("Unsupported image format"));
                return;
            }
            stringArray[0] = fd.getFilterPath();
            stringArray[1] = fd.getFileName();
            String callback = "_saveFlameGraphCallback";
            new BrowserFunction(this.browser, callback){

                public Object function(Object[] arguments) {
                    if (arguments.length > 1) {
                        future.completeExceptionally(new RuntimeException((String)arguments[1]));
                        return null;
                    }
                    future.complete((String)arguments[0]);
                    super.dispose();
                    return null;
                }
            };
            this.browser.execute("exportFlameGraph('" + type + "', '" + callback + "')");
        });
        try {
            String b64 = (String)future.get();
            byte[] bytes = Base64.getDecoder().decode(b64);
            FileOutputStream fos = new FileOutputStream(new File(destination[0], destination[1]));
            fos.write(bytes);
            fos.close();
        }
        catch (CancellationException cancellationException) {
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to save flame graph", e);
        }
    }

    private static String loadLibraries(String ... libs) {
        if (libs == null || libs.length == 0) {
            return "";
        }
        return Stream.of(libs).map(FlameGraphView::fileContent).collect(Collectors.joining("\n"));
    }

    private static String fileContent(String fileName) {
        try {
            return StringToolkit.readString((InputStream)FlameGraphView.class.getClassLoader().getResourceAsStream(fileName));
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not load script \"{0}\",\"{1}\"", fileName, e.getMessage()));
            return "";
        }
    }

    private static ImageDescriptor flameviewImageDescriptor(String iconName) {
        return ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)(DIR_ICONS + iconName)).orElse(null);
    }

    private static String getIconBase64(String iconName) {
        Image image = FlightRecorderUI.getDefault().getImage(iconName);
        if (image == null) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save((OutputStream)baos, 5);
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    static /* synthetic */ ImageDescriptor access$0(String string) {
        return FlameGraphView.flameviewImageDescriptor(string);
    }

    static /* synthetic */ void access$8(FlameGraphView flameGraphView) {
        flameGraphView.saveFlameGraph();
    }

    private class ExportAction
    extends Action {
        private final ExportActionType actionType;

        private ExportAction(ExportActionType actionType) {
            super(actionType.message, actionType.action);
            this.actionType = actionType;
            this.setToolTipText(actionType.message);
            this.setImageDescriptor(actionType.imageDescriptor);
            this.setDisabledImageDescriptor(actionType.disabledImageDescriptor);
        }

        public void run() {
            switch (this.actionType) {
                case SAVE_AS: {
                    Executors.newSingleThreadExecutor().execute(() -> FlameGraphView.access$8(FlameGraphView.this));
                    break;
                }
                case PRINT: {
                    FlameGraphView.this.browser.execute("window.print()");
                }
            }
        }
    }

    private static enum ExportActionType {
        SAVE_AS(MessagesUtils.getFlameviewMessage("FLAMEVIEW_SAVE_AS", new Object[0]), 1, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT_DISABLED")),
        PRINT(MessagesUtils.getFlameviewMessage("FLAMEVIEW_PRINT", new Object[0]), 1, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_PRINT_EDIT"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));

        private final String message;
        private final int action;
        private final ImageDescriptor imageDescriptor;
        private final ImageDescriptor disabledImageDescriptor;

        private ExportActionType(String message, int action, ImageDescriptor imageDescriptor, ImageDescriptor disabledImageDescriptor) {
            this.message = message;
            this.action = action;
            this.imageDescriptor = imageDescriptor;
            this.disabledImageDescriptor = disabledImageDescriptor;
        }
    }

    private static enum GroupActionType {
        THREAD_ROOT(Messages.STACKTRACE_VIEW_THREAD_ROOT, 8, CoreImages.THREAD),
        LAST_FRAME(Messages.STACKTRACE_VIEW_LAST_FRAME, 8, CoreImages.METHOD_NON_OPTIMIZED),
        ICICLE_GRAPH(MessagesUtils.getFlameviewMessage("FLAMEVIEW_ICICLE_GRAPH", new Object[0]), 8, FlameGraphView.access$0("icicleflip.png")),
        FLAME_GRAPH(MessagesUtils.getFlameviewMessage("FLAMEVIEW_FLAME_GRAPH", new Object[0]), 8, FlameGraphView.access$0("flameflip.png"));

        private final String message;
        private final int action;
        private final ImageDescriptor imageDescriptor;

        private GroupActionType(String message, int action, ImageDescriptor imageDescriptor) {
            this.message = message;
            this.action = action;
            this.imageDescriptor = imageDescriptor;
        }
    }

    private class GroupByAction
    extends Action {
        private final GroupActionType actionType;

        GroupByAction(GroupActionType actionType) {
            super(actionType.message, actionType.action);
            this.actionType = actionType;
            this.setToolTipText(actionType.message);
            this.setImageDescriptor(actionType.imageDescriptor);
            this.setChecked(GroupActionType.THREAD_ROOT.equals((Object)actionType) == FlameGraphView.this.threadRootAtTop);
        }

        public void run() {
            boolean newValue;
            boolean bl = newValue = this.isChecked() == GroupActionType.THREAD_ROOT.equals((Object)this.actionType);
            if (newValue != FlameGraphView.this.threadRootAtTop) {
                FlameGraphView.this.threadRootAtTop = newValue;
                FlameGraphView.this.triggerRebuildTask(FlameGraphView.this.currentItems);
            }
        }
    }

    private class GroupByFlameviewAction
    extends Action {
        private final GroupActionType actionType;

        GroupByFlameviewAction(GroupActionType actionType) {
            super(actionType.message, actionType.action);
            this.actionType = actionType;
            this.setToolTipText(actionType.message);
            this.setImageDescriptor(actionType.imageDescriptor);
            this.setChecked(GroupActionType.ICICLE_GRAPH.equals((Object)actionType) == FlameGraphView.this.icicleViewActive);
        }

        public void run() {
            FlameGraphView.this.icicleViewActive = GroupActionType.ICICLE_GRAPH.equals((Object)this.actionType);
            FlameGraphView.this.browser.execute(String.format("icicleView(%s);", FlameGraphView.this.icicleViewActive));
        }
    }

    private static class ModelRebuildRunnable
    implements Runnable {
        private final FlameGraphView view;
        private final IItemCollection items;
        private final IAttribute<IQuantity> attribute;
        private volatile boolean isInvalid;

        private ModelRebuildRunnable(FlameGraphView view, IItemCollection items, IAttribute<IQuantity> attribute) {
            this.view = view;
            this.items = items;
            this.attribute = attribute;
        }

        private void setInvalid() {
            this.isInvalid = true;
        }

        @Override
        public void run() {
            this.view.modelState = ModelState.STARTED;
            if (this.isInvalid) {
                return;
            }
            IItemCollection filteredItems = this.items;
            if (this.attribute != null) {
                filteredItems = filteredItems.apply(ItemFilters.hasAttribute(this.attribute));
            }
            StacktraceTreeModel treeModel = new StacktraceTreeModel(filteredItems, this.view.frameSeparator, !this.view.threadRootAtTop, this.attribute);
            if (this.isInvalid) {
                return;
            }
            String flameGraphJson = FlameGraphJsonSerializer.toJson((StacktraceTreeModel)treeModel);
            if (this.isInvalid) {
                return;
            }
            this.view.modelState = ModelState.FINISHED;
            DisplayToolkit.inDisplayThread().execute(() -> {
                this.view.setModel(this.items, flameGraphJson);
                List attrList = AttributeSelection.extractAttributes((IItemCollection)this.items);
                String attrName = this.attribute != null ? this.attribute.getName() : null;
                this.view.createAttributeSelection(attrName, attrList);
            });
        }
    }

    private static enum ModelState {
        NOT_STARTED,
        STARTED,
        FINISHED,
        NONE;

    }
}

