/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.ui.views;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.ui.common.util.Environment;

public abstract class SelectionCanvas
extends Canvas {
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private Rectangle selectable;
    private ImageData m_imageDataSWT;
    private BufferedImage m_imageAWT;
    private Graphics2D m_graphicsAWT;
    private int lastDesiredWidth;
    protected double xScale;
    protected double yScale;

    public SelectionCanvas(Composite parent) {
        super(parent, 262144);
        this.xScale = (double)Display.getDefault().getDPI().x / Environment.getNormalDPI();
        this.yScale = (double)Display.getDefault().getDPI().y / Environment.getNormalDPI();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SelectionCanvas.this.paint(e.gc);
            }
        });
        ChartSelectionListener chs = new ChartSelectionListener();
        this.addMouseMoveListener(chs);
        this.addMouseListener((MouseListener)chs);
    }

    public void paint(GC gc) {
        org.eclipse.swt.graphics.Rectangle rect = this.getClientArea();
        if (this.m_imageDataSWT == null || this.lastDesiredWidth != rect.width || this.m_imageDataSWT.height != rect.height) {
            this.lastDesiredWidth = rect.width;
            int width = rect.width;
            while (((width * 24 + 7) / 8 + 2) / 3 * 3 % 4 != 0) {
                ++width;
            }
            this.m_imageAWT = new BufferedImage(width, rect.height, 5);
            PaletteData vpPalette = new PaletteData(255, 65280, 0xFF0000);
            int scanlinePad = 3;
            byte[] byteData = ((DataBufferByte)this.m_imageAWT.getRaster().getDataBuffer()).getData();
            this.m_graphicsAWT = this.m_imageAWT.createGraphics();
            AffineTransform defaultTransform = this.m_graphicsAWT.getDeviceConfiguration().getDefaultTransform();
            defaultTransform.scale(this.xScale, this.yScale);
            this.m_graphicsAWT.setTransform(defaultTransform);
            this.m_imageDataSWT = new ImageData(width, rect.height, 24, vpPalette, scanlinePad, byteData);
        }
        int adjustedWidth = (int)Math.round((double)rect.width / this.xScale);
        int adjustedHeight = (int)Math.round((double)rect.height / this.yScale);
        this.selectable = this.render(this.m_graphicsAWT, new Rectangle(adjustedWidth, adjustedHeight));
        if (this.selectable != null && this.selectionStart >= 0 && this.selectionEnd >= 0) {
            this.m_graphicsAWT.setColor(Color.WHITE);
            this.m_graphicsAWT.setXORMode(Color.BLACK);
            int drawSelFrom = Math.max(this.selectable.x, Math.min(this.selectionStart, this.selectionEnd));
            int drawSelTo = Math.min(this.selectable.x + this.selectable.width, Math.max(this.selectionStart, this.selectionEnd));
            int selectionWidth = Math.max(0, drawSelTo - drawSelFrom);
            this.m_graphicsAWT.fillRect(drawSelFrom, this.selectable.y, selectionWidth, this.selectable.height);
            this.m_graphicsAWT.setPaintMode();
        }
        Image img = new Image(gc.getDevice(), this.m_imageDataSWT);
        gc.drawImage(img, rect.x, rect.y);
        img.dispose();
    }

    protected Point translateDisplayToImageCoordinates(int x, int y) {
        int xImage = (int)Math.round((double)x / this.xScale);
        int yImage = (int)Math.round((double)y / this.yScale);
        return new Point(xImage, yImage);
    }

    protected int translateDisplayToImageXCoordinate(int x) {
        return (int)Math.round((double)x / this.xScale);
    }

    protected abstract Rectangle render(Graphics2D var1, Rectangle var2);

    protected abstract void selectionStart();

    protected abstract void selectionComplete(double var1, double var3);

    private class ChartSelectionListener
    extends MouseAdapter
    implements MouseMoveListener {
        private ChartSelectionListener() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0 && SelectionCanvas.this.selectable != null) {
                SelectionCanvas.this.selectionStart = SelectionCanvas.this.translateDisplayToImageXCoordinate(e.x);
                SelectionCanvas.this.selectionStart();
            }
        }

        public void mouseMove(MouseEvent e) {
            if (SelectionCanvas.this.selectionStart >= 0) {
                SelectionCanvas.this.selectionEnd = SelectionCanvas.this.translateDisplayToImageXCoordinate(e.x);
                SelectionCanvas.this.redraw();
            }
        }

        public void mouseUp(MouseEvent e) {
            if (SelectionCanvas.this.selectionStart >= 0 && e.button == 1) {
                int x = SelectionCanvas.this.translateDisplayToImageXCoordinate(e.x);
                int minLimit = Math.max(0, Math.min(SelectionCanvas.this.selectionStart, x) - ((SelectionCanvas)SelectionCanvas.this).selectable.x);
                int maxLimit = Math.min(((SelectionCanvas)SelectionCanvas.this).selectable.width, Math.max(SelectionCanvas.this.selectionStart, x) - ((SelectionCanvas)SelectionCanvas.this).selectable.x);
                SelectionCanvas.this.selectionStart = -1;
                SelectionCanvas.this.selectionEnd = -1;
                if (maxLimit > minLimit + 2) {
                    SelectionCanvas.this.selectionComplete((double)minLimit / (double)((SelectionCanvas)SelectionCanvas.this).selectable.width, (double)maxLimit / (double)((SelectionCanvas)SelectionCanvas.this).selectable.width);
                }
            }
        }
    }
}

