/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class VMOperationPage
extends AbstractDataPage {
    private static final ItemList.ItemListBuilder LIST = new ItemList.ItemListBuilder();
    private static final ItemHistogram.ItemHistogramBuilder VM_OPERATIONS_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final Color VM_OPERATIONS_COLOR = new Color(0xFF0000);
    private static final Color VM_OPERATIONS_SPAN_COLOR = ColorToolkit.withAlpha((Color)TypeLabelProvider.getColor("jdk.ExecuteVMOperation"), (int)80);
    private int tabFolderIndex = 0;
    private ColumnManager.SelectionState vmOperationsSelection;
    private ColumnManager.SelectionState itemListSelection;
    private IItemFilter vmOperationsHistogramFilter;
    private IItemFilter itemListFilter;
    private IRange<IQuantity> timelineRange;
    private IRange<IQuantity> durationsRange;
    private FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        VM_OPERATIONS_HISTOGRAM.addColumn("maxDuration", Aggregators.max((IAttribute)JfrAttributes.DURATION));
        VM_OPERATIONS_HISTOGRAM.addColumn("totalDuration", Aggregators.sum((IAttribute)JfrAttributes.DURATION));
        VM_OPERATIONS_HISTOGRAM.addColumn("stddev", Aggregators.stddevp((IAttribute)JfrAttributes.DURATION));
        VM_OPERATIONS_HISTOGRAM.addCountColumn();
        LIST.addColumn(JdkAttributes.OPERATION);
        LIST.addColumn(JdkAttributes.BLOCKING);
        LIST.addColumn(JdkAttributes.SAFEPOINT);
        LIST.addColumn(JfrAttributes.START_TIME);
        LIST.addColumn(JfrAttributes.END_TIME);
        LIST.addColumn(JfrAttributes.DURATION);
        LIST.addColumn(JfrAttributes.EVENT_THREAD);
        LIST.addColumn(JdkAttributes.CALLER);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new VMOperationsUi(parent, toolkit, pageContainer, state);
    }

    public VMOperationPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
        this.durationsRange = editor.getRecordingRange();
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.VM_OPERATIONS;
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings("(duration)", Arrays.asList(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(400), null), new TableSettings.ColumnSettings("(duration)", Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings("blocked", Boolean.valueOf(false), Integer.valueOf(70), Boolean.valueOf(false)), new TableSettings.ColumnSettings("safepoint", Boolean.valueOf(false), Integer.valueOf(70), Boolean.valueOf(false)), new TableSettings.ColumnSettings("itemhistogram.count", Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings("(startTime)", Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings("(endTime)", Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false))));
        }
        return new TableSettings(state);
    }

    private static Color getColor(IItem item) {
        return VM_OPERATIONS_SPAN_COLOR;
    }

    static /* synthetic */ Color access$2(IItem iItem) {
        return VMOperationPage.getColor(iItem);
    }

    public static class VMOperationsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.VMOperationPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/jvminformation.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"vm_operations"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new VMOperationPage(dpd, items, editor);
        }
    }

    private class VMOperationsUi
    implements IPageUI {
        private static final String SASH_ELEMENT = "sash";
        private static final String LIST_ELEMENT = "eventList";
        private static final String LIST_FILTER_ELEMENT = "eventListFilter";
        private static final String VM_OPERATIONS_ELEMENT = "vmOperationsTable";
        private static final String VM_OPERATIONS_FILTER_ELEMENT = "vmOperationsFilter";
        private final ChartCanvas timelineCanvas;
        private final ChartCanvas durationCanvas;
        private final ItemHistogram vmOperationsTable;
        private FilterComponent vmOperationsFilter;
        private final ItemList itemList;
        private FilterComponent itemFilter;
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private IItemCollection selectionItems;
        private CTabFolder tabFolder;
        private XYChart durationChart;
        private XYChart timelineChart;
        private IRange<IQuantity> timeRange;
        private FlavorSelector flavorSelector;

        VMOperationsUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, VMOperationPage.this.getName(), VMOperationPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            this.vmOperationsTable = VM_OPERATIONS_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.OPERATION, VMOperationPage.getTableSettings(state.getChild(VM_OPERATIONS_ELEMENT)));
            this.vmOperationsFilter = FilterComponent.createFilterComponent(this.vmOperationsTable, VMOperationPage.this.vmOperationsHistogramFilter, VMOperationPage.this.getDataSource().getItems().apply(JdkFilters.VM_OPERATIONS), pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
            this.vmOperationsTable.getManager().getViewer().addSelectionChangedListener(e -> this.updateDetails());
            this.vmOperationsTable.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(this.vmOperationsTable.getSelection().getItems()));
            MCContextMenuManager vmOperationsHistogramMm = MCContextMenuManager.create((Control)this.vmOperationsTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.vmOperationsTable.getManager(), (MCContextMenuManager)vmOperationsHistogramMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.vmOperationsTable, "VM Operations Histogram Selection", (IContributionManager)vmOperationsHistogramMm);
            vmOperationsHistogramMm.add(this.vmOperationsFilter.getShowFilterAction());
            vmOperationsHistogramMm.add(this.vmOperationsFilter.getShowSearchAction());
            this.vmOperationsFilter.loadState(state.getChild(VM_OPERATIONS_FILTER_ELEMENT));
            this.tabFolder = new CTabFolder((Composite)this.sash, 0);
            toolkit.adapt((Composite)this.tabFolder);
            CTabItem t1 = new CTabItem(this.tabFolder, 0);
            t1.setToolTipText(Messages.VMOPERATION_PAGE_TIMELINE_DESCRIPTION);
            this.timelineCanvas = new ChartCanvas((Composite)this.tabFolder);
            t1.setText(Messages.PAGES_TIMELINE);
            t1.setControl((Control)this.timelineCanvas);
            DataPageToolkit.createChartTimestampTooltip(this.timelineCanvas);
            CTabItem t2 = new CTabItem(this.tabFolder, 0);
            t2.setToolTipText(Messages.VMOPERATION_PAGE_DURATIONS_DESCRIPTION);
            this.durationCanvas = new ChartCanvas((Composite)this.tabFolder);
            t2.setText(Messages.PAGES_DURATIONS);
            t2.setControl((Control)this.durationCanvas);
            DataPageToolkit.createChartTooltip(this.durationCanvas);
            CTabItem t3 = new CTabItem(this.tabFolder, 0);
            t3.setToolTipText(Messages.VMOPERATION_PAGE_EVENT_LOG_DESCRIPTION);
            this.itemList = LIST.buildWithoutBorder((Composite)this.tabFolder, VMOperationPage.getTableSettings(state.getChild(LIST_ELEMENT)));
            this.itemFilter = FilterComponent.createFilterComponent(this.itemList, VMOperationPage.this.itemListFilter, VMOperationPage.this.getDataSource().getItems().apply(JdkFilters.VM_OPERATIONS), pageContainer.getSelectionStore()::getSelections, this::onEventsFilterChange);
            MCContextMenuManager itemListMm = MCContextMenuManager.create((Control)this.itemList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.itemList.getManager(), (MCContextMenuManager)itemListMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.itemList, Messages.VMOperationPage_LOG_SELECTION, (IContributionManager)itemListMm);
            itemListMm.add(this.itemFilter.getShowFilterAction());
            itemListMm.add(this.itemFilter.getShowSearchAction());
            this.itemList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.itemList.getSelection().get())));
            t3.setText(Messages.PAGES_EVENT_LOG);
            t3.setControl((Control)this.itemFilter.getComponent());
            this.itemFilter.loadState(state.getChild(LIST_FILTER_ELEMENT));
            IQuantity max = (IQuantity)this.getItems().getAggregate(JdkAggregators.LONGEST_EVENT);
            max = max == null ? UnitLookup.MILLISECOND.quantity(20L) : max.add((IQuantity)UnitLookup.MILLISECOND.quantity(20L));
            this.durationChart = new XYChart((IQuantity)UnitLookup.MILLISECOND.quantity(0L), max, RendererToolkit.empty(), 180);
            this.durationChart.setVisibleRange((IQuantity)VMOperationPage.this.durationsRange.getStart(), (IQuantity)VMOperationPage.this.durationsRange.getEnd());
            this.durationChart.addVisibleRangeListener(r -> {
                IRange iRange = VMOperationPage.this.durationsRange = r;
            });
            this.timelineChart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 180);
            this.timelineChart.setVisibleRange((IQuantity)VMOperationPage.this.timelineRange.getStart(), (IQuantity)VMOperationPage.this.timelineRange.getEnd());
            this.timelineChart.addVisibleRangeListener(r -> {
                IRange iRange = VMOperationPage.this.timelineRange = r;
            });
            this.tabFolder.setSelection(VMOperationPage.this.tabFolderIndex);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, JdkQueries.VM_OPERATIONS.getFilter(), VMOperationPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onShow, VMOperationPage.this.flavorSelectorState);
            VMOperationPage.this.addResultActions(form);
            this.onFilterChange(VMOperationPage.this.vmOperationsHistogramFilter);
            this.onEventsFilterChange(VMOperationPage.this.itemListFilter);
            this.vmOperationsTable.getManager().setSelectionState(VMOperationPage.this.vmOperationsSelection);
            this.itemList.getManager().setSelectionState(VMOperationPage.this.itemListSelection);
        }

        private void onFilterChange(IItemFilter filter) {
            this.vmOperationsFilter.filterChangeHelper(filter, this.vmOperationsTable, VMOperationPage.this.getDataSource().getItems().apply(JdkFilters.VM_OPERATIONS));
            VMOperationPage.this.vmOperationsHistogramFilter = filter;
        }

        private void onEventsFilterChange(IItemFilter filter) {
            this.itemFilter.filterChangeHelper(filter, this.itemList, VMOperationPage.this.getDataSource().getItems().apply(JdkFilters.VM_OPERATIONS));
            VMOperationPage.this.itemListFilter = filter;
        }

        public void saveTo(IWritableState state) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)state.createChild(SASH_ELEMENT));
            this.vmOperationsTable.getManager().getSettings().saveState(state.createChild(VM_OPERATIONS_ELEMENT));
            this.itemList.getManager().getSettings().saveState(state.createChild(LIST_ELEMENT));
            this.vmOperationsFilter.saveState(state.createChild(VM_OPERATIONS_FILTER_ELEMENT));
            this.itemFilter.saveState(state.createChild(LIST_FILTER_ELEMENT));
            this.saveToLocal();
        }

        private void saveToLocal() {
            VMOperationPage.this.vmOperationsSelection = this.vmOperationsTable.getManager().getSelectionState();
            VMOperationPage.this.itemListSelection = this.itemList.getManager().getSelectionState();
            VMOperationPage.this.tabFolderIndex = this.tabFolder.getSelectionIndex();
            VMOperationPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items;
            this.timeRange = timeRange;
            this.vmOperationsTable.show(this.getItems());
            XYChart timelineChart = new XYChart(timeRange, RendererToolkit.empty(), 180);
            DataPageToolkit.setChart(this.timelineCanvas, timelineChart, this.pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.pageContainer.getSelectionStore(), timelineChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.VMOperationPage_TIMELINE_SELECTION, (IContributionManager)this.timelineCanvas.getContextMenu());
            this.updateDetails();
        }

        private void onShow(Boolean show) {
            IRange<IQuantity> range = show != false ? this.timeRange : this.pageContainer.getRecordingRange();
            this.timelineChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.updateDetails();
        }

        private IItemCollection getItems() {
            return this.selectionItems != null ? this.selectionItems.apply(JdkFilters.VM_OPERATIONS) : VMOperationPage.this.getDataSource().getItems().apply(JdkFilters.VM_OPERATIONS);
        }

        private void updateDetails() {
            ItemHistogram.HistogramSelection selection = this.vmOperationsTable.getSelection();
            IItemCollection selectedItems = selection.getRowCount() == 0 ? this.getItems() : selection.getItems();
            ArrayList<IXDataRenderer> timelineRows = new ArrayList<IXDataRenderer>();
            ArrayList<ItemRow> durationRows = new ArrayList<ItemRow>();
            timelineRows.add(DataPageToolkit.buildSizeRow(Messages.VMOperationPage_ROW_VM_OPERATIONS, JdkAggregators.VM_OPERATION_DURATION.getDescription(), selectedItems, JdkAggregators.VM_OPERATION_DURATION, VM_OPERATIONS_COLOR, (AWTChartToolkit.IColorProvider<IItem>)((AWTChartToolkit.IColorProvider)VMOperationPage::access$2)));
            durationRows.add(DataPageToolkit.buildDurationHistogram(Messages.VMOperationPage_ROW_VM_OPERATIONS, JdkAggregators.VM_OPERATION_COUNT.getDescription(), selectedItems, JdkAggregators.VM_OPERATION_COUNT, VM_OPERATIONS_COLOR));
            this.timelineChart.setRendererRoot(RendererToolkit.uniformRows(timelineRows));
            DataPageToolkit.setChart(this.timelineCanvas, this.timelineChart, this.pageContainer::showSelection);
            this.durationChart.setRendererRoot(RendererToolkit.uniformRows(durationRows));
            this.durationCanvas.setSelectionListener(() -> this.pageContainer.showSelection(ItemRow.getSelection(this.durationChart, (ICanonicalAccessorFactory<IQuantity>)JfrAttributes.DURATION)));
            this.durationCanvas.setChart(this.durationChart);
            SelectionStoreActionToolkit.addSelectionStoreActions(this.pageContainer.getSelectionStore(), this.durationChart, (IAttribute<IQuantity>)JfrAttributes.DURATION, Messages.VMOperationPage_DURATION_SELECTION, (IContributionManager)this.durationCanvas.getContextMenu());
            this.itemList.show(selectedItems);
        }
    }
}

