/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.internal;

import java.util.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.rjmx.triggers.IValueEvaluator;
import org.openjdk.jmc.rjmx.triggers.internal.Messages;
import org.openjdk.jmc.rjmx.triggers.internal.ValueEvaluationException;
import org.w3c.dom.Element;

public final class ValueEvaluatorNumberMax
implements IValueEvaluator {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.triggers");
    private static final String XML_ELEMENT_MAXVALUE = "maxvalue";
    private static final String XML_ELEMENT_CONTENTTYPE = "contenttype";
    private IQuantity m_max;

    public ValueEvaluatorNumberMax() {
    }

    public ValueEvaluatorNumberMax(IQuantity max) {
        this.m_max = max;
    }

    @Override
    public boolean triggerOn(Object val) throws Exception {
        if (!(val instanceof IQuantity)) {
            String logMessage = "ValueEvaluatorNumberMax: " + val + " does not have a content type set";
            LOGGER.info(logMessage);
            throw new ValueEvaluationException(logMessage, NLS.bind((String)Messages.ValueEvaluatorNumber_VALUE_NOT_A_QUANTITY, (Object)val));
        }
        return this.triggerOn((IQuantity)val);
    }

    private boolean triggerOn(IQuantity val) throws Exception {
        if (!val.getUnit().getContentType().equals(this.m_max.getUnit().getContentType())) {
            String logMessage = "ValueEvaluatorNumberMax: " + val.persistableString() + " is not of the same content type as limit " + this.m_max.persistableString();
            LOGGER.info(logMessage);
            throw new ValueEvaluationException(logMessage, NLS.bind((String)Messages.ValueEvaluatorNumber_VALUE_NOT_OF_THE_SAME_TYPE, (Object)val.displayUsing("exact"), (Object)this.m_max.displayUsing("exact")));
        }
        boolean result = val.compareTo((Object)this.m_max) > 0;
        LOGGER.info("ValueEvaluatorNumberMax: " + val.persistableString() + " > " + this.m_max.persistableString() + " = " + result);
        return result;
    }

    public String toString() {
        return "value > " + this.m_max.persistableString();
    }

    public IQuantity getMax() {
        return this.m_max;
    }

    public void setMax(IQuantity maxValue) {
        this.m_max = maxValue;
    }

    @Override
    public void initializeEvaluatorFromXml(Element node) {
        ContentType contentType = UnitLookup.getContentType((String)XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_CONTENTTYPE, (String)""));
        if (!(contentType instanceof KindOfQuantity)) {
            contentType = UnitLookup.NUMBER;
        }
        String persistedQuantity = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_MAXVALUE, (String)"0");
        try {
            this.setMax((IQuantity)((KindOfQuantity)contentType).parsePersisted(persistedQuantity));
        }
        catch (QuantityConversionException e) {
            LOGGER.warning(e.getMessage());
            this.setMax((IQuantity)((KindOfQuantity)contentType).getDefaultUnit().quantity(0L));
        }
    }

    @Override
    public void exportEvaluatorToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_CONTENTTYPE, (String)this.getMax().getUnit().getContentType().getIdentifier());
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_MAXVALUE, (String)this.getMax().persistableString());
    }

    @Override
    public String getOperatorString() {
        return ">";
    }

    @Override
    public String getEvaluationConditionString() {
        return "> " + this.m_max.displayUsing("exact");
    }
}

