/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ProcessStartedRule
implements IRule {
    private static final String PROCESS_STARTED_RESULT_ID = "ProcessStarted";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ProcessStart", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> PROCESS_STARTED_COUNT = new TypedResult("processesStarted", "Processes Started", "The number of processes started.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(PROCESS_STARTED_COUNT);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemCollection processStartEvents = items.apply(ItemFilters.type((String)"jdk.ProcessStart"));
        if (!processStartEvents.hasItems()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("ProcessStartedRule_TEXT_OK")).build();
        }
        IQuantity processStartedCount = (IQuantity)processStartEvents.getAggregate(Aggregators.count());
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("ProcessStartedRule_TEXT_INFO")).addResult(PROCESS_STARTED_COUNT, (Object)processStartedCount).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ProcessStartedRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return PROCESS_STARTED_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ProcessStartedRule_RULE_NAME");
    }

    public String getTopic() {
        return "processes";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

