/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.report;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.ExceptionToolkit;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.report.JfrReportPermission;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JfrRulesReport {
    private static final Map<String, String> TRANSFORMS = new LinkedHashMap<String, String>();
    private static final JfrReportPermission OVERRIDE_PERMISSION = new JfrReportPermission("override");

    private static void checkAccess(JfrReportPermission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    private static void checkOverrideAccess() throws SecurityException {
        JfrRulesReport.checkAccess(OVERRIDE_PERMISSION);
    }

    public static void main(String[] args) throws ParserConfigurationException, TransformerException {
        if (args.length == 0) {
            System.out.println("Enter one or more JDK Flight Recorder file names as arguments to this program.");
            System.out.println();
            System.out.println("Optional arguments:");
            System.out.println();
            System.out.println(" -format <format>");
            System.out.println("    Selects an output format. Available formats are:");
            System.out.println("      xml (default)");
            for (String format : TRANSFORMS.keySet()) {
                System.out.println("      " + format);
            }
            System.out.println();
            System.out.println(" -verbose");
            System.out.println("    Verbose output (including all events from rules).");
            System.out.println();
            System.out.println(" -min <severity>");
            System.out.println("    Minimum result severity to include in report.");
            System.out.println("    ok (default), info, or warning");
            System.out.println();
            System.out.println(" -override");
            System.out.println("    Allows overriding the default templates by looking for resources in the context loader.");
            return;
        }
        boolean verbose = false;
        boolean override = false;
        String formatName = "xml";
        Severity minSeverity = Severity.OK;
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-format")) {
                if (i >= args.length - 1) {
                    System.out.println("-format requires an output format argument, e.g. html");
                    return;
                }
                formatName = args[++i].toLowerCase(Locale.ENGLISH);
                continue;
            }
            if (args[i].equalsIgnoreCase("-min")) {
                String minString;
                if (i >= args.length - 1) {
                    System.out.println("-min requires an output format argument, e.g. ok");
                    return;
                }
                if ((minString = args[++i]).equalsIgnoreCase("ok")) {
                    minSeverity = Severity.OK;
                    continue;
                }
                if (minString.equalsIgnoreCase("info")) {
                    minSeverity = Severity.INFO;
                    continue;
                }
                if (minString.equalsIgnoreCase("warning")) {
                    minSeverity = Severity.WARNING;
                    continue;
                }
                System.out.println("Unrecognized value of -min");
                return;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-override")) {
                override = true;
                continue;
            }
            fileNames.add(args[i]);
        }
        JfrRulesReport.printReport(formatName, minSeverity, verbose, override, fileNames.toArray(new String[fileNames.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printReport(String formatName, Severity minSeverity, boolean verbose, boolean override, String ... fileNames) throws ParserConfigurationException, TransformerException {
        InputStream xsltResourceStream;
        block9: {
            xsltResourceStream = null;
            if (formatName == null || formatName.equals("xml")) break block9;
            String xsltResourceName = TRANSFORMS.get(formatName);
            if (xsltResourceName != null) {
                if (override) {
                    JfrRulesReport.checkOverrideAccess();
                    xsltResourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltResourceName);
                } else {
                    xsltResourceStream = JfrRulesReport.class.getClassLoader().getResourceAsStream(xsltResourceName);
                }
            }
            if (xsltResourceStream != null) break block9;
            System.out.println("Format not available: " + formatName);
            IOToolkit.closeSilently((Closeable)xsltResourceStream);
            return;
        }
        try {
            Transformer transformer;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("reportcollection");
            doc.appendChild(rootElement);
            for (String fileName : fileNames) {
                JfrRulesReport.addReport(fileName, minSeverity, verbose, rootElement);
            }
            TransformerFactory transformerFactory = XmlToolkit.createTransformerFactory();
            if (xsltResourceStream != null) {
                StreamSource xsltSource = new StreamSource(xsltResourceStream);
                transformer = transformerFactory.newTransformer(xsltSource);
            } else {
                transformer = transformerFactory.newTransformer();
            }
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult console = new StreamResult(System.out);
            transformer.transform(source, console);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(xsltResourceStream);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)xsltResourceStream);
    }

    public static void addReport(String fileName, Severity minSeverity, boolean verbose, Element parent) {
        try {
            File file = new File(fileName);
            Element reportNode = parent.getOwnerDocument().createElement("report");
            parent.appendChild(reportNode);
            reportNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "file", fileName));
            IItemCollection events = null;
            try {
                events = JfrLoaderToolkit.loadEvents((File)file);
            }
            catch (IOException | CouldNotLoadRecordingException e) {
                JfrRulesReport.addError(parent, reportNode, e);
                return;
            }
            Map<IRule, Future<IResult>> resultFutures = RulesToolkit.evaluateParallel(RuleRegistry.getRules(), events, null, 0);
            ArrayList<Map.Entry<IRule, Future<IResult>>> resultFutureList = new ArrayList<Map.Entry<IRule, Future<IResult>>>(resultFutures.entrySet());
            resultFutureList.sort(new Comparator<Map.Entry<IRule, ?>>(){

                @Override
                public int compare(Map.Entry<IRule, ?> o1, Map.Entry<IRule, ?> o2) {
                    return o1.getKey().getId().compareTo(o2.getKey().getId());
                }
            });
            for (Map.Entry entry : resultFutureList) {
                IResult result = null;
                try {
                    result = (IResult)((Future)entry.getValue()).get();
                }
                catch (Throwable t) {
                    Element ruleNode = JfrRulesReport.createRuleNode(parent, reportNode, (IRule)entry.getKey());
                    JfrRulesReport.addError(parent, ruleNode, t);
                    continue;
                }
                if (result == null || result.getSeverity().compareTo(minSeverity) < 0) continue;
                Element ruleNode = JfrRulesReport.createRuleNode(parent, reportNode, result.getRule());
                ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "severity", result.getSeverity().getLocalizedName()));
                IQuantity score = result.getResult(TypedResult.SCORE);
                if (score != null) {
                    ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "score", score.displayUsing("auto")));
                }
                ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "summary", ResultToolkit.populateMessage(result, result.getSummary(), false)));
                if (verbose) {
                    ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "explanation", ResultToolkit.populateMessage(result, result.getExplanation(), false)));
                    ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "solution", ResultToolkit.populateMessage(result, result.getSolution(), false)));
                }
                IItemQuery itemQuery = result.getResult(TypedResult.ITEM_QUERY);
                if (!verbose || itemQuery == null || itemQuery.getAttributes().isEmpty()) continue;
                Element itemSetNode = parent.getOwnerDocument().createElement("itemset");
                ruleNode.appendChild(itemSetNode);
                IItemCollection resultEvents = events.apply(itemQuery.getFilter());
                Collection attributes = itemQuery.getAttributes();
                Element fieldsNode = parent.getOwnerDocument().createElement("fields");
                itemSetNode.appendChild(fieldsNode);
                for (IAttribute attribute : attributes) {
                    Element fieldNode = parent.getOwnerDocument().createElement("field");
                    fieldsNode.appendChild(fieldNode);
                    fieldNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "name", attribute.getName()));
                }
                Element itemsNode = parent.getOwnerDocument().createElement("items");
                itemSetNode.appendChild(itemsNode);
                for (IItemIterable ii : resultEvents) {
                    IType type = ii.getType();
                    ArrayList<IMemberAccessor> accessors = new ArrayList<IMemberAccessor>(attributes.size());
                    for (IAttribute a : attributes) {
                        accessors.add(a.getAccessor(type));
                    }
                    for (IItem item : ii) {
                        Element itemNode = parent.getOwnerDocument().createElement("item");
                        itemsNode.appendChild(itemNode);
                        for (IMemberAccessor a : accessors) {
                            itemNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "value", JfrRulesReport.toString(a.getMember((Object)item))));
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            System.err.println("Got exception when creating report for " + fileName);
            throw t;
        }
    }

    private static String toString(Object member) {
        if (member instanceof IQuantity) {
            return ((IQuantity)member).displayUsing("auto");
        }
        if (member instanceof LabeledIdentifier) {
            return ((LabeledIdentifier)member).getName();
        }
        return String.valueOf(member);
    }

    private static void addError(Element parent, Element reportNode, Throwable t) {
        reportNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "error", ExceptionToolkit.toString((Throwable)t)));
    }

    private static Element createRuleNode(Element parent, Element reportNode, IRule rule) {
        Element ruleNode = parent.getOwnerDocument().createElement("rule");
        reportNode.appendChild(ruleNode);
        ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "id", rule.getId()));
        ruleNode.appendChild(JfrRulesReport.createValueNode(parent.getOwnerDocument(), "name", rule.getName()));
        return ruleNode;
    }

    private static Element createValueNode(Document doc, String name, String value) {
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(value != null ? value : ""));
        return node;
    }

    static {
        TRANSFORMS.put("html", "org/openjdk/jmc/flightrecorder/rules/report/html.xslt");
        TRANSFORMS.put("text", "org/openjdk/jmc/flightrecorder/rules/report/text.xslt");
        TRANSFORMS.put("json", "org/openjdk/jmc/flightrecorder/rules/report/json.xslt");
    }
}

