/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.manager.wizards.EventEditingWizard;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class PresetEditingWizardEventPage
extends BaseWizardPage {
    private final IPreset preset;
    private BaseWizardPage.TableInspector tableInspector;

    protected PresetEditingWizardEventPage(IPreset preset) {
        super(Messages.PresetEditingWizardEventPage_PAGE_NAME);
        this.preset = preset;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.PresetEditingWizardEventPage_MESSAGE_PRESET_EDITING_WIZARD_EVENT_PAGE_TITLE);
        this.setDescription(Messages.PresetEditingWizardEventPage_MESSAGE_PRESET_EDITING_WIZARD_EVENT_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        container.setLayout((Layout)new FillLayout());
        this.createEventTableContainer(container);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
        this.populateUi();
    }

    private Composite createEventTableContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.tableInspector = new BaseWizardPage.TableInspector(container, 63){

            @Override
            protected void addColumns() {
                this.addColumn(Messages.PresetEditingWizardEventPage_LABEL_ID_COLUMN, Messages.PresetEditingWizardEventPage_ID_ID_COLUMN, new EventTableLabelProvider(){

                    @Override
                    protected String doGetText(IEvent event) {
                        return event.getId();
                    }
                });
                this.addColumn(Messages.PresetEditingWizardEventPage_LABEL_NAME_COLUMN, Messages.PresetEditingWizardEventPage_ID_NAME_COLUMN, new EventTableLabelProvider(){

                    @Override
                    protected String doGetText(IEvent event) {
                        return event.getName();
                    }
                });
            }

            @Override
            protected void onAddButtonSelected(IStructuredSelection selection) {
                IEvent event = PresetEditingWizardEventPage.this.preset.createEvent();
                while (PresetEditingWizardEventPage.this.displayWizard(event)) {
                    try {
                        PresetEditingWizardEventPage.this.preset.addEvent(event);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.PresetEditingWizardEventPage_MESSAGE_UNABLE_TO_SAVE_THE_PRESET, (String)e.getMessage())) break;
                    }
                }
                PresetEditingWizardEventPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onEditButtonSelected(IStructuredSelection selection) {
                IEvent original = (IEvent)selection.getFirstElement();
                IEvent workingCopy = original.createWorkingCopy();
                while (PresetEditingWizardEventPage.this.displayWizard(workingCopy)) {
                    try {
                        PresetEditingWizardEventPage.this.preset.updateEvent(original, workingCopy);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.PresetEditingWizardEventPage_MESSAGE_UNABLE_TO_SAVE_THE_PRESET, (String)e.getMessage())) break;
                    }
                }
                PresetEditingWizardEventPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onDuplicateButtonSelected(IStructuredSelection selection) {
                IEvent original = (IEvent)selection.getFirstElement();
                IEvent duplicate = original.createDuplicate();
                PresetEditingWizardEventPage.this.preset.addEvent(duplicate);
                PresetEditingWizardEventPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onRemoveButtonSelected(IStructuredSelection selection) {
                for (Object event : selection) {
                    PresetEditingWizardEventPage.this.preset.removeEvent((IEvent)event);
                }
                PresetEditingWizardEventPage.this.tableInspector.getViewer().refresh();
            }
        };
        this.tableInspector.setContentProvider((IContentProvider)new EventTableContentProvider());
        return container;
    }

    private void populateUi() {
        this.tableInspector.setInput(this.preset);
    }

    private boolean displayWizard(IEvent event) {
        EventEditingWizard wizard = new EventEditingWizard(event);
        wizard.setHelpAvailable(false);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        return dialog.open() == 0;
    }

    private static class EventTableContentProvider
    extends AbstractStructuredContentProvider {
        private EventTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof IPreset)) {
                throw new IllegalArgumentException("input element must be an IPreset");
            }
            IPreset preset = (IPreset)inputElement;
            return preset.getEvents();
        }
    }

    private static abstract class EventTableLabelProvider
    extends ColumnLabelProvider {
        private EventTableLabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof IEvent)) {
                throw new IllegalArgumentException("element must be an IEvent");
            }
            return this.doGetText((IEvent)element);
        }

        protected abstract String doGetText(IEvent var1);
    }
}

